// License: GPL. For details, see LICENSE file.
package org.openstreetmap.josm.gui.layer.geoimage;

import static org.openstreetmap.josm.tools.I18n.tr;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.Layer.LayerAction;
import org.openstreetmap.josm.tools.ImageProvider;

/**
 * Toggle the the use of an external image viewer on and off.
 * @since
 */
public class UseExternalViewerAction extends AbstractAction implements LayerAction {

    private final transient GeoImageLayer layer;

    /**
     * Constructs a new {@code ToggleUseExtImageViewerAction} action.
     * @param layer image layer
     */
    public UseExternalViewerAction(GeoImageLayer layer) {
        super(tr("(Toggle) Use external viewer"), ImageProvider.get("dialogs/refresh"));
        putValue(SHORT_DESCRIPTION, tr("Use external image viewer (as well as internal viewer)."));
        this.layer = layer;
    }

    /**
     * This is called after the menu entry was selected.
     * @param arg0 action event
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        layer.setUseExternalViewer(!layer.isUseExternalViewer());
    }

    /** Create actual menu entry and define if it is enabled or not. */
    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem toggleItem = new JCheckBoxMenuItem(this);
        toggleItem.setEnabled(true);
        toggleItem.setState(layer.isUseExternalViewer());
        return toggleItem;
    }

    /** Check if the current layer is supported. */
    @Override
    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }
}
