// License: GPL. For details, see LICENSE file.
package org.apache.tools.bzip2;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Bzip2Test
{
    public static void main(String[] args) throws FileNotFoundException, IOException
    {
      FileOutputStream fos = null;
      CBZip2InputStream inputStream = null;
      try {
          FileInputStream fis = new FileInputStream("d:/tmp/josm-test/luxembourg-20140903_121227.osm.bz2");
          fis.read();
          fis.read();
          inputStream = new CBZip2InputStream(fis);
          fos = new FileOutputStream("d:/tmp/josm-test/luxembourg-20140903_121227.osm.test");
          byte[] b = new byte[1024];
          int length;
          while ((length = inputStream.read(b, 0, b.length)) != -1) {
              fos.write(b, 0, length);
          }
      }
      finally {
          close(fos);
          close(inputStream);
      }
    }

    private static void close(Closeable inputStream) {
      if(inputStream != null)
        try {
            inputStream.close();
        } catch (IOException e) {
            // ignore
        }
    }
}
