/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.latlon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LatLonDialog
extends ExtendedDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    public JTabbedPane tabs;
    private JTextArea taLatLon;
    private JRadioButton rbNodes;
    private JRadioButton rbWay;
    private JRadioButton rbClosedWay;
    private ButtonGroup bgType;
    private LatLon[] latLonCoordinates;
    private static final double ZERO = 0.0;
    private static final String DEG = "\u00b0";
    private static final String MIN = "\u2032";
    private static final String SEC = "\u2033";
    private static final String MIN_TYPO = "\u2019";
    private static final String SEC_TYPO = "\u201d";
    private static final char N_TR = LatLonParser.NORTH.charAt(0);
    private static final char S_TR = LatLonParser.SOUTH.charAt(0);
    private static final char E_TR = LatLonParser.EAST.charAt(0);
    private static final char W_TR = LatLonParser.WEST.charAt(0);
    private static final Pattern p = Pattern.compile("([+|-]?\\d+[.,]\\d+)|([+|-]?\\d+)|(\u00b0|o|deg)|('|\u2032|\u2019|min)|(\"|\u2033|\u201d|sec)|(,|;)|([NSEW" + N_TR + S_TR + E_TR + W_TR + "])|\\s+|(.+)");

    protected JPanel buildLatLon() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel(I18n.tr((String)"Coordinates:", (Object[])new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.taLatLon = new JTextArea(5, 24);
        this.taLatLon.getDocument().addDocumentListener(new CoordinateListener());
        JScrollPane spScroll = new JScrollPane(this.taLatLon);
        pnl.add((Component)spScroll, GBC.eol().insets(0, 10, 0, 0).fill().weight(2.0, 2.0));
        this.bgType = new ButtonGroup();
        this.rbNodes = new JRadioButton(I18n.tr((String)"Nodes", (Object[])new Object[0]), true);
        this.rbNodes.setActionCommand("nodes");
        this.bgType.add(this.rbNodes);
        pnl.add(this.rbNodes);
        this.rbWay = new JRadioButton(I18n.tr((String)"Way", (Object[])new Object[0]));
        this.rbWay.setActionCommand("way");
        this.bgType.add(this.rbWay);
        pnl.add(this.rbWay);
        this.rbClosedWay = new JRadioButton(I18n.tr((String)"Closed Way (Area)", (Object[])new Object[0]));
        this.rbClosedWay.setActionCommand("area");
        this.bgType.add(this.rbClosedWay);
        pnl.add((Component)this.rbClosedWay, GBC.eol());
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)new HtmlPanel(I18n.tr((String)"Enter the coordinates for the new nodes, one for each line.<br/>If you enter two lines with the same coordinates there will be generated duplicate nodes.<br/>You can separate longitude and latitude with space, comma or semicolon.<br/>Use positive numbers or N, E characters to indicate North or East cardinal direction.<br/>For South and West cardinal directions you can use either negative numbers or S, W characters.<br/>Coordinate value can be in one of three formats:<ul><li><i>degrees</i><tt>&deg;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt> <i>seconds</i><tt>&quot</tt></li></ul>Symbols <tt>&deg;</tt>, <tt>&#39;</tt>, <tt>&prime;</tt>, <tt>&quot;</tt>, <tt>&Prime;</tt> are optional.<br/><br/>Some examples:<ul><li>49.29918&deg; 19.24788&deg;</li><li>N 49.29918 E 19.24788</li><li>W 49&deg;29.918&#39; S 19&deg;24.788&#39;</li><li>N 49&deg;29&#39;04&quot; E 19&deg;24&#39;43&quot;</li><li>49.29918 N, 19.24788 E</li><li>49&deg;29&#39;21&quot; N 19&deg;24&#39;38&quot; E</li><li>49 29 51, 19 24 18</li><li>49 29, 19 24</li><li>E 49 29, N 19 24</li><li>49&deg; 29; 19&deg; 24</li><li>N 49&deg; 29, W 19&deg; 24</li><li>49&deg; 29.5 S, 19&deg; 24.6 E</li><li>N 49 29.918 E 19 15.88</li><li>49 29.4 19 24.5</li><li>-49 29.4 N -19 24.5 W</li></ul><li>48 deg 42&#39; 52.13\" N, 21 deg 11&#39; 47.60\" E</li></ul>", (Object[])new Object[0])), GBC.eol().fill().weight(1.0, 1.0));
        LatLonInputVerifier inputVerifier = new LatLonInputVerifier();
        this.taLatLon.getDocument().addDocumentListener(inputVerifier);
        TextFieldFocusHandler focusHandler = new TextFieldFocusHandler();
        this.taLatLon.addFocusListener(focusHandler);
        return pnl;
    }

    protected void build() {
        this.tabs = new JTabbedPane();
        this.tabs.addTab(I18n.tr((String)"Lat/Lon", (Object[])new Object[0]), this.buildLatLon());
        this.tabs.getModel().addChangeListener(e -> {
            if (this.tabs.getModel().getSelectedIndex() != 0) {
                throw new AssertionError();
            }
            this.parseLatLonUserInput();
        });
        this.setContent(this.tabs, false);
    }

    public LatLonDialog(Component parent, String title, String help) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Add Node...", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.setButtonIcons(new String[]{"ok", "cancel"});
        this.configureContextsensitiveHelp("/Action/AddNode", true);
        this.build();
        this.setCoordinates(null);
    }

    public void setCoordinates(LatLon[] ll) {
        if (ll == null) {
            ll = new LatLon[]{};
        }
        this.latLonCoordinates = ll;
        Object text = "";
        ICoordinateFormat format = CoordinateFormatManager.getDefaultFormat();
        for (LatLon latlon : ll) {
            text = (String)text + format.latToString((ILatLon)latlon) + " " + format.lonToString((ILatLon)latlon) + "\n";
        }
        this.taLatLon.setText((String)text);
        this.setOkEnabled(true);
    }

    public LatLon[] getCoordinates() {
        return this.latLonCoordinates;
    }

    public LatLon[] getLatLonCoordinates() {
        return this.latLonCoordinates;
    }

    public String getGeomType() {
        return this.bgType.getSelection().getActionCommand();
    }

    protected void setErrorFeedback(JTextArea tf, String message) {
        tf.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        tf.setToolTipText(message);
        tf.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JTextArea tf, String message) {
        tf.setBorder(UIManager.getBorder("TextField.border"));
        tf.setToolTipText(message);
        tf.setBackground(UIManager.getColor("TextField.background"));
    }

    protected Double parseDoubleFromUserInput(String input) {
        if (input == null) {
            return null;
        }
        input = input.trim();
        input = input.replaceAll(DEG, "");
        NumberFormat f = NumberFormat.getNumberInstance();
        ParsePosition pp = new ParsePosition(0);
        Number n = f.parse(input, pp);
        if (pp.getErrorIndex() >= 0 || pp.getIndex() < input.length()) {
            pp = new ParsePosition(0);
            f = NumberFormat.getNumberInstance(Locale.ENGLISH);
            n = f.parse(input, pp);
            if (pp.getErrorIndex() >= 0 || pp.getIndex() < input.length()) {
                return null;
            }
        }
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    protected void parseLatLonUserInput() {
        LatLon[] latLons;
        try {
            latLons = LatLonDialog.parseLatLons(this.taLatLon.getText());
            boolean working = true;
            for (int i = 0; working && i < latLons.length; ++i) {
                if (LatLon.isValidLat((double)latLons[i].lat()) && LatLon.isValidLon((double)latLons[i].lon())) continue;
                latLons = null;
                working = false;
            }
        }
        catch (IllegalArgumentException e) {
            latLons = null;
        }
        if (latLons == null) {
            this.setErrorFeedback(this.taLatLon, I18n.tr((String)"Please enter a GPS coordinates", (Object[])new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.taLatLon, I18n.tr((String)"Please enter a GPS coordinates", (Object[])new Object[0]));
            this.latLonCoordinates = latLons;
            this.setOkEnabled(true);
        }
    }

    private void setOkEnabled(boolean b) {
        if (this.buttons != null && !this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(b);
        }
    }

    public void setVisible(boolean visible) {
        String preferenceKey = ((Object)((Object)this)).getClass().getName() + ".geometry";
        if (visible) {
            new WindowGeometry(preferenceKey, WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)this.getSize())).applySafe((Window)((Object)this));
            this.taLatLon.requestFocusInWindow();
        } else {
            new WindowGeometry((Window)((Object)this)).remember(preferenceKey);
        }
        super.setVisible(visible);
    }

    private static LatLon[] parseLatLons(String text) {
        String[] lines = text.split("\\r?\\n");
        ArrayList<LatLon> latLons = new ArrayList<LatLon>();
        for (String line : lines) {
            latLons.add(LatLonDialog.parseLatLon(line));
        }
        return latLons.toArray(new LatLon[0]);
    }

    private static LatLon parseLatLon(String coord) {
        Matcher m = p.matcher(coord);
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        while (m.find()) {
            if (m.group(1) != null) {
                sb.append('R');
                list.add(Double.parseDouble(m.group(1).replace(',', '.')));
                continue;
            }
            if (m.group(2) != null) {
                sb.append('Z');
                list.add(Double.parseDouble(m.group(2)));
                continue;
            }
            if (m.group(3) != null) {
                sb.append('o');
                continue;
            }
            if (m.group(4) != null) {
                sb.append('\'');
                continue;
            }
            if (m.group(5) != null) {
                sb.append('\"');
                continue;
            }
            if (m.group(6) != null) {
                sb.append(',');
                continue;
            }
            if (m.group(7) != null) {
                sb.append("x");
                String c = m.group(7).toUpperCase(Locale.ROOT);
                if ("N".equals(c) || "S".equals(c) || "E".equals(c) || "W".equals(c)) {
                    list.add(c);
                    continue;
                }
                list.add(c.replace(N_TR, 'N').replace(S_TR, 'S').replace(E_TR, 'E').replace(W_TR, 'W'));
                continue;
            }
            if (m.group(8) == null) continue;
            throw new IllegalArgumentException("invalid token: " + m.group(8));
        }
        String pattern = sb.toString();
        Object[] params = list.toArray();
        LatLonHolder latLon = new LatLonHolder();
        if (pattern.matches("Ro?,?Ro?")) {
            LatLonDialog.setLatLonObj(latLon, params[0], 0.0, 0.0, "N", params[1], 0.0, 0.0, "E");
        } else if (pattern.matches("xRo?,?xRo?")) {
            LatLonDialog.setLatLonObj(latLon, params[1], 0.0, 0.0, params[0], params[3], 0.0, 0.0, params[2]);
        } else if (pattern.matches("Ro?x,?Ro?x")) {
            LatLonDialog.setLatLonObj(latLon, params[0], 0.0, 0.0, params[1], params[2], 0.0, 0.0, params[3]);
        } else if (pattern.matches("Zo[RZ]'?,?Zo[RZ]'?|Z[RZ],?Z[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], 0.0, "N", params[2], params[3], 0.0, "E");
        } else if (pattern.matches("xZo[RZ]'?,?xZo[RZ]'?|xZo?[RZ],?xZo?[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[1], params[2], 0.0, params[0], params[4], params[5], 0.0, params[3]);
        } else if (pattern.matches("Zo[RZ]'?x,?Zo[RZ]'?x|Zo?[RZ]x,?Zo?[RZ]x")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], 0.0, params[2], params[3], params[4], 0.0, params[5]);
        } else if (pattern.matches("ZoZ'[RZ]\"?x,?ZoZ'[RZ]\"?x|ZZ[RZ]x,?ZZ[RZ]x")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
        } else if (pattern.matches("xZoZ'[RZ]\"?,?xZoZ'[RZ]\"?|xZZ[RZ],?xZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[1], params[2], params[3], params[0], params[5], params[6], params[7], params[4]);
        } else if (pattern.matches("ZZ[RZ],?ZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], params[2], "N", params[3], params[4], params[5], "E");
        } else {
            throw new IllegalArgumentException("invalid format: " + pattern);
        }
        return new LatLon(latLon.lat, latLon.lon);
    }

    private static void setLatLonObj(LatLonHolder latLon, Object coord1deg, Object coord1min, Object coord1sec, Object card1, Object coord2deg, Object coord2min, Object coord2sec, Object card2) {
        LatLonDialog.setLatLon(latLon, (Double)coord1deg, (Double)coord1min, (Double)coord1sec, (String)card1, (Double)coord2deg, (Double)coord2min, (Double)coord2sec, (String)card2);
    }

    private static void setLatLon(LatLonHolder latLon, double coord1deg, double coord1min, double coord1sec, String card1, double coord2deg, double coord2min, double coord2sec, String card2) {
        LatLonDialog.setLatLon(latLon, coord1deg, coord1min, coord1sec, card1);
        LatLonDialog.setLatLon(latLon, coord2deg, coord2min, coord2sec, card2);
    }

    private static void setLatLon(LatLonHolder latLon, double coordDeg, double coordMin, double coordSec, String card) {
        if (coordDeg < -180.0 || coordDeg > 180.0 || coordMin < 0.0 || coordMin >= 60.0 || coordSec < 0.0 || coordSec > 60.0) {
            throw new IllegalArgumentException("out of range");
        }
        double coord = (double)(coordDeg < 0.0 ? -1 : 1) * (Math.abs(coordDeg) + coordMin / 60.0 + coordSec / 3600.0);
        double d = coord = "N".equals(card) || "E".equals(card) ? coord : -coord;
        if ("N".equals(card) || "S".equals(card)) {
            latLon.lat = coord;
        } else {
            latLon.lon = coord;
        }
    }

    public String getLatLonText() {
        return this.taLatLon.getText();
    }

    public void setLatLonText(String text) {
        this.taLatLon.setText(text);
    }

    private class CoordinateListener
    implements DocumentListener {
        private CoordinateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateButtons();
        }

        private void updateButtons() {
            String text = LatLonDialog.this.taLatLon.getText();
            String[] lines = text.split("\r\n|\r|\n");
            LatLonDialog.this.rbNodes.setEnabled(true);
            LatLonDialog.this.rbWay.setEnabled(true);
            LatLonDialog.this.rbClosedWay.setEnabled(true);
            if (lines.length < 3) {
                LatLonDialog.this.rbClosedWay.setEnabled(false);
                LatLonDialog.this.bgType.setSelected(LatLonDialog.this.rbNodes.getModel(), true);
            }
            if (lines.length < 2) {
                LatLonDialog.this.rbWay.setEnabled(false);
                LatLonDialog.this.bgType.setSelected(LatLonDialog.this.rbNodes.getModel(), true);
            }
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTextArea) {
                JTextArea tf = (JTextArea)c;
                tf.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private static class LatLonHolder {
        double lat;
        double lon;

        private LatLonHolder() {
        }
    }
}

