/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.customurl;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.ChooseURLAction;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.URLList;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public final class OpenPageAction
extends JosmAction {
    public OpenPageAction() {
        super(I18n.tr((String)"Open custom URL", (Object[])new Object[0]), "openurl", I18n.tr((String)"Opens specified URL browser", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:openurl", (String)I18n.tr((String)"Data: {0}", (Object[])new Object[]{I18n.tr((String)"Open custom URL", (Object[])new Object[0])}), (int)72, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/OpenPage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        Collection sel = this.getLayerManager().getActiveDataSet().getSelected();
        OsmPrimitive p = null;
        if (!sel.isEmpty()) {
            p = (OsmPrimitive)sel.iterator().next();
        }
        if (Config.getPref().getBoolean("utilsplugin2.askurl", false) && 1 != ChooseURLAction.showConfigDialog(true)) {
            return;
        }
        MapView mv = MainApplication.getMap().mapView;
        LatLon center = mv.getLatLon(mv.getWidth() / 2, mv.getHeight() / 2);
        String addr = URLList.getSelectedURL();
        Pattern pat = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = pat.matcher(addr);
        String[] keys = new String[100];
        String[] vals = new String[100];
        int i = 0;
        try {
            while (m.find()) {
                String key = m.group(1);
                String val = null;
                if ("#id".equals(key)) {
                    if (p == null) return;
                    val = Long.toString(p.getId());
                } else if ("#type".equals(key)) {
                    if (p != null) {
                        val = OsmPrimitiveType.from((IPrimitive)p).getAPIName();
                    }
                } else if ("#lat".equals(key)) {
                    val = Double.toString(center.lat());
                } else if ("#lon".equals(key)) {
                    val = Double.toString(center.lon());
                } else if ("#zoom".equals(key)) {
                    val = Integer.toString(OsmUrlToBounds.getZoom((Bounds)MainApplication.getMap().mapView.getRealBounds()));
                } else if (p != null) {
                    val = p.get(key);
                    if (val == null) return;
                    val = URLEncoder.encode(p.get(key), "UTF-8");
                }
                keys[i] = m.group();
                vals[i] = val != null ? val : "";
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            Logging.log((Level)Logging.LEVEL_ERROR, (String)"Encoding error", (Throwable)ex);
            return;
        }
        for (int j = 0; j < i; ++j) {
            addr = addr.replace(keys[j], vals[j]);
        }
        Pattern pat_direct = Pattern.compile("local:(http.*)$");
        Matcher m_direct = pat_direct.matcher(addr);
        try {
            if (m_direct.find()) {
                addr = m_direct.group(1);
                Logging.info((String)("Opening on the local system: " + addr));
                URL url = new URL(addr);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setRequestMethod("GET");
                if (urlConn.getResponseCode() == 200) return;
                throw new IOException(". GET response:" + urlConn.getResponseCode());
            }
            if (addr.endsWith("/0/history")) return;
            OpenBrowser.displayUrl((String)addr);
            return;
        }
        catch (Exception ex) {
            Logging.log((Level)Logging.LEVEL_ERROR, (String)("Can not open URL " + addr), (Throwable)ex);
        }
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveDataSet() != null);
    }
}

