/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.util;

import java.util.Collection;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.util.TagCondition;
import org.openstreetmap.josm.tools.I18n;

public final class TagConditionLogic {
    private TagConditionLogic() {
    }

    public static TagCondition tag(final Tag tag) {
        assert (tag != null);
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                return tags.contains(tag);
            }

            public String toString() {
                return tag.toString();
            }
        };
    }

    public static TagCondition key(final String key) {
        assert (key != null);
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                return tags.containsKey(key);
            }

            public String toString() {
                return key;
            }
        };
    }

    public static TagCondition and(final TagCondition condition, final TagCondition ... conditions) {
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                for (TagCondition c : conditions) {
                    if (c.matches(tags)) continue;
                    return false;
                }
                return condition.matches(tags);
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                result.append("(");
                result.append(condition);
                for (TagCondition c : conditions) {
                    result.append(" && ");
                    result.append(c);
                }
                result.append(")");
                return result.toString();
            }
        };
    }

    public static TagCondition and(final Collection<TagCondition> conditions) {
        if (conditions.size() == 0) {
            throw new IllegalArgumentException(I18n.tr((String)"Collection must contain at least one condition", (Object[])new Object[0]));
        }
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                for (TagCondition c : conditions) {
                    if (c.matches(tags)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                result.append("(");
                boolean firstCondition = true;
                for (TagCondition c : conditions) {
                    if (!firstCondition) {
                        result.append(" && ");
                    }
                    firstCondition = false;
                    result.append(c);
                }
                result.append(")");
                return result.toString();
            }
        };
    }

    public static TagCondition or(final TagCondition condition, final TagCondition ... conditions) {
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                for (TagCondition c : conditions) {
                    if (!c.matches(tags)) continue;
                    return true;
                }
                return condition.matches(tags);
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                result.append("(");
                result.append(condition);
                for (TagCondition c : conditions) {
                    result.append(" || ");
                    result.append(c);
                }
                result.append(")");
                return result.toString();
            }
        };
    }

    public static TagCondition or(final Collection<TagCondition> conditions) {
        if (conditions.size() == 0) {
            throw new IllegalArgumentException(I18n.tr((String)"Collection must contain at least one condition", (Object[])new Object[0]));
        }
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                for (TagCondition c : conditions) {
                    if (!c.matches(tags)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                result.append("(");
                boolean firstCondition = true;
                for (TagCondition c : conditions) {
                    if (!firstCondition) {
                        result.append(" || ");
                    }
                    firstCondition = false;
                    result.append(c);
                }
                result.append(")");
                return result.toString();
            }
        };
    }

    public static TagCondition not(final TagCondition condition) {
        return new TagCondition(){

            @Override
            public boolean matches(TagGroup tags) {
                return !condition.matches(tags);
            }

            public String toString() {
                return "!" + String.valueOf(condition);
            }
        };
    }
}

