/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractOrigin;

final class InputStreamByteSource
extends ByteSource {
    private static final int BLOCK_SIZE = 8192;
    private final InputStream inputStream;
    private final Block headBlock;
    private long streamLength = -1L;

    InputStreamByteSource(InputStream inputStream, String fileName) throws IOException {
        super(new AbstractOrigin.InputStreamOrigin(inputStream), fileName);
        this.inputStream = new BufferedInputStream(inputStream);
        this.headBlock = this.readBlock();
    }

    @Override
    public byte[] getByteArray(long position, int length) throws IOException {
        int read;
        if (position < 0L || length < 0 || position + (long)length < 0L || position + (long)length > this.size()) {
            throw new ImagingException("Could not read block (block start: " + position + ", block length: " + length + ", data length: " + this.streamLength + ").");
        }
        InputStream cis = this.getInputStream();
        BinaryFunctions.skipBytes(cis, position);
        byte[] bytes = Allocator.byteArray(length);
        int total = 0;
        do {
            if ((read = cis.read(bytes, total, bytes.length - total)) >= 1) continue;
            throw new ImagingException("Could not read block.");
        } while ((total += read) < length);
        return bytes;
    }

    private Block getFirstBlock() throws IOException {
        return this.headBlock;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BlockInputStream();
    }

    private Block readBlock() throws IOException {
        byte[] readBuffer = new byte[8192];
        int read = this.inputStream.read(readBuffer);
        if (read < 1) {
            return null;
        }
        if (read < readBuffer.length) {
            return new Block(Arrays.copyOf(readBuffer, read));
        }
        return new Block(readBuffer);
    }

    @Override
    public long size() throws IOException {
        if (this.streamLength >= 0L) {
            return this.streamLength;
        }
        try (InputStream cis = this.getInputStream();){
            long l = this.streamLength = IOUtils.consume(cis);
            return l;
        }
    }

    private final class Block {
        final byte[] bytes;
        private Block next;
        private boolean triedNext;

        Block(byte[] bytes) {
            this.bytes = Objects.requireNonNull(bytes);
        }

        Block getNext() throws IOException {
            if (this.next != null) {
                return this.next;
            }
            if (this.triedNext) {
                return null;
            }
            this.triedNext = true;
            this.next = InputStreamByteSource.this.readBlock();
            return this.next;
        }

        int length() {
            return this.bytes.length;
        }
    }

    private final class BlockInputStream
    extends InputStream {
        private Block block;
        private boolean readFirst;
        private int blockIndex;

        private BlockInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.block == null) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = InputStreamByteSource.this.getFirstBlock();
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.length()) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (this.block == null) {
                return -1;
            }
            if (this.blockIndex >= this.block.length()) {
                return -1;
            }
            return 0xFF & this.block.bytes[this.blockIndex++];
        }

        @Override
        public int read(byte[] array, int off, int len) throws IOException {
            Objects.requireNonNull(array, "array");
            if (off < 0 || off > array.length || len < 0 || off + len > array.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.block == null) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = InputStreamByteSource.this.getFirstBlock();
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.length()) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (this.block == null) {
                return -1;
            }
            if (this.blockIndex >= this.block.length()) {
                return -1;
            }
            int readSize = Math.min(len, this.block.length() - this.blockIndex);
            System.arraycopy(this.block.bytes, this.blockIndex, array, off, readSize);
            this.blockIndex += readSize;
            return readSize;
        }

        @Override
        public long skip(long n) throws IOException {
            long remaining;
            int readSize;
            if (n <= 0L) {
                return 0L;
            }
            for (remaining = n; remaining > 0L; remaining -= (long)readSize) {
                if (this.block == null) {
                    if (this.readFirst) {
                        return -1L;
                    }
                    this.block = InputStreamByteSource.this.getFirstBlock();
                    this.readFirst = true;
                }
                if (this.block != null && this.blockIndex >= this.block.length()) {
                    this.block = this.block.getNext();
                    this.blockIndex = 0;
                }
                if (this.block == null || this.blockIndex >= this.block.length()) break;
                readSize = Math.min((int)Math.min(8192L, remaining), this.block.length() - this.blockIndex);
                this.blockIndex += readSize;
            }
            return n - remaining;
        }
    }
}

