/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.data.WorldFileReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.openstreetmap.josm.tools.Logging;

public final class PluginOperations {
    static List<String> crsDescriptions;
    static CoordinateReferenceSystem defaultSourceCRS;
    static String defaultSourceCRSDescription;

    private PluginOperations() {
    }

    public static GridCoverage2D reprojectCoverage(GridCoverage2D coverage, CoordinateReferenceSystem targetCrs) {
        CoverageProcessor processor = new CoverageProcessor();
        ParameterValueGroup resampleParams = processor.getOperation("Resample").getParameters();
        resampleParams.parameter("Source").setValue((Object)coverage);
        resampleParams.parameter("CoordinateReferenceSystem").setValue((Object)targetCrs);
        GridCoverage2D destination = (GridCoverage2D)processor.doOperation(resampleParams);
        return destination;
    }

    public static GridCoverage2D createGridFromFile(File file, CoordinateReferenceSystem refSys, boolean failIfNoPrjFile) throws IOException {
        GridCoverage2D coverage;
        if (!file.exists()) {
            throw new FileNotFoundException("File not found.");
        }
        int dotPos = file.getAbsolutePath().lastIndexOf(".");
        String extension = file.getAbsolutePath().substring(dotPos);
        String fileNameWithoutExt = file.getAbsolutePath().substring(0, dotPos);
        if (".tif".equalsIgnoreCase(extension) || ".tiff".equalsIgnoreCase(extension)) {
            try {
                GridCoverage2D coverage2 = PluginOperations.readGeoTiff(file, refSys);
                return coverage2;
            }
            catch (DataSourceException dse) {
                BufferedImage img;
                if (!dse.getMessage().contains("Coordinate Reference System is not available")) {
                    Logging.error((Throwable)dse);
                } else {
                    Logging.trace((Throwable)dse);
                }
                String[] postfixes = new String[]{"wld", "tfw", "tifw"};
                WorldFileReader tfwReader = null;
                for (String postfix : postfixes) {
                    File prjFile = new File(fileNameWithoutExt + "." + postfix);
                    if (!prjFile.exists()) continue;
                    tfwReader = new WorldFileReader(prjFile);
                }
                if (tfwReader == null) {
                    throw new IOException("No Worldfile found.");
                }
                if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                    if (failIfNoPrjFile) {
                        throw new IOException("No projection file found.");
                    }
                    Logging.debug((String)"no projection given, no projection file found; using unprojected file.");
                }
                if ((img = ImageIO.read(file)) == null) {
                    throw new IOException("Cannot read image file " + file.getAbsolutePath());
                }
                double width = (double)img.getWidth() * tfwReader.getXPixelSize();
                double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
                double lowerLeft_x = tfwReader.getXULC();
                double lowerLeft_y = tfwReader.getYULC() - height;
                ReferencedEnvelope bbox = ReferencedEnvelope.rect((double)lowerLeft_x, (double)lowerLeft_y, (double)width, (double)height, null);
                coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
            }
        } else if (".jpg".equalsIgnoreCase(extension) || ".jpeg".equalsIgnoreCase(extension)) {
            String[] postfixes = new String[]{"wld", "jgw", "jpgw"};
            WorldFileReader tfwReader = null;
            for (String postfix : postfixes) {
                File prjFile = new File(fileNameWithoutExt + "." + postfix);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                Logging.debug((String)"no projection given, no projection file found; using unprojected file.");
            }
            BufferedImage img = ImageIO.read(file);
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            ReferencedEnvelope bbox = ReferencedEnvelope.rect((double)lowerLeft_x, (double)lowerLeft_y, (double)width, (double)height, null);
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else if (".bmp".equalsIgnoreCase(extension)) {
            String[] postfixes = new String[]{"wld", "bmpw", "bpw"};
            WorldFileReader tfwReader = null;
            for (String postfix : postfixes) {
                File prjFile = new File(fileNameWithoutExt + "." + postfix);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                Logging.debug((String)"no projection given, no projection file found; using unprojected file.");
            }
            BufferedImage img = ImageIO.read(file);
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            ReferencedEnvelope bbox = ReferencedEnvelope.rect((double)lowerLeft_x, (double)lowerLeft_y, (double)width, (double)height, null);
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else if (".png".equalsIgnoreCase(extension)) {
            String[] postfixes = new String[]{"wld", "pgw", "pngw"};
            WorldFileReader tfwReader = null;
            for (String postfix : postfixes) {
                File prjFile = new File(fileNameWithoutExt + "." + postfix);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                Logging.debug((String)"no projection given, no projection file found; using unprojected file.");
            }
            BufferedImage img = ImageIO.read(file);
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            ReferencedEnvelope bbox = ReferencedEnvelope.rect((double)lowerLeft_x, (double)lowerLeft_y, (double)width, (double)height, null);
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else {
            throw new IOException("Image type not supported. Supported formats are: \n" + Arrays.toString((Object[])SUPPORTEDIMAGETYPES.values()));
        }
        return coverage;
    }

    public static CoordinateReferenceSystem readPrjFile(File file) throws IOException {
        CoordinateReferenceSystem refSys;
        int dotPos = file.getAbsolutePath().lastIndexOf(".");
        String prjFilename = file.getAbsolutePath().substring(0, dotPos) + ".prj";
        File prjFile = new File(prjFilename);
        if (!prjFile.exists()) {
            return null;
        }
        Logging.debug((String)("Loading .prj file: " + prjFile.getAbsolutePath()));
        try (BufferedReader br = Files.newBufferedReader(prjFile.toPath());){
            String content;
            StringBuilder sb = new StringBuilder();
            while ((content = br.readLine()) != null) {
                sb.append(content);
            }
            refSys = CRS.parseWKT((String)sb.toString().trim());
        }
        catch (FactoryException e) {
            throw new IOException("Unable to parse prj-file: '" + prjFile.getName() + "'", e);
        }
        return refSys;
    }

    public static GridCoverage2D createGridCoverage(BufferedImage img, ReferencedEnvelope bbox, CoordinateReferenceSystem crs) {
        bbox.setCoordinateReferenceSystem(crs);
        return new GridCoverageFactory().create((CharSequence)"", (RenderedImage)img, (Bounds)bbox);
    }

    public static GridCoverage2D readGeoTiff(File file, CoordinateReferenceSystem refSys) throws IOException {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        if (refSys != null) {
            hints.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)refSys);
        }
        GeoTiffReader reader = new GeoTiffReader((Object)file, hints);
        GridCoverage2D coverage = reader.read(null);
        return coverage;
    }

    public static void loadCRSData(Properties pluginProps) {
        String defaultcrsString = pluginProps.getProperty("default_crs_srid");
        crsDescriptions = new Vector<String>();
        Set supportedCodes = CRS.getSupportedCodes((String)"EPSG");
        CRSAuthorityFactory fac = CRS.getAuthorityFactory((boolean)false);
        for (String string : supportedCodes) {
            try {
                if ("WGS84(DD)".equals(string)) continue;
                InternationalString desc = fac.getDescriptionText("EPSG:" + string);
                String description = desc.toString() + " [-EPSG:" + string + "-]";
                crsDescriptions.add(description);
                if (defaultcrsString == null || !defaultcrsString.equalsIgnoreCase("EPSG:" + string)) continue;
                boolean isEastingFirst = Boolean.parseBoolean(pluginProps.getProperty("default_crs_eastingfirst"));
                defaultSourceCRS = CRS.decode((String)("EPSG:" + string), (boolean)isEastingFirst);
                defaultSourceCRSDescription = description;
            }
            catch (FactoryException e) {
                Logging.error((String)("Error while loading EPSG data: " + e.getMessage()));
                Logging.error((Throwable)e);
            }
        }
    }

    public static enum SUPPORTEDIMAGETYPES {
        tiff,
        tif,
        jpg,
        jpeg,
        bmp,
        png;

    }

    public static enum POSTFIXES_WORLDFILE {
        wld,
        jgw,
        jpgw,
        pgw,
        pngw,
        tfw,
        tifw,
        bpw,
        bmpw;

    }
}

