/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.seamapeditor.panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.plugins.seamapeditor.SmedAction;
import org.openstreetmap.josm.plugins.seamapeditor.messages.Messages;
import org.openstreetmap.josm.plugins.seamapeditor.panels.PanelPat;
import org.openstreetmap.josm.plugins.seamapeditor.seamarks.SeaMark;

public class PanelTop
extends JPanel {
    private SmedAction dlg;
    public PanelPat panelPat = null;
    private ButtonGroup topButtons = new ButtonGroup();
    public JRadioButton noTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/OffButton.png")));
    public JRadioButton canTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/CanTopButton.png")));
    public JRadioButton coneTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/ConeTopButton.png")));
    public JRadioButton sphereTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SphereTopButton.png")));
    public JRadioButton XTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/XTopButton.png")));
    public JRadioButton northTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/NorthTopButton.png")));
    public JRadioButton southTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SouthTopButton.png")));
    public JRadioButton eastTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/EastTopButton.png")));
    public JRadioButton westTopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/WestTopButton.png")));
    public JRadioButton spheres2TopButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/Spheres2TopButton.png")));
    public JRadioButton boardDayButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BoardDayButton.png")));
    public JRadioButton rhombusDayButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/DiamondDayButton.png")));
    public JRadioButton triangleDayButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/TriangleDayButton.png")));
    public JRadioButton triangleInvDayButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/TriangleInvDayButton.png")));
    public JRadioButton squareDayButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SquareDayButton.png")));
    public JRadioButton circleDayButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/CircleDayButton.png")));
    private EnumMap<SeaMark.Top, JRadioButton> tops = new EnumMap(SeaMark.Top.class);
    private ActionListener alTop = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Top top : PanelTop.this.tops.keySet()) {
                JRadioButton button = PanelTop.this.tops.get((Object)top);
                if (button.isSelected()) {
                    SmedAction.panelMain.mark.setTopmark(top);
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
        }
    };

    public PanelTop(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.panelPat = new PanelPat(this.dlg, SeaMark.Ent.TOPMARK);
        this.panelPat.setBounds(new Rectangle(160, 0, 110, 160));
        this.add(this.panelPat);
        this.add(this.getTopButton(this.noTopButton, 0, 5, 27, 27, "NoTop", SeaMark.Top.NOTOP));
        this.add(this.getTopButton(this.canTopButton, 30, 5, 27, 27, "CanTop", SeaMark.Top.CYL));
        this.add(this.getTopButton(this.coneTopButton, 60, 5, 27, 27, "ConeTop", SeaMark.Top.CONE));
        this.add(this.getTopButton(this.sphereTopButton, 90, 5, 27, 27, "SphereTop", SeaMark.Top.SPHERE));
        this.add(this.getTopButton(this.XTopButton, 120, 5, 27, 27, "XTop", SeaMark.Top.X_SHAPE));
        this.add(this.getTopButton(this.northTopButton, 0, 35, 27, 27, "NorthTop", SeaMark.Top.NORTH));
        this.add(this.getTopButton(this.southTopButton, 30, 35, 27, 27, "SouthTop", SeaMark.Top.SOUTH));
        this.add(this.getTopButton(this.eastTopButton, 60, 35, 27, 27, "EastTop", SeaMark.Top.EAST));
        this.add(this.getTopButton(this.westTopButton, 90, 35, 27, 27, "WestTop", SeaMark.Top.WEST));
        this.add(this.getTopButton(this.spheres2TopButton, 120, 35, 27, 27, "Spheres2Top", SeaMark.Top.SPHERES2));
        this.add(this.getTopButton(this.boardDayButton, 0, 65, 27, 27, "BoardDay", SeaMark.Top.BOARD));
        this.add(this.getTopButton(this.rhombusDayButton, 30, 65, 27, 27, "DiamondDay", SeaMark.Top.RHOMBUS));
        this.add(this.getTopButton(this.triangleDayButton, 60, 65, 27, 27, "TriangleDay", SeaMark.Top.TRIANGLE));
        this.add(this.getTopButton(this.triangleInvDayButton, 90, 65, 27, 27, "TriangleInvDay", SeaMark.Top.TRIANGLE_INV));
        this.add(this.getTopButton(this.squareDayButton, 120, 65, 27, 27, "SquareDay", SeaMark.Top.SQUARE));
        this.add(this.getTopButton(this.circleDayButton, 120, 95, 27, 27, "CircleDay", SeaMark.Top.CIRCLE));
    }

    public void enableAll(boolean state) {
        for (JRadioButton button : this.tops.values()) {
            button.setEnabled(state);
        }
    }

    public void syncPanel() {
        for (SeaMark.Top top : this.tops.keySet()) {
            JRadioButton button = this.tops.get((Object)top);
            if (SmedAction.panelMain.mark.getTopmark() == top) {
                button.setBorderPainted(true);
                continue;
            }
            button.setBorderPainted(false);
        }
        this.panelPat.syncPanel();
    }

    private JRadioButton getTopButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Top top) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alTop);
        this.topButtons.add(button);
        this.tops.put(top, button);
        return button;
    }
}

