/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.mylzw;

import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.mylzw.MyBitInputStream;

public class BitsToByteInputStream
extends FilterInputStream {
    private final int desiredDepth;

    public BitsToByteInputStream(MyBitInputStream is, int desiredDepth) {
        super(is);
        this.desiredDepth = desiredDepth;
    }

    @Override
    public int read() throws IOException {
        return this.readBits(8);
    }

    public int readBits(int bitCount) throws IOException {
        int i = ((MyBitInputStream)this.in).readBits(bitCount);
        if (bitCount < this.desiredDepth) {
            i <<= this.desiredDepth - bitCount;
        } else if (bitCount > this.desiredDepth) {
            i >>= bitCount - this.desiredDepth;
        }
        return i;
    }

    public int[] readBitsArray(int sampleBits, int length) throws IOException {
        int[] result = Allocator.intArray(length);
        for (int i = 0; i < length; ++i) {
            result[i] = this.readBits(sampleBits);
        }
        return result;
    }
}

