/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.roadsigns.javacc.ParamStringScanner;
import org.openstreetmap.josm.plugins.roadsigns.javacc.ParseException;
import org.openstreetmap.josm.plugins.roadsigns.javacc.TokenMgrError;
import org.openstreetmap.josm.tools.Logging;

public class ParametrizedString {
    final List<StringOrParameter> token = new ArrayList<StringOrParameter>();

    protected ParametrizedString(String input) throws ParseException, TokenMgrError {
        this.scan(input);
    }

    public static ParametrizedString create(String input) throws ParseException, TokenMgrError {
        if (input == null) {
            return null;
        }
        return new ParametrizedString(input);
    }

    protected void scan(String input) throws ParseException, TokenMgrError {
        List<StringOrParameter> tmp = null;
        tmp = ParamStringScanner.parseIt(input);
        StringBuilder curString = new StringBuilder();
        for (StringOrParameter sp : tmp) {
            if (sp instanceof Prm) {
                if (curString.length() > 0) {
                    this.token.add(new Str(curString.toString()));
                    curString = new StringBuilder();
                }
                this.token.add(sp);
                continue;
            }
            if (!(sp instanceof Str)) continue;
            curString.append(((Str)sp).value);
        }
        if (curString.length() > 0) {
            this.token.add(new Str(curString.toString()));
        }
    }

    public String evaluate(Map<String, String> env) {
        StringBuilder sb = new StringBuilder();
        for (StringOrParameter t : this.token) {
            if (t instanceof Str) {
                sb.append(((Str)t).value);
                continue;
            }
            if (t instanceof Prm) {
                String val = env.get(((Prm)t).ident);
                if (val == null) {
                    Logging.warn((String)("Parameter not in environment: " + ((Prm)t).ident + " (" + this.toString() + ")"));
                    Thread.dumpStack();
                    val = "<?>";
                }
                sb.append(val);
                continue;
            }
            throw new AssertionError();
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StringOrParameter t : this.token) {
            if (t instanceof Str) {
                sb.append(((Str)t).value);
                continue;
            }
            if (t instanceof Prm) {
                sb.append("${" + ((Prm)t).ident + "}");
                continue;
            }
            throw new AssertionError();
        }
        return sb.toString();
    }

    public String toDebugString() {
        StringBuilder res = new StringBuilder();
        for (StringOrParameter sop : this.token) {
            res.append(sop);
        }
        return res.toString();
    }

    public static interface StringOrParameter {
    }

    public static class Prm
    implements StringOrParameter {
        public final String ident;

        public Prm(String ident) {
            this.ident = ident;
        }

        public String toString() {
            return "<Prm=" + this.ident + ">";
        }
    }

    public static class Str
    implements StringOrParameter {
        String value;

        public Str(String stringValue) {
            this.value = stringValue;
        }

        public String toString() {
            return "<Str=" + this.value + ">";
        }
    }
}

