/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.UnitDimension;

public class Units
extends AbstractSystemOfUnits {
    private static final Units INSTANCE = new Units();
    public static final Unit<ElectricCurrent> AMPERE = Units.addUnit(new BaseUnit("A", "Ampere", UnitDimension.ELECTRIC_CURRENT), ElectricCurrent.class);
    public static final Unit<LuminousIntensity> CANDELA = Units.addUnit(new BaseUnit("cd", "Candela", UnitDimension.LUMINOUS_INTENSITY), LuminousIntensity.class);
    public static final Unit<Temperature> KELVIN = Units.addUnit(new BaseUnit("K", "Kelvin", UnitDimension.TEMPERATURE), Temperature.class);
    public static final Unit<Mass> KILOGRAM = Units.addUnit(new BaseUnit("kg", "Kilogram", UnitDimension.MASS), Mass.class);
    public static final Unit<Length> METRE = Units.addUnit(new BaseUnit("m", "Metre", UnitDimension.LENGTH), Length.class);
    public static final Unit<AmountOfSubstance> MOLE = Units.addUnit(new BaseUnit("mol", "Mole", UnitDimension.AMOUNT_OF_SUBSTANCE), AmountOfSubstance.class);
    public static final Unit<Time> SECOND = Units.addUnit(new BaseUnit("s", "Second", UnitDimension.TIME), Time.class);
    public static final Unit<Mass> GRAM = Units.addUnit(KILOGRAM.divide(1000.0), "Gram");
    public static final Unit<Angle> RADIAN = Units.addUnit(AlternateUnit.of(AbstractUnit.ONE, "rad", "Radian"), Angle.class);
    public static final Unit<SolidAngle> STERADIAN = Units.addUnit(new AlternateUnit(AbstractUnit.ONE, "sr", "Steradian"), SolidAngle.class);
    public static final Unit<Frequency> HERTZ = Units.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(SECOND), "Hz", "Hertz"), Frequency.class);
    public static final Unit<Force> NEWTON = Units.addUnit(new AlternateUnit(METRE.multiply(KILOGRAM).divide(SECOND.pow(2)), "N", "Newton"), Force.class);
    public static final Unit<Pressure> PASCAL = Units.addUnit(new AlternateUnit(NEWTON.divide(METRE.pow(2)), "Pa", "Pascal"), Pressure.class);
    public static final Unit<Energy> JOULE = Units.addUnit(new AlternateUnit(NEWTON.multiply(METRE), "J", "Joule"), Energy.class);
    public static final Unit<Power> WATT = Units.addUnit(new AlternateUnit(JOULE.divide(SECOND), "W", "Watt"), Power.class);
    public static final Unit<ElectricCharge> COULOMB = Units.addUnit(new AlternateUnit(SECOND.multiply(AMPERE), "C", "Coulomb"), ElectricCharge.class);
    public static final Unit<ElectricPotential> VOLT = Units.addUnit(new AlternateUnit(WATT.divide(AMPERE), "V", "Volt"), ElectricPotential.class);
    public static final Unit<ElectricCapacitance> FARAD = Units.addUnit(new AlternateUnit(COULOMB.divide(VOLT), "F", "Farad"), ElectricCapacitance.class);
    public static final Unit<ElectricResistance> OHM = Units.addUnit(new AlternateUnit(VOLT.divide(AMPERE), "\u03a9", "Ohm"), ElectricResistance.class);
    public static final Unit<ElectricConductance> SIEMENS = Units.addUnit(new AlternateUnit(AMPERE.divide(VOLT), "S", "Siemens"), ElectricConductance.class);
    public static final Unit<MagneticFlux> WEBER = Units.addUnit(new AlternateUnit(VOLT.multiply(SECOND), "Wb", "Weber"), MagneticFlux.class);
    public static final Unit<MagneticFluxDensity> TESLA = Units.addUnit(new AlternateUnit(WEBER.divide(METRE.pow(2)), "T", "Tesla"), MagneticFluxDensity.class);
    public static final Unit<ElectricInductance> HENRY = Units.addUnit(new AlternateUnit(WEBER.divide(AMPERE), "H", "Henry"), ElectricInductance.class);
    public static final Unit<Temperature> CELSIUS = AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, new TransformedUnit<Temperature>(KELVIN, new AddConverter(273.15)), "Celsius", "\u2103");
    public static final Unit<LuminousFlux> LUMEN = Units.addUnit(new AlternateUnit(CANDELA.multiply(STERADIAN), "lm", "Lumen"), LuminousFlux.class);
    public static final Unit<Illuminance> LUX = Units.addUnit(new AlternateUnit(LUMEN.divide(METRE.pow(2)), "lx", "Lux"), Illuminance.class);
    public static final Unit<Radioactivity> BECQUEREL = Units.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(SECOND), "Bq", "Becquerel"), Radioactivity.class);
    public static final Unit<RadiationDoseAbsorbed> GRAY = Units.addUnit(new AlternateUnit(JOULE.divide(KILOGRAM), "Gy", "Gray"), RadiationDoseAbsorbed.class);
    public static final Unit<RadiationDoseEffective> SIEVERT = Units.addUnit(new AlternateUnit(JOULE.divide(KILOGRAM), "Sv", "Sievert"), RadiationDoseEffective.class);
    public static final Unit<CatalyticActivity> KATAL = Units.addUnit(new AlternateUnit(MOLE.divide(SECOND), "kat", "Katal"), CatalyticActivity.class);
    public static final Unit<Speed> METRE_PER_SECOND = Units.addUnit(new ProductUnit(METRE.divide(SECOND)), "Metre per Second", Speed.class);
    public static final Unit<Acceleration> METRE_PER_SQUARE_SECOND = Units.addUnit(new ProductUnit(METRE_PER_SECOND.divide(SECOND)), "Metre per square second", Acceleration.class);
    public static final Unit<Area> SQUARE_METRE = Units.addUnit(new ProductUnit(METRE.multiply(METRE)), "Square metre", Area.class);
    public static final Unit<Volume> CUBIC_METRE = Units.addUnit(new ProductUnit(SQUARE_METRE.multiply(METRE)), "Cubic metre", Volume.class);
    public static final Unit<Speed> KILOMETRE_PER_HOUR = Units.addUnit(METRE_PER_SECOND.multiply(RationalNumber.of(5L, 18L)), "Kilometre per hour").asType(Speed.class);
    public static final Unit<Dimensionless> PERCENT = Units.addUnit(new TransformedUnit<Dimensionless>("%", "Percent", AbstractUnit.ONE, (UnitConverter)MultiplyConverter.ofRational(1L, 100L)));
    public static final Unit<Time> MINUTE = Units.addUnit(new TransformedUnit<Time>("min", "Minute", SECOND, SECOND, MultiplyConverter.ofRational(60L, 1L)));
    public static final Unit<Time> HOUR = Units.addUnit(new TransformedUnit<Time>("h", "Hour", SECOND, SECOND, MultiplyConverter.ofRational(3600L, 1L)));
    public static final Unit<Time> DAY = Units.addUnit(new TransformedUnit<Time>("d", "Day", SECOND, SECOND, MultiplyConverter.ofRational(86400L, 1L)));
    public static final Unit<Time> WEEK = AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, DAY.multiply(7.0), "Week", "wk");
    public static final Unit<Time> YEAR = AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, DAY.multiply(365.2425), "Year", "y");
    public static final Unit<Time> MONTH = AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, YEAR.divide(12.0), "Month", "mo");
    public static final Unit<Volume> LITRE = AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, new TransformedUnit<Volume>(CUBIC_METRE, MultiplyConverter.ofRational(1L, 1000L)), "Litre", "l");

    protected Units() {
    }

    @Override
    public String getName() {
        return Units.class.getSimpleName();
    }

    public static Units getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name) {
        if (name != null && unit instanceof AbstractUnit) {
            return AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, unit, name);
        }
        Units.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        Units.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, String name, Class<? extends Quantity<?>> type) {
        AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, unit, name);
        Units.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        Units.INSTANCE.units.add(unit);
        Units.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    static {
        Units.addUnit(AbstractUnit.ONE);
        AbstractSystemOfUnits.Helper.addUnit(Units.INSTANCE.units, AbstractUnit.ONE, "One");
        Units.INSTANCE.quantityToUnit.put(Dimensionless.class, AbstractUnit.ONE);
    }
}

