/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;

public class FileUtils {
    private FileUtils() {
    }

    public static void mkdirs(File file) throws IOException {
        for (int i = 0; i < 5; ++i) {
            if (file.exists()) {
                if (file.isDirectory()) {
                    return;
                }
                throw new IOException("Could not create directory, because a file with the same name already exists: " + file.getAbsolutePath());
            }
            if (!file.mkdirs()) continue;
            return;
        }
        throw new IOException("Could not create directory: " + file.getAbsolutePath());
    }

    public static void setLength(RandomAccessFile randomAccessFile, long l) throws IOException {
        try {
            FileUtils.trace("setLength", null, randomAccessFile);
            randomAccessFile.setLength(l);
        }
        catch (IOException iOException) {
            int n;
            long l2;
            long l3 = randomAccessFile.length();
            if (l < l3) {
                throw iOException;
            }
            long l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l3);
            int n2 = 0x100000;
            int n3 = (int)Math.min(l2, (long)n2);
            byte[] byArray = new byte[n3];
            for (l2 = l - l3; l2 > 0L; l2 -= (long)n) {
                n = (int)Math.min(l2, (long)n2);
                randomAccessFile.write(byArray, 0, n);
            }
            randomAccessFile.seek(l4);
        }
    }

    public static String getFileInUserHome(String string) {
        String string2 = SysProperties.USER_HOME;
        if (string2 == null) {
            return string;
        }
        File file = new File(string2, string);
        return file.getAbsolutePath();
    }

    static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileUtils." + string + " " + string2 + " " + object);
        }
    }

    public static String getFileName(String string) throws SQLException {
        return FileSystem.getInstance(string).getFileName(string);
    }

    public static String normalize(String string) throws SQLException {
        return FileSystem.getInstance(string).normalize(string);
    }

    public static boolean tryDelete(String string) {
        return FileSystem.getInstance(string).tryDelete(string);
    }

    public static boolean isReadOnly(String string) {
        return FileSystem.getInstance(string).isReadOnly(string);
    }

    public static boolean exists(String string) {
        return FileSystem.getInstance(string).exists(string);
    }

    public static long length(String string) {
        return FileSystem.getInstance(string).length(string);
    }

    public static String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        return FileSystem.getInstance(string).createTempFile(string, string2, bl, bl2);
    }

    public static String getParent(String string) {
        return FileSystem.getInstance(string).getParent(string);
    }

    public static String[] listFiles(String string) throws SQLException {
        return FileSystem.getInstance(string).listFiles(string);
    }

    public static boolean isDirectory(String string) {
        return FileSystem.getInstance(string).isDirectory(string);
    }

    public static boolean isAbsolute(String string) {
        return FileSystem.getInstance(string).isAbsolute(string);
    }

    public static String getAbsolutePath(String string) {
        return FileSystem.getInstance(string).getAbsolutePath(string);
    }

    public static boolean fileStartsWith(String string, String string2) {
        return FileSystem.getInstance(string).fileStartsWith(string, string2);
    }

    public static InputStream openFileInputStream(String string) throws IOException {
        return FileSystem.getInstance(string).openFileInputStream(string);
    }

    public static OutputStream openFileOutputStream(String string, boolean bl) throws SQLException {
        return FileSystem.getInstance(string).openFileOutputStream(string, bl);
    }

    public static void rename(String string, String string2) throws SQLException {
        FileSystem.getInstance(string).rename(string, string2);
    }

    public static void createDirs(String string) throws SQLException {
        FileSystem.getInstance(string).createDirs(string);
    }

    public static void delete(String string) throws SQLException {
        FileSystem.getInstance(string).delete(string);
    }

    public static long getLastModified(String string) {
        return FileSystem.getInstance(string).getLastModified(string);
    }

    public static void setLength(String string, long l) throws SQLException {
        try {
            FileObject fileObject = FileSystem.getInstance(string).openFileObject(string, "rw");
            fileObject.setFileLength(l);
            fileObject.close();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string + " length: " + l);
        }
    }
}

