/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.geotools.util.logging.LoggerAdapter;
import org.geotools.util.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogbackLogger
extends LoggerAdapter {
    public static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    public static final Marker CONFIG = MarkerFactory.getMarker("CONFIG");
    public static final Marker FINEST = MarkerFactory.getMarker("FINEST");
    public Logger logger;

    public LogbackLogger(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    @Override
    public void setLevel(Level level) {
        String levelName = LogbackLogger.toLogbackLevelName(level);
        try {
            Class<?> LogbackLevelClass = Class.forName("ch.qos.logback.classic.Level");
            Class<?> LogbackLoggerCLass = Class.forName("ch.qos.logback.classic.Logger");
            Field logbackLevelField = LogbackLevelClass.getField(levelName);
            Object levelObject = logbackLevelField.get(null);
            Method setLevelMethod = LogbackLoggerCLass.getMethod("setLevel", LogbackLevelClass);
            setLevelMethod.invoke((Object)this.logger, levelObject);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static String toLogbackLevelName(Level level) {
        int n = level.intValue();
        switch (n / 100) {
            case 10: 
            case 11: {
                return "ERROR";
            }
            case 9: {
                return "WARN";
            }
            case 8: {
                return "INFO";
            }
            case 7: {
                return "INFO";
            }
            case 5: 
            case 6: {
                return "DEBUG";
            }
            case 4: {
                return "TRACE";
            }
            case 3: {
                return "TRACE";
            }
            case 0: 
            case 1: 
            case 2: {
                return "ALL";
            }
        }
        switch (n) {
            case -2147483648: {
                return "ALL";
            }
            case 0x7FFFFFFF: {
                return "OFF";
            }
        }
        if (n >= 0) {
            return "ERROR";
        }
        return "ALL";
    }

    @Override
    public Level getLevel() {
        if (this.logger.isTraceEnabled()) {
            if (this.logger.isTraceEnabled(FINEST)) {
                return Level.FINEST;
            }
            return Level.FINER;
        }
        if (this.logger.isDebugEnabled()) {
            return Level.FINE;
        }
        if (this.logger.isInfoEnabled()) {
            if (this.logger.isInfoEnabled(CONFIG)) {
                return Level.CONFIG;
            }
            return Level.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.logger.isErrorEnabled()) {
            if (this.logger.isErrorEnabled(FATAL)) {
                return Logging.FATAL;
            }
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.getLevel().intValue() > level.intValue();
    }

    @Override
    public void log(Level level, String message) {
        int n = level.intValue();
        switch (n / 100) {
            case 11: {
                this.logger.error(FATAL, message);
                break;
            }
            default: {
                super.log(level, message);
            }
        }
    }

    @Override
    public void severe(String message) {
        this.logger.error(message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void config(String message) {
        this.logger.info(CONFIG, message);
    }

    @Override
    public void fine(String message) {
        this.logger.debug(message);
    }

    @Override
    public void finer(String message) {
        this.logger.trace(message);
    }

    @Override
    public void finest(String message) {
        this.logger.trace(FINEST, message);
    }

    @Override
    public void log(Level level, String message, Throwable thrown) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                if (n < 0 || n == Integer.MAX_VALUE) break;
            }
            case 11: {
                this.logger.error(FATAL, message, thrown);
                break;
            }
            case 10: {
                this.logger.error(message, thrown);
                break;
            }
            case 9: {
                this.logger.warn(message, thrown);
                break;
            }
            case 8: {
                this.logger.info(message, thrown);
                break;
            }
            case 7: {
                this.logger.info(CONFIG, message, thrown);
                break;
            }
            case 5: 
            case 6: {
                this.logger.debug(message, thrown);
                break;
            }
            case 4: {
                this.logger.trace(message, thrown);
                break;
            }
            case 3: {
                this.logger.trace(FINEST, message, thrown);
            }
            case 0: 
            case 1: 
            case 2: 
        }
    }
}

