/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import javax.swing.Icon;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ColorReplacement;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ContrastMethod;
import org.geotools.api.style.Description;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExtensionSymbolizer;
import org.geotools.api.style.Extent;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.ExternalMark;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicFill;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.GraphicStroke;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LayerFeatureConstraints;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.NamedStyle;
import org.geotools.api.style.OverlapBehaviorEnum;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.RemoteOWS;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.SemanticType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.api.util.InternationalString;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AbstractStyleFactory;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMapEntryImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ColorReplacementImpl;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExtentImpl;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.ExternalMarkImpl;
import org.geotools.styling.FeatureTypeConstraintImpl;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.FillImpl;
import org.geotools.styling.FontImpl;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.ImageOutlineImpl;
import org.geotools.styling.LayerFeatureConstraintsImpl;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.NamedLayerImpl;
import org.geotools.styling.NamedStyleImpl;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.RemoteOWSImpl;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleFactoryImpl2;
import org.geotools.styling.StyleImpl;
import org.geotools.styling.StyledLayerDescriptorImpl;
import org.geotools.styling.TextSymbolizerImpl;
import org.geotools.styling.UserLayerImpl;
import org.geotools.util.factory.GeoTools;

public class StyleFactoryImpl
extends AbstractStyleFactory
implements StyleFactory {
    private FilterFactory filterFactory;
    private StyleFactoryImpl2 delegate;

    public StyleFactoryImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected StyleFactoryImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.delegate = new StyleFactoryImpl2(this.filterFactory);
    }

    @Override
    public Style createStyle() {
        return new StyleImpl();
    }

    @Override
    public NamedStyle createNamedStyle() {
        return new NamedStyleImpl();
    }

    @Override
    public PointSymbolizer createPointSymbolizer() {
        return new PointSymbolizerImpl();
    }

    @Override
    public PointSymbolizer createPointSymbolizer(Graphic graphic, String geometryPropertyName) {
        PointSymbolizerImpl pSymb = new PointSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setGraphic(graphic);
        return pSymb;
    }

    @Override
    public PolygonSymbolizer createPolygonSymbolizer() {
        return new PolygonSymbolizerImpl();
    }

    @Override
    public PolygonSymbolizer createPolygonSymbolizer(Stroke stroke, Fill fill, String geometryPropertyName) {
        PolygonSymbolizerImpl pSymb = new PolygonSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setStroke(stroke);
        pSymb.setFill(fill);
        return pSymb;
    }

    @Override
    public LineSymbolizer createLineSymbolizer() {
        return new LineSymbolizerImpl();
    }

    @Override
    public LineSymbolizer createLineSymbolizer(Stroke stroke, String geometryPropertyName) {
        LineSymbolizerImpl lSymb = new LineSymbolizerImpl();
        lSymb.setGeometryPropertyName(geometryPropertyName);
        lSymb.setStroke(stroke);
        return lSymb;
    }

    @Override
    public TextSymbolizer createTextSymbolizer() {
        return new TextSymbolizerImpl(this.filterFactory);
    }

    @Override
    public TextSymbolizer createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl(this.filterFactory);
        tSymb.setFill(fill);
        if (fonts != null) {
            tSymb.fonts().addAll(Arrays.asList(fonts));
        }
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo(halo);
        tSymb.setLabel(label);
        tSymb.setLabelPlacement(labelPlacement);
        return tSymb;
    }

    @Override
    public TextSymbolizer createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName, Graphic graphic) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl(this.filterFactory);
        tSymb.setFill(fill);
        if (fonts != null) {
            tSymb.fonts().addAll(Arrays.asList(fonts));
        }
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo(halo);
        tSymb.setLabel(label);
        tSymb.setLabelPlacement(labelPlacement);
        tSymb.setGraphic(graphic);
        return tSymb;
    }

    @Override
    public Extent createExtent(String name, String value) {
        ExtentImpl extent = new ExtentImpl();
        extent.setName(name);
        extent.setValue(value);
        return extent;
    }

    @Override
    public FeatureTypeConstraint createFeatureTypeConstraint(String featureTypeName, Filter filter, Extent[] extents) {
        FeatureTypeConstraintImpl constraint = new FeatureTypeConstraintImpl();
        constraint.setFeatureTypeName(featureTypeName);
        constraint.setFilter(filter);
        constraint.setExtents(extents);
        return constraint;
    }

    @Override
    public LayerFeatureConstraints createLayerFeatureConstraints(FeatureTypeConstraint[] featureTypeConstraints) {
        LayerFeatureConstraintsImpl constraints = new LayerFeatureConstraintsImpl();
        constraints.setFeatureTypeConstraints(featureTypeConstraints);
        return constraints;
    }

    @Override
    public FeatureTypeStyle createFeatureTypeStyle() {
        return new FeatureTypeStyleImpl();
    }

    @Override
    public FeatureTypeStyle createFeatureTypeStyle(Rule[] rules) {
        return new FeatureTypeStyleImpl(rules);
    }

    @Override
    public Rule createRule() {
        return new RuleImpl();
    }

    public Rule createRule(Symbolizer[] symbolizers, Description desc, Graphic legend, String name, Filter filter, boolean isElseFilter, double maxScale, double minScale) {
        RuleImpl r = new RuleImpl(symbolizers, desc, legend, name, filter, isElseFilter, maxScale, minScale);
        return r;
    }

    @Override
    public ImageOutline createImageOutline(Symbolizer symbolizer) {
        ImageOutlineImpl outline = new ImageOutlineImpl();
        outline.setSymbolizer(symbolizer);
        return outline;
    }

    @Override
    public Stroke createStroke(Expression color, Expression width) {
        return this.createStroke(color, width, this.filterFactory.literal(1.0));
    }

    @Override
    public Stroke createStroke(Expression color, Expression width, Expression opacity) {
        return this.createStroke(color, width, opacity, this.filterFactory.literal("miter"), this.filterFactory.literal("butt"), null, this.filterFactory.literal(0.0), null, null);
    }

    @Override
    public Stroke createStroke(Expression color, Expression width, Expression opacity, Expression lineJoin, Expression lineCap, float[] dashArray, Expression dashOffset, Graphic graphicFill, Graphic graphicStroke) {
        StrokeImpl stroke = new StrokeImpl(this.filterFactory);
        if (color == null) {
            color = StrokeImpl.DEFAULT.getColor();
        }
        stroke.setColor(color);
        if (width == null) {
            width = StrokeImpl.DEFAULT.getWidth();
        }
        stroke.setWidth(width);
        if (opacity == null) {
            opacity = StrokeImpl.DEFAULT.getOpacity();
        }
        stroke.setOpacity(opacity);
        if (lineJoin == null) {
            lineJoin = StrokeImpl.DEFAULT.getLineJoin();
        }
        stroke.setLineJoin(lineJoin);
        if (lineCap == null) {
            lineCap = StrokeImpl.DEFAULT.getLineCap();
        }
        stroke.setLineCap(lineCap);
        stroke.setDashArray(dashArray);
        stroke.setDashOffset(dashOffset);
        stroke.setGraphicFill(graphicFill);
        stroke.setGraphicStroke(graphicStroke);
        return stroke;
    }

    @Override
    public Fill createFill(Expression color, Expression backgroundColor, Expression opacity, Graphic graphicFill) {
        FillImpl fill = new FillImpl(this.filterFactory);
        if (color == null) {
            color = FillImpl.DEFAULT.getColor();
        }
        fill.setColor(color);
        if (opacity == null) {
            opacity = FillImpl.DEFAULT.getOpacity();
        }
        fill.setOpacity(opacity);
        fill.setGraphicFill(graphicFill);
        return fill;
    }

    @Override
    public Fill createFill(Expression color, Expression opacity) {
        return this.createFill(color, null, opacity, null);
    }

    @Override
    public Fill createFill(Expression color) {
        return this.createFill(color, null, this.filterFactory.literal(1.0), null);
    }

    @Override
    public Mark createMark(Expression wellKnownName, Stroke stroke, Fill fill, Expression size, Expression rotation) {
        MarkImpl mark = new MarkImpl(this.filterFactory, null);
        if (wellKnownName == null) {
            throw new IllegalArgumentException("WellKnownName can not be null in mark");
        }
        mark.setWellKnownName(wellKnownName);
        mark.setStroke(stroke);
        mark.setFill(fill);
        return mark;
    }

    @Override
    public Mark getSquareMark() {
        Mark mark = this.createMark(this.filterFactory.literal("Square"), this.getDefaultStroke(), this.getDefaultFill(), this.filterFactory.literal(6), this.filterFactory.literal(0));
        return mark;
    }

    @Override
    public Mark getCircleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName(this.filterFactory.literal("Circle"));
        return mark;
    }

    @Override
    public Mark getCrossMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName(this.filterFactory.literal("Cross"));
        return mark;
    }

    @Override
    public Mark getXMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName(this.filterFactory.literal("X"));
        return mark;
    }

    @Override
    public Mark getTriangleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName(this.filterFactory.literal("Triangle"));
        return mark;
    }

    @Override
    public Mark getStarMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName(this.filterFactory.literal("Star"));
        return mark;
    }

    @Override
    public Mark createMark() {
        MarkImpl mark = new MarkImpl(this.filterFactory, null);
        return mark;
    }

    @Override
    public Graphic createGraphic(ExternalGraphic[] externalGraphics, Mark[] marks, Symbol[] symbols, Expression opacity, Expression size, Expression rotation) {
        GraphicImpl graphic = new GraphicImpl(this.filterFactory);
        symbols = symbols != null ? symbols : new Symbol[]{};
        graphic.graphicalSymbols().addAll(Arrays.asList(symbols));
        if (externalGraphics != null) {
            graphic.graphicalSymbols().addAll(Arrays.asList(externalGraphics));
        }
        if (marks != null) {
            graphic.graphicalSymbols().addAll(Arrays.asList(marks));
        }
        if (opacity == null) {
            opacity = GraphicImpl.DEFAULT.getOpacity();
        }
        graphic.setOpacity(opacity);
        if (size == null) {
            size = GraphicImpl.DEFAULT.getSize();
        }
        graphic.setSize(size);
        if (rotation == null) {
            rotation = GraphicImpl.DEFAULT.getRotation();
        }
        graphic.setRotation(rotation);
        return graphic;
    }

    @Override
    public ExternalGraphic createExternalGraphic(String uri, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setURI(uri);
        extg.setFormat(format);
        return extg;
    }

    @Override
    public ExternalGraphic createExternalGraphic(Icon inlineContent, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setInlineContent(inlineContent);
        extg.setFormat(format);
        return extg;
    }

    @Override
    public ExternalGraphic createExternalGraphic(URL url, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setLocation(url);
        extg.setFormat(format);
        return extg;
    }

    @Override
    public Font createFont(Expression fontFamily, Expression fontStyle, Expression fontWeight, Expression fontSize) {
        FontImpl font = new FontImpl();
        if (fontFamily == null) {
            throw new IllegalArgumentException("Null font family specified");
        }
        font.getFamily().add(fontFamily);
        if (fontSize == null) {
            throw new IllegalArgumentException("Null font size specified");
        }
        font.setSize(fontSize);
        if (fontStyle == null) {
            throw new IllegalArgumentException("Null font Style specified");
        }
        font.setStyle(fontStyle);
        if (fontWeight == null) {
            throw new IllegalArgumentException("Null font weight specified");
        }
        font.setWeight(fontWeight);
        return font;
    }

    @Override
    public LinePlacement createLinePlacement(Expression offset) {
        LinePlacementImpl linep = new LinePlacementImpl(this.filterFactory);
        linep.setPerpendicularOffset(offset);
        return linep;
    }

    @Override
    public PointPlacement createPointPlacement(AnchorPoint anchorPoint, Displacement displacement, Expression rotation) {
        PointPlacementImpl pointp = new PointPlacementImpl(this.filterFactory);
        pointp.setAnchorPoint(anchorPoint);
        pointp.setDisplacement(displacement);
        pointp.setRotation(rotation);
        return pointp;
    }

    @Override
    public AnchorPoint createAnchorPoint(Expression x, Expression y) {
        AnchorPointImpl anchorPoint = new AnchorPointImpl(this.filterFactory);
        anchorPoint.setAnchorPointX(x);
        anchorPoint.setAnchorPointY(y);
        return anchorPoint;
    }

    @Override
    public Displacement createDisplacement(Expression x, Expression y) {
        DisplacementImpl displacement = new DisplacementImpl(this.filterFactory);
        displacement.setDisplacementX(x);
        displacement.setDisplacementY(y);
        return displacement;
    }

    @Override
    public Halo createHalo(Fill fill, Expression radius) {
        HaloImpl halo = new HaloImpl(this.filterFactory);
        halo.setFill(fill);
        halo.setRadius(radius);
        return halo;
    }

    @Override
    public Fill getDefaultFill() {
        FillImpl fill = new FillImpl(this.filterFactory);
        try {
            fill.setColor(this.filterFactory.literal("#808080"));
            fill.setOpacity(this.filterFactory.literal((Object)1.0));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating fill", ife);
        }
        return fill;
    }

    @Override
    public LineSymbolizer getDefaultLineSymbolizer() {
        return this.createLineSymbolizer(this.getDefaultStroke(), null);
    }

    @Override
    public Mark getDefaultMark() {
        return this.getSquareMark();
    }

    @Override
    public PointSymbolizer getDefaultPointSymbolizer() {
        return this.createPointSymbolizer(this.createDefaultGraphic(), null);
    }

    @Override
    public PolygonSymbolizer getDefaultPolygonSymbolizer() {
        return this.createPolygonSymbolizer(this.getDefaultStroke(), this.getDefaultFill(), null);
    }

    @Override
    public Stroke getDefaultStroke() {
        try {
            Stroke stroke = this.createStroke(this.filterFactory.literal("#000000"), this.filterFactory.literal((Object)1));
            stroke.setDashOffset(this.filterFactory.literal((Object)0));
            stroke.setDashArray(StrokeImpl.DEFAULT.getDashArray());
            stroke.setLineCap(this.filterFactory.literal("butt"));
            stroke.setLineJoin(this.filterFactory.literal("miter"));
            stroke.setOpacity(this.filterFactory.literal((Object)1));
            return stroke;
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating stroke", ife);
        }
    }

    @Override
    public Style getDefaultStyle() {
        Style style = this.createStyle();
        return style;
    }

    @Override
    public TextSymbolizer getDefaultTextSymbolizer() {
        return this.createTextSymbolizer(this.getDefaultFill(), new Font[]{this.getDefaultFont()}, null, null, this.getDefaultPointPlacement(), "geometry:text");
    }

    @Override
    public Font getDefaultFont() {
        return FontImpl.createDefault(this.filterFactory);
    }

    @Override
    public Graphic createDefaultGraphic() {
        GraphicImpl graphic = new GraphicImpl(this.filterFactory);
        graphic.graphicalSymbols().add(this.createMark());
        graphic.setSize(Expression.NIL);
        graphic.setOpacity(this.filterFactory.literal(1.0));
        graphic.setRotation(this.filterFactory.literal(0.0));
        return graphic;
    }

    @Override
    public Graphic getDefaultGraphic() {
        return this.createDefaultGraphic();
    }

    @Override
    public PointPlacement getDefaultPointPlacement() {
        return this.createPointPlacement(PointPlacementImpl.DEFAULT_ANCHOR_POINT, this.createDisplacement(this.filterFactory.literal(0), this.filterFactory.literal(0)), this.filterFactory.literal(0));
    }

    @Override
    public RasterSymbolizer createRasterSymbolizer() {
        return new RasterSymbolizerImpl(this.filterFactory);
    }

    @Override
    public RasterSymbolizer createRasterSymbolizer(String geometryPropertyName, Expression opacity, ChannelSelection channel, Expression overlap, ColorMap colorMap, ContrastEnhancement cenhancement, ShadedRelief relief, Symbolizer outline) {
        RasterSymbolizerImpl rastersym = new RasterSymbolizerImpl(this.filterFactory);
        if (geometryPropertyName != null) {
            rastersym.setGeometryPropertyName(geometryPropertyName);
        }
        if (opacity != null) {
            rastersym.setOpacity(opacity);
        }
        if (channel != null) {
            rastersym.setChannelSelection(channel);
        }
        if (overlap != null) {
            rastersym.setOverlap(overlap);
        }
        if (colorMap != null) {
            rastersym.setColorMap(colorMap);
        }
        if (cenhancement != null) {
            rastersym.setContrastEnhancement(cenhancement);
        }
        if (relief != null) {
            rastersym.setShadedRelief(relief);
        }
        if (outline != null) {
            rastersym.setImageOutline(outline);
        }
        return rastersym;
    }

    @Override
    public RasterSymbolizer getDefaultRasterSymbolizer() {
        return this.createRasterSymbolizer(null, this.filterFactory.literal(1.0), null, null, null, null, null, null);
    }

    @Override
    public ChannelSelection createChannelSelection(SelectedChannelType[] channels) {
        ChannelSelectionImpl channelSel = new ChannelSelectionImpl();
        if (channels != null && channels.length > 0) {
            if (channels.length == 1) {
                channelSel.setGrayChannel(channels[0]);
            } else {
                channelSel.setRGBChannels(channels);
            }
        }
        return channelSel;
    }

    @Override
    public ColorMap createColorMap() {
        return new ColorMapImpl();
    }

    @Override
    public ColorMapEntry createColorMapEntry() {
        return new ColorMapEntryImpl();
    }

    @Override
    public ContrastEnhancement createContrastEnhancement() {
        return new ContrastEnhancementImpl(this.filterFactory);
    }

    @Override
    public ContrastEnhancement createContrastEnhancement(Expression gammaValue) {
        ContrastEnhancementImpl ce = new ContrastEnhancementImpl();
        ce.setGammaValue(gammaValue);
        return ce;
    }

    @Override
    public SelectedChannelType createSelectedChannelType(Expression name, ContrastEnhancement enhancement) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl(this.filterFactory);
        sct.setChannelName(name);
        sct.setContrastEnhancement(enhancement);
        return sct;
    }

    @Override
    public SelectedChannelType createSelectedChannelType(String name, ContrastEnhancement enhancement) {
        Literal nameExp = this.filterFactory.literal(name);
        return this.createSelectedChannelType((Expression)nameExp, enhancement);
    }

    @Override
    public SelectedChannelType createSelectedChannelType(Expression name, Expression gammaValue) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl(this.filterFactory);
        sct.setChannelName(name);
        sct.setContrastEnhancement(this.createContrastEnhancement(gammaValue));
        return sct;
    }

    @Override
    public StyledLayerDescriptor createStyledLayerDescriptor() {
        return new StyledLayerDescriptorImpl();
    }

    @Override
    public UserLayer createUserLayer() {
        return new UserLayerImpl();
    }

    @Override
    public NamedLayer createNamedLayer() {
        return new NamedLayerImpl();
    }

    @Override
    public RemoteOWS createRemoteOWS(String service, String onlineResource) {
        RemoteOWSImpl remoteOWS = new RemoteOWSImpl();
        remoteOWS.setService(service);
        remoteOWS.setOnlineResource(onlineResource);
        return remoteOWS;
    }

    @Override
    public ShadedRelief createShadedRelief(Expression reliefFactor) {
        ShadedReliefImpl relief = new ShadedReliefImpl(this.filterFactory);
        relief.setReliefFactor(reliefFactor);
        return relief;
    }

    @Override
    public AnchorPoint anchorPoint(Expression x, Expression y) {
        return this.delegate.anchorPoint(x, y);
    }

    @Override
    public ChannelSelection channelSelection(SelectedChannelType gray) {
        return this.delegate.channelSelection(gray);
    }

    @Override
    public ChannelSelection channelSelection(SelectedChannelType red, SelectedChannelType green, SelectedChannelType blue) {
        return this.delegate.channelSelection(red, green, blue);
    }

    @Override
    public ColorMap colorMap(Expression propertyName, Expression ... mapping) {
        return this.delegate.colorMap(propertyName, mapping);
    }

    @Override
    public ColorReplacementImpl colorReplacement(Expression propertyName, Expression ... mapping) {
        return this.delegate.colorReplacement(propertyName, mapping);
    }

    @Override
    public ContrastEnhancement contrastEnhancement(Expression gamma, ContrastMethod method) {
        return this.delegate.contrastEnhancement(gamma, method);
    }

    @Override
    public Description description(InternationalString title, InternationalString description) {
        return this.delegate.description(title, description);
    }

    @Override
    public Displacement displacement(Expression dx, Expression dy) {
        return this.delegate.displacement(dx, dy);
    }

    @Override
    public ExternalGraphic externalGraphic(Icon inline, Collection<ColorReplacement> replacements) {
        return this.delegate.externalGraphic(inline, replacements);
    }

    @Override
    public ExternalGraphic externalGraphic(OnLineResource resource, String format, Collection<ColorReplacement> replacements) {
        return this.delegate.externalGraphic(resource, format, replacements);
    }

    @Override
    public ExternalMarkImpl externalMark(Icon inline) {
        return this.delegate.externalMark(inline);
    }

    @Override
    public ExternalMarkImpl externalMark(OnLineResource resource, String format, int markIndex) {
        return this.delegate.externalMark(resource, format, markIndex);
    }

    @Override
    public FeatureTypeStyle featureTypeStyle(String name, Description description, Id definedFor, Set<Name> featureTypeNames, Set<SemanticType> types, List<Rule> rules) {
        return this.delegate.featureTypeStyle(name, description, definedFor, featureTypeNames, types, rules);
    }

    @Override
    public Fill fill(GraphicFill fill, Expression color, Expression opacity) {
        return this.delegate.fill(fill, color, opacity);
    }

    @Override
    public Font font(List<Expression> family, Expression style, Expression weight, Expression size) {
        return this.delegate.font(family, style, weight, size);
    }

    @Override
    public Graphic graphic(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, AnchorPoint anchor, Displacement disp) {
        return this.delegate.graphic(symbols, opacity, size, rotation, anchor, disp);
    }

    @Override
    public GraphicFill graphicFill(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, AnchorPoint anchorPoint, Displacement displacement) {
        return this.delegate.graphicFill(symbols, opacity, size, rotation, anchorPoint, displacement);
    }

    @Override
    public GraphicLegend graphicLegend(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, AnchorPoint anchorPoint, Displacement displacement) {
        return this.delegate.graphicLegend(symbols, opacity, size, rotation, anchorPoint, displacement);
    }

    @Override
    public GraphicStroke graphicStroke(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, AnchorPoint anchorPoint, Displacement displacement, Expression initialGap, Expression gap) {
        return this.delegate.graphicStroke(symbols, opacity, size, rotation, anchorPoint, displacement, initialGap, gap);
    }

    @Override
    public Halo halo(Fill fill, Expression radius) {
        return this.delegate.halo(fill, radius);
    }

    @Override
    public LinePlacement linePlacement(Expression offset, Expression initialGap, Expression gap, boolean repeated, boolean aligned, boolean generalizedLine) {
        return this.delegate.linePlacement(offset, initialGap, gap, repeated, aligned, generalizedLine);
    }

    @Override
    public LineSymbolizer lineSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Stroke stroke, Expression offset) {
        return this.delegate.lineSymbolizer(name, geometry, description, unit, stroke, offset);
    }

    @Override
    public Mark mark(Expression wellKnownName, Fill fill, Stroke stroke) {
        return this.delegate.mark(wellKnownName, fill, stroke);
    }

    @Override
    public MarkImpl mark(ExternalMark externalMark, Fill fill, Stroke stroke) {
        return this.delegate.mark(externalMark, fill, stroke);
    }

    @Override
    public PointPlacement pointPlacement(AnchorPoint anchor, Displacement displacement, Expression rotation) {
        return this.delegate.pointPlacement(anchor, displacement, rotation);
    }

    @Override
    public PointSymbolizer pointSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Graphic graphic) {
        return this.delegate.pointSymbolizer(name, geometry, description, unit, graphic);
    }

    @Override
    public PolygonSymbolizer polygonSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Stroke stroke, Fill fill, Displacement displacement, Expression offset) {
        return this.delegate.polygonSymbolizer(name, geometry, description, unit, stroke, fill, displacement, offset);
    }

    @Override
    public RasterSymbolizer rasterSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Expression opacity, ChannelSelection channelSelection, OverlapBehaviorEnum overlapsBehaviour, ColorMap colorMap, ContrastEnhancement contrast, ShadedRelief shaded, Symbolizer outline) {
        return this.delegate.rasterSymbolizer(name, geometry, description, unit, opacity, channelSelection, overlapsBehaviour, colorMap, contrast, shaded, outline);
    }

    @Override
    public ExtensionSymbolizer extensionSymbolizer(String name, String propertyName, Description description, Unit<?> unit, String extensionName, Map<String, Expression> parameters) {
        return this.delegate.extensionSymbolizer(name, propertyName, description, unit, extensionName, parameters);
    }

    @Override
    public Rule rule(String name, Description description, GraphicLegend legend, double min, double max, List<Symbolizer> symbolizers, Filter filter) {
        return this.delegate.rule(name, description, legend, min, max, symbolizers, filter);
    }

    @Override
    public SelectedChannelType selectedChannelType(Expression channelName, ContrastEnhancement contrastEnhancement) {
        return this.delegate.selectedChannelType(channelName, contrastEnhancement);
    }

    @Override
    public SelectedChannelType selectedChannelType(String channelName, ContrastEnhancement contrastEnhancement) {
        return this.delegate.selectedChannelType(channelName, contrastEnhancement);
    }

    @Override
    public ShadedRelief shadedRelief(Expression reliefFactor, boolean brightnessOnly) {
        return this.delegate.shadedRelief(reliefFactor, brightnessOnly);
    }

    @Override
    public Stroke stroke(Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        return this.delegate.stroke(color, opacity, width, join, cap, dashes, offset);
    }

    @Override
    public Stroke stroke(GraphicFill fill, Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        return this.delegate.stroke(fill, color, opacity, width, join, cap, dashes, offset);
    }

    @Override
    public Stroke stroke(GraphicStroke stroke, Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        return this.delegate.stroke(stroke, color, opacity, width, join, cap, dashes, offset);
    }

    @Override
    public Style style(String name, Description description, boolean isDefault, List<FeatureTypeStyle> featureTypeStyles, Symbolizer defaultSymbolizer) {
        return this.delegate.style(name, description, isDefault, featureTypeStyles, defaultSymbolizer);
    }

    @Override
    public TextSymbolizer textSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Expression label, Font font, LabelPlacement placement, Halo halo, Fill fill) {
        return this.delegate.textSymbolizer(name, geometry, description, unit, label, font, placement, halo, fill);
    }

    @Override
    public ContrastEnhancement contrastEnhancement(Expression gamma, String method) {
        ContrastMethod meth = ContrastMethod.NONE;
        if (ContrastMethod.NORMALIZE.matches(method)) {
            meth = ContrastMethod.NORMALIZE;
        } else if (ContrastMethod.HISTOGRAM.matches(method)) {
            meth = ContrastMethod.HISTOGRAM;
        } else if (ContrastMethod.LOGARITHMIC.matches(method)) {
            meth = ContrastMethod.LOGARITHMIC;
        } else if (ContrastMethod.EXPONENTIAL.matches(method)) {
            meth = ContrastMethod.EXPONENTIAL;
        }
        return new ContrastEnhancementImpl(this.filterFactory, gamma, meth);
    }

    @Override
    public ContrastMethod createContrastMethod(ContrastMethod method) {
        return method;
    }
}

