/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.filter.Filter;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.style.Description;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.Rule;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.styling.DescriptionImpl;
import org.geotools.util.Utilities;

public class RuleImpl
implements Rule,
Cloneable {
    private List<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
    private GraphicLegend legend;
    private String name;
    private DescriptionImpl description = new DescriptionImpl();
    private Filter filter = null;
    private boolean hasElseFilter = false;
    private double maxScaleDenominator = Double.POSITIVE_INFINITY;
    private double minScaleDenominator = 0.0;
    private OnLineResource online = null;
    protected Map<String, String> options;

    protected RuleImpl() {
    }

    protected RuleImpl(Symbolizer ... symbolizers) {
        this.symbolizers.addAll(Arrays.asList(symbolizers));
    }

    protected RuleImpl(Symbolizer[] symbolizers, Description desc, Graphic legend, String name, Filter filter, boolean isElseFilter, double maxScale, double minScale) {
        this.symbolizers = new ArrayList<Symbolizer>(Arrays.asList(symbolizers));
        this.description.setAbstract(desc.getAbstract());
        this.description.setTitle(desc.getTitle());
        this.legend = (GraphicLegend)legend;
        this.name = name;
        this.filter = filter;
        this.hasElseFilter = isElseFilter;
        this.maxScaleDenominator = maxScale;
        this.minScaleDenominator = minScale;
    }

    public RuleImpl(Rule rule) {
        this.symbolizers = new ArrayList<Symbolizer>();
        for (Symbolizer sym : rule.symbolizers()) {
            if (!(sym instanceof Symbolizer)) continue;
            this.symbolizers.add(sym);
        }
        if (rule.getDescription() != null && rule.getDescription().getTitle() != null) {
            this.description.setTitle(rule.getDescription().getTitle());
        }
        if (rule.getDescription() != null && rule.getDescription().getAbstract() != null) {
            this.description.setTitle(rule.getDescription().getAbstract());
        }
        if (rule.getLegend() instanceof Graphic) {
            this.legend = rule.getLegend();
        }
        this.name = rule.getName();
        this.filter = rule.getFilter();
        this.hasElseFilter = rule.isElseFilter();
        this.maxScaleDenominator = rule.getMaxScaleDenominator();
        this.minScaleDenominator = rule.getMinScaleDenominator();
    }

    @Override
    public GraphicLegend getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(GraphicLegend legend) {
        this.legend = legend;
    }

    @Override
    public List<Symbolizer> symbolizers() {
        return this.symbolizers;
    }

    @Override
    public Symbolizer[] getSymbolizers() {
        Symbolizer[] ret = new Symbolizer[this.symbolizers.size()];
        int n = this.symbolizers.size();
        for (int i = 0; i < n; ++i) {
            ret[i] = this.symbolizers.get(i);
        }
        return ret;
    }

    @Override
    public DescriptionImpl getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isElseFilter() {
        return this.hasElseFilter;
    }

    @Override
    public void setElseFilter(boolean defaultb) {
        this.hasElseFilter = defaultb;
    }

    @Override
    public double getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    @Override
    public void setMaxScaleDenominator(double maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
    }

    @Override
    public double getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    @Override
    public void setMinScaleDenominator(double minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            RuleImpl clone = (RuleImpl)super.clone();
            clone.name = this.name;
            clone.description.setAbstract(this.description.getAbstract());
            clone.description.setTitle(this.description.getTitle());
            if (this.filter == null) {
                clone.filter = null;
            } else {
                DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
                clone.filter = (Filter)this.filter.accept(visitor, CommonFactoryFinder.getFilterFactory(null));
            }
            clone.hasElseFilter = this.hasElseFilter;
            clone.legend = this.legend;
            clone.symbolizers = new ArrayList<Symbolizer>(this.symbolizers);
            clone.maxScaleDenominator = this.maxScaleDenominator;
            clone.minScaleDenominator = this.minScaleDenominator;
            clone.options = this.options;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        result = 1000003 * result + this.symbolizers.hashCode();
        if (this.legend != null) {
            result = 1000003 * result + this.legend.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.filter != null) {
            result = 1000003 * result + this.filter.hashCode();
        }
        if (this.options != null) {
            result = 1000003 * result + this.options.hashCode();
        }
        result = 1000003 * result + (this.hasElseFilter ? 1 : 0);
        long temp = Double.doubleToLongBits(this.maxScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        temp = Double.doubleToLongBits(this.minScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof RuleImpl) {
            RuleImpl other = (RuleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.description, other.description) && Utilities.equals(this.filter, other.filter) && this.hasElseFilter == other.hasElseFilter && Utilities.equals(this.legend, other.legend) && Utilities.equals(this.symbolizers, other.symbolizers) && Double.doubleToLongBits(this.maxScaleDenominator) == Double.doubleToLongBits(other.maxScaleDenominator) && Double.doubleToLongBits(this.minScaleDenominator) == Double.doubleToLongBits(other.minScaleDenominator) && this.getOptions().equals(other.getOptions());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<RuleImpl");
        if (this.name != null) {
            buf.append(":");
            buf.append(this.name);
        }
        buf.append("> ");
        buf.append(this.filter);
        if (this.symbolizers != null) {
            buf.append("\n");
            for (Symbolizer symbolizer : this.symbolizers) {
                buf.append("\t");
                buf.append(symbolizer);
                buf.append("\n");
            }
        }
        buf.append(this.getOptions());
        return buf.toString();
    }

    @Override
    public OnLineResource getOnlineResource() {
        return this.online;
    }

    @Override
    public void setOnlineResource(OnLineResource online) {
        this.online = online;
    }

    static RuleImpl cast(Rule rule) {
        if (rule == null) {
            return null;
        }
        if (rule instanceof RuleImpl) {
            return (RuleImpl)rule;
        }
        RuleImpl copy = new RuleImpl(rule);
        return copy;
    }

    @Override
    public boolean hasOption(String key) {
        return this.options != null && this.options.containsKey(key);
    }

    @Override
    public Map<String, String> getOptions() {
        if (this.options == null) {
            this.options = new LinkedHashMap<String, String>();
        }
        return this.options;
    }
}

