/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class LinePlacementImpl
implements LinePlacement,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger(LinePlacementImpl.class);
    private FilterFactory filterFactory;
    private Expression perpendicularOffset;
    private boolean generalized;
    private boolean aligned;
    private boolean repeated;
    private Expression gap;
    private Expression initialGap;

    public LinePlacementImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public LinePlacementImpl(LinePlacement placement) {
        this.gap = placement.getGap();
        this.initialGap = placement.getInitialGap();
        this.generalized = placement.isGeneralizeLine();
        this.perpendicularOffset = placement.getPerpendicularOffset();
        this.repeated = placement.isRepeated();
        this.aligned = placement.isAligned();
    }

    public LinePlacementImpl(FilterFactory factory) {
        this(factory, false, false, false, null, null);
    }

    public LinePlacementImpl(FilterFactory factory, boolean aligned, boolean repeated, boolean generalized, Expression gap, Expression initialGap) {
        this.filterFactory = factory;
        this.gap = gap;
        this.initialGap = initialGap;
        this.generalized = generalized;
        this.aligned = aligned;
        this.repeated = repeated;
        this.init();
    }

    private void init() {
        try {
            this.perpendicularOffset = this.filterFactory.literal(0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultLinePlacement: " + ife);
        }
    }

    @Override
    public Expression getPerpendicularOffset() {
        return this.perpendicularOffset;
    }

    @Override
    public void setPerpendicularOffset(Expression perpendicularOffset) {
        this.perpendicularOffset = perpendicularOffset;
    }

    @Override
    public Expression getInitialGap() {
        return this.initialGap;
    }

    @Override
    public Expression getGap() {
        return this.gap;
    }

    @Override
    public boolean isRepeated() {
        return this.repeated;
    }

    @Override
    public boolean isAligned() {
        return this.aligned;
    }

    @Override
    public boolean isGeneralizeLine() {
        return this.generalized;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This can not happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinePlacementImpl) {
            LinePlacementImpl other = (LinePlacementImpl)obj;
            return Utilities.equals(this.perpendicularOffset, other.perpendicularOffset) && Utilities.equals(this.repeated, other.repeated) && Utilities.equals(this.generalized, other.generalized) && Utilities.equals(this.aligned, other.aligned) && Utilities.equals(this.initialGap, other.initialGap) && Utilities.equals(this.gap, other.gap);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.perpendicularOffset != null) {
            result = result * 37 + this.perpendicularOffset.hashCode();
        }
        if (this.gap != null) {
            result = result * 37 + this.gap.hashCode();
        }
        if (this.initialGap != null) {
            result = result * 37 + this.initialGap.hashCode();
        }
        result = result * 37 + Boolean.valueOf(this.generalized).hashCode();
        result = result * 37 + Boolean.valueOf(this.aligned).hashCode();
        result = result * 37 + Boolean.valueOf(this.repeated).hashCode();
        return result;
    }

    static LinePlacementImpl cast(LabelPlacement placement) {
        if (placement == null) {
            return null;
        }
        if (placement instanceof LinePlacementImpl) {
            return (LinePlacementImpl)placement;
        }
        if (placement instanceof LinePlacement) {
            LinePlacementImpl copy = new LinePlacementImpl((LinePlacement)placement);
            return copy;
        }
        return null;
    }

    @Override
    public void setRepeated(boolean repeated) {
        this.repeated = repeated;
    }

    @Override
    public void setGeneralized(boolean generalized) {
        this.generalized = generalized;
    }

    @Override
    public void setAligned(boolean aligned) {
        this.aligned = aligned;
    }

    @Override
    public void setGap(Expression gap) {
        this.gap = gap;
    }

    @Override
    public void setInitialGap(Expression initialGap) {
        this.initialGap = initialGap;
    }
}

