/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;

public class GeographicHandlerFactory
implements ProjectionHandlerFactory {
    static final double MAX_LATITUDE = 89.99;
    static final double MIN_LATITUDE = -89.99;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope != null && renderingEnvelope.getCoordinateReferenceSystem() instanceof GeographicCRS) {
            CoordinateReferenceSystem crs = renderingEnvelope.getCoordinateReferenceSystem();
            GeographicCRS geogCrs = (GeographicCRS)CRS.getHorizontalCRS(crs);
            SingleCRS horizontalSourceCrs = CRS.getHorizontalCRS(sourceCrs);
            ReferencedEnvelope validArea = null;
            if (horizontalSourceCrs instanceof GeographicCRS && !CRS.equalsIgnoreMetadata(horizontalSourceCrs, geogCrs) && !CRS.equalsIgnoreMetadata(horizontalSourceCrs, geogCrs)) {
                validArea = CRS.getAxisOrder(sourceCrs) == CRS.AxisOrder.NORTH_EAST ? new ReferencedEnvelope(-89.99, 89.99, 3.4028234663852886E38, -3.4028234663852886E38, horizontalSourceCrs) : new ReferencedEnvelope(2.147483647E9, -2.147483647E9, -89.99, 89.99, horizontalSourceCrs);
            }
            if (wrap && maxWraps > 0) {
                double centralMeridian = geogCrs.getDatum().getPrimeMeridian().getGreenwichLongitude();
                WrappingProjectionHandler handler = new WrappingProjectionHandler(renderingEnvelope, validArea, sourceCrs, centralMeridian, maxWraps);
                handler.setDatelineWrappingCheckEnabled(!this.isWrappingException(crs, horizontalSourceCrs));
                return handler;
            }
            return new ProjectionHandler(sourceCrs, validArea, renderingEnvelope);
        }
        return null;
    }

    private boolean isWrappingException(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCRS) throws FactoryException {
        MathTransform mt = CRS.findMathTransform(sourceCrs, targetCRS, true);
        return mt instanceof Mercator;
    }
}

