/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchIdentifierException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.BackingStoreException;
import org.geotools.util.Utilities;

public class IdentifiedObjectSet
extends AbstractSet
implements Serializable {
    private static final long serialVersionUID = -4221260663706882719L;
    private final Map<String, IdentifiedObject> objects = new LinkedHashMap<String, IdentifiedObject>();
    protected final AuthorityFactory factory;

    public IdentifiedObjectSet(AuthorityFactory factory) {
        this.factory = factory;
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    public boolean addAuthorityCode(String code) {
        boolean already = this.objects.containsKey(code);
        IdentifiedObject old = this.objects.put(code, null);
        if (old != null) {
            this.objects.put(code, old);
            return false;
        }
        return !already;
    }

    @Override
    public boolean add(Object object) {
        String code = this.getAuthorityCode((IdentifiedObject)object);
        return !Utilities.equals(this.objects.put(code, (IdentifiedObject)object), object);
    }

    private IdentifiedObject get(String code) throws BackingStoreException {
        IdentifiedObject object = this.objects.get(code);
        if (object == null && this.objects.containsKey(code)) {
            try {
                object = this.createObject(code);
                this.objects.put(code, object);
            }
            catch (FactoryException exception) {
                if (!this.isRecoverableFailure(exception)) {
                    throw new BackingStoreException(exception);
                }
                IdentifiedObjectSet.log(exception, code);
                this.objects.remove(code);
            }
        }
        return object;
    }

    @Override
    public boolean contains(Object object) {
        String code = this.getAuthorityCode((IdentifiedObject)object);
        IdentifiedObject current = this.get(code);
        return object.equals(current);
    }

    @Override
    public boolean remove(Object object) {
        String code = this.getAuthorityCode((IdentifiedObject)object);
        IdentifiedObject current = this.get(code);
        if (object.equals(current)) {
            this.objects.remove(code);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean modified = false;
        for (Object o : collection) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator iterator() {
        return new Iter(this.objects.entrySet().iterator());
    }

    public void resolve(int n) throws FactoryException {
        if (n > 0) {
            try {
                for (Object o : this) {
                    if (--n != 0) continue;
                    break;
                }
            }
            catch (BackingStoreException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof FactoryException) {
                    throw (FactoryException)cause;
                }
                throw exception;
            }
        }
    }

    public String[] getAuthorityCodes() {
        Set<String> codes = this.objects.keySet();
        return codes.toArray(new String[codes.size()]);
    }

    public void setAuthorityCodes(String ... codes) {
        HashMap<String, IdentifiedObject> copy = new HashMap<String, IdentifiedObject>(this.objects);
        this.objects.clear();
        for (String code : codes) {
            this.objects.put(code, (IdentifiedObject)copy.get(code));
        }
    }

    protected String getAuthorityCode(IdentifiedObject object) {
        Set<ReferenceIdentifier> identifiers = object.getIdentifiers();
        Identifier id = identifiers != null && !identifiers.isEmpty() ? (Identifier)identifiers.iterator().next() : object.getName();
        return id.getCode();
    }

    protected IdentifiedObject createObject(String code) throws FactoryException {
        return this.factory.createObject(code);
    }

    protected boolean isRecoverableFailure(FactoryException exception) {
        return exception instanceof NoSuchIdentifierException;
    }

    static void log(FactoryException exception, String code) {
        LogRecord record = new LogRecord(Level.FINE, "Failed to create an object for code \"" + code + "\".");
        record.setSourceClassName(IdentifiedObjectSet.class.getName());
        record.setSourceMethodName("createObject");
        record.setThrown(exception);
        Logger logger = AbstractAuthorityFactory.LOGGER;
        record.setLoggerName(logger.getName());
        logger.log(record);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashSet(this);
    }

    private final class Iter
    implements Iterator {
        private final Iterator iterator;
        private IdentifiedObject element;

        public Iter(Iterator iterator) {
            this.iterator = iterator;
            this.toNext();
        }

        private void toNext() throws BackingStoreException {
            while (this.iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)this.iterator.next();
                this.element = (IdentifiedObject)entry.getValue();
                if (this.element == null) {
                    String code = (String)entry.getKey();
                    try {
                        this.element = IdentifiedObjectSet.this.createObject(code);
                    }
                    catch (FactoryException exception) {
                        if (!IdentifiedObjectSet.this.isRecoverableFailure(exception)) {
                            throw new BackingStoreException(exception);
                        }
                        IdentifiedObjectSet.log(exception, code);
                        this.iterator.remove();
                        continue;
                    }
                    entry.setValue(this.element);
                }
                return;
            }
            this.element = null;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        public Object next() throws NoSuchElementException {
            IdentifiedObject next = this.element;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.toNext();
            return next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

