/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.Spheroid;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Utilities;
import si.uom.SI;

public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    public static final DefaultEllipsoid WGS84 = DefaultEllipsoid.createFlattenedSphere("WGS84", 6378137.0, 298.257223563, (Unit<Length>)SI.METRE);
    public static final DefaultEllipsoid GRS80 = DefaultEllipsoid.createFlattenedSphere("GRS80", 6378137.0, 298.257222101, (Unit<Length>)SI.METRE);
    public static final DefaultEllipsoid INTERNATIONAL_1924 = DefaultEllipsoid.createFlattenedSphere("International 1924", 6378388.0, 297.0, (Unit<Length>)SI.METRE);
    public static final DefaultEllipsoid CLARKE_1866 = DefaultEllipsoid.createFlattenedSphere("Clarke 1866", 6378206.4, 294.9786982, (Unit<Length>)SI.METRE);
    public static final DefaultEllipsoid SPHERE = DefaultEllipsoid.createEllipsoid("SPHERE", 6371000.0, 6371000.0, (Unit<Length>)SI.METRE);
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double inverseFlattening;
    private final boolean ivfDefinitive;
    private final Unit<Length> unit;

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super(ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    protected DefaultEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, double inverseFlattening, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties);
        this.unit = unit;
        this.semiMajorAxis = DefaultEllipsoid.check("semiMajorAxis", semiMajorAxis);
        this.semiMinorAxis = DefaultEllipsoid.check("semiMinorAxis", semiMinorAxis);
        this.inverseFlattening = DefaultEllipsoid.check("inverseFlattening", inverseFlattening);
        this.ivfDefinitive = ivfDefinitive;
        DefaultEllipsoid.ensureNonNull("unit", unit);
        DefaultEllipsoid.ensureLinearUnit(unit);
    }

    public static DefaultEllipsoid createEllipsoid(String name, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", name), semiMajorAxis, semiMinorAxis, unit);
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        if (semiMajorAxis == semiMinorAxis) {
            return new Spheroid(properties, semiMajorAxis, false, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMinorAxis, semiMajorAxis / (semiMajorAxis - semiMinorAxis), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(String name, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        return DefaultEllipsoid.createFlattenedSphere(Collections.singletonMap("name", name), semiMajorAxis, inverseFlattening, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        if (Double.isInfinite(inverseFlattening)) {
            return new Spheroid(properties, semiMajorAxis, true, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMajorAxis * (1.0 - 1.0 / inverseFlattening), inverseFlattening, true, unit);
    }

    public static DefaultEllipsoid wrap(Ellipsoid ellipsoid) {
        if (ellipsoid == null || ellipsoid instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)ellipsoid;
        }
        if (ellipsoid.isIvfDefinitive()) {
            return DefaultEllipsoid.createFlattenedSphere(DefaultEllipsoid.getProperties(ellipsoid), ellipsoid.getSemiMajorAxis(), ellipsoid.getInverseFlattening(), ellipsoid.getAxisUnit());
        }
        return DefaultEllipsoid.createEllipsoid(DefaultEllipsoid.getProperties(ellipsoid), ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), ellipsoid.getAxisUnit());
    }

    static double check(String name, double value) throws IllegalArgumentException {
        if (value > 0.0) {
            return value;
        }
        throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", name, value));
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getEccentricity() {
        double f = 1.0 - this.getSemiMinorAxis() / this.getSemiMajorAxis();
        return Math.sqrt(2.0 * f - f * f);
    }

    @Override
    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    @Override
    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    @Override
    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double orthodromicDistance(Point2D P1, Point2D P2) {
        return this.orthodromicDistance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public double orthodromicDistance(double x1, double y1, double x2, double y2) {
        Geodesic geod = new Geodesic(this.getSemiMajorAxis(), 1.0 / this.getInverseFlattening());
        GeodesicData g = geod.Inverse(y1, x1, y2, x2, 1025);
        return g.s12;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultEllipsoid that = (DefaultEllipsoid)object;
            if (!compareMetadata) {
                UnitConverter converter = that.unit.getConverterTo(this.unit);
                return Utilities.equals(this.semiMajorAxis, converter.convert(that.semiMajorAxis)) && Utilities.equals(this.semiMinorAxis, converter.convert(that.semiMinorAxis));
            }
            return this.ivfDefinitive == that.ivfDefinitive && Utilities.equals(this.semiMajorAxis, that.semiMajorAxis) && Utilities.equals(this.semiMinorAxis, that.semiMinorAxis) && Utilities.equals(this.inverseFlattening, that.inverseFlattening) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long longCode = 37L * Double.doubleToLongBits(this.semiMajorAxis);
        longCode = this.ivfDefinitive ? (long)((double)longCode + this.inverseFlattening) : (long)((double)longCode + this.semiMinorAxis);
        return (int)(longCode >>> 32) ^ (int)longCode;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        double ivf = this.getInverseFlattening();
        formatter.append(this.getAxisUnit().getConverterTo(SI.METRE).convert(this.getSemiMajorAxis()));
        formatter.append(Double.isInfinite(ivf) ? 0.0 : ivf);
        return "SPHEROID";
    }
}

