/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.io.Serializable;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.util.Cloneable;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Utilities;

public class BursaWolfParameters
extends Formattable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 754825592343010900L;
    public double dx;
    public double dy;
    public double dz;
    public double ex;
    public double ey;
    public double ez;
    public double ppm;
    public final GeodeticDatum targetDatum;

    public BursaWolfParameters(GeodeticDatum target) {
        this.targetDatum = target;
    }

    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.ex == 0.0 && this.ey == 0.0 && this.ez == 0.0 && this.ppm == 0.0;
    }

    public boolean isTranslation() {
        return this.ex == 0.0 && this.ey == 0.0 && this.ez == 0.0 && this.ppm == 0.0;
    }

    public XMatrix getAffineTransform() {
        double S = 1.0 + this.ppm / 1000000.0;
        double RS = 4.84813681109536E-6 * S;
        return new Matrix4(S, -this.ez * RS, this.ey * RS, this.dx, this.ez * RS, S, -this.ex * RS, this.dy, -this.ey * RS, this.ex * RS, S, this.dz, 0.0, 0.0, 0.0, 1.0);
    }

    /*
     * Unable to fully structure code
     */
    public void setAffineTransform(Matrix matrix, double eps) throws IllegalArgumentException {
        if (matrix.getNumCol() != 4 || matrix.getNumRow() != 4) {
            throw new IllegalArgumentException("Illegal matrix size.");
        }
        for (i = 0; i < 4; ++i) {
            difference = matrix.getElement(3, i) - (double)(i == 3);
            if (!(Math.abs(difference) > eps)) continue;
            throw new IllegalArgumentException("The grid to coordinate system transform must be affine.");
        }
        this.dx = matrix.getElement(0, 3);
        this.dy = matrix.getElement(1, 3);
        this.dz = matrix.getElement(2, 3);
        S = (matrix.getElement(0, 0) + matrix.getElement(1, 1) + matrix.getElement(2, 2)) / 3.0;
        RS = 4.84813681109536E-6 * S;
        this.ppm = (S - 1.0) * 1000000.0;
        for (j = 0; j < 2; ++j) {
            eltS = (matrix.getElement(j, j) - 1.0) * 1000000.0;
            if (!(Math.abs(eltS - this.ppm) <= eps)) {
                throw new IllegalArgumentException("Scale is not uniform.");
            }
            block6: for (i = j + 1; i < 3; ++i) {
                elt1 = matrix.getElement(j, i) / RS;
                if (!(Math.abs(elt1 + (elt2 = matrix.getElement(i, j) / RS)) <= eps)) {
                    throw new IllegalArgumentException("Matrix is not antisymmetric.");
                }
                value = 0.5 * (elt1 - elt2);
                if (j != 0) ** GOTO lbl-1000
                switch (i) {
                    case 1: {
                        this.ez = -value;
                        continue block6;
                    }
                    case 2: {
                        this.ey = value;
                        continue block6;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (!(BursaWolfParameters.$assertionsDisabled || j == 1 && i == 2)) {
                            throw new AssertionError();
                        }
                        this.ex = -value;
                    }
                }
            }
        }
        if (!BursaWolfParameters.$assertionsDisabled && !this.getAffineTransform().equals(matrix, eps * RS)) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        long code = 754825592343010900L;
        code = code * 37L + Double.doubleToLongBits(this.dx);
        code = code * 37L + Double.doubleToLongBits(this.dy);
        code = code * 37L + Double.doubleToLongBits(this.dz);
        code = code * 37L + Double.doubleToLongBits(this.ex);
        code = code * 37L + Double.doubleToLongBits(this.ey);
        code = code * 37L + Double.doubleToLongBits(this.ez);
        code = code * 37L + Double.doubleToLongBits(this.ppm);
        return (int)(code >>> 32) ^ (int)code;
    }

    @Override
    public BursaWolfParameters clone() {
        try {
            return (BursaWolfParameters)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BursaWolfParameters) {
            BursaWolfParameters that = (BursaWolfParameters)object;
            return Utilities.equals(this.dx, that.dx) && Utilities.equals(this.dy, that.dy) && Utilities.equals(this.dz, that.dz) && Utilities.equals(this.ex, that.ex) && Utilities.equals(this.ey, that.ey) && Utilities.equals(this.ez, that.ez) && Utilities.equals(this.ppm, that.ppm) && Utilities.equals(this.targetDatum, that.targetDatum);
        }
        return false;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        formatter.append(this.dx);
        formatter.append(this.dy);
        formatter.append(this.dz);
        formatter.append(this.ex);
        formatter.append(this.ey);
        formatter.append(this.ez);
        formatter.append(this.ppm);
        if (!DefaultGeodeticDatum.isWGS84(this.targetDatum)) {
            if (this.targetDatum != null) {
                formatter.append(this.targetDatum.getName().getCode());
            }
            return super.formatWKT(formatter);
        }
        return "TOWGS84";
    }
}

