/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public PolygonTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    @Override
    public QName getTarget() {
        return GML.PolygonType;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return Polygon.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LinearRing exterior = (LinearRing)node.getChildValue("exterior");
        LinearRing[] interior = null;
        if (node.hasChild("interior")) {
            List list = node.getChildValues("interior");
            interior = list.toArray(new LinearRing[list.size()]);
        }
        return this.gFactory.createPolygon(exterior, interior);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        int n;
        Polygon polygon = (Polygon)object;
        if ("exterior".equals(name.getLocalPart())) {
            return polygon.getExteriorRing();
        }
        if ("interior".equals(name.getLocalPart()) && (n = polygon.getNumInteriorRing()) > 0) {
            LineString[] interior = new LineString[n];
            for (int i = 0; i < n; ++i) {
                interior[i] = polygon.getInteriorRingN(i);
            }
            return interior;
        }
        return null;
    }
}

