/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.net.URI;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.measure.Measure;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tech.units.indriya.unit.BaseUnit;

public class MeasureTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return GML.MeasureType;
    }

    @Override
    public Class<?> getType() {
        return Measure.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        double d = Double.parseDouble(node.getComponent().getText());
        URI uom = (URI)node.getAttributeValue(URI.class);
        if (uom != null) {
            return new Measure(d, new BaseUnit(uom.toString()));
        }
        return new Measure(d, null);
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        Measure measure = (Measure)object;
        value.appendChild(document.createTextNode("" + measure.doubleValue()));
        return value;
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        Measure measure;
        if ("uom".equals(name.getLocalPart()) && (measure = (Measure)object).getUnit() != null) {
            return new URI(measure.getUnit().getSymbol());
        }
        return null;
    }
}

