/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingConnection;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.Features;
import org.geotools.geopkg.GeoPkgDataStoreFactory;
import org.geotools.geopkg.GeoPkgDialect;
import org.geotools.geopkg.GeoPkgExtension;
import org.geotools.geopkg.GeoPkgExtensionFactory;
import org.geotools.geopkg.GeoPkgExtensionFactoryFinder;
import org.geotools.geopkg.Tile;
import org.geotools.geopkg.TileEntry;
import org.geotools.geopkg.TileMatrix;
import org.geotools.geopkg.TileReader;
import org.geotools.geopkg.geom.GeoPkgGeomReader;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.geopkg.geom.GeometryBooleanFunction;
import org.geotools.geopkg.geom.GeometryDoubleFunction;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.util.SqlUtil;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.sqlite.Function;
import org.sqlite.SQLiteConfig;

public class GeoPackage
implements Closeable {
    static final Logger LOGGER = Logging.getLogger(GeoPackage.class);
    public static final String GEOPACKAGE_CONTENTS = "gpkg_contents";
    public static final String GEOMETRY_COLUMNS = "gpkg_geometry_columns";
    public static final String SPATIAL_REF_SYS = "gpkg_spatial_ref_sys";
    public static final String DATA_COLUMNS = "gpkg_data_columns";
    public static final String TILE_MATRIX_METADATA = "gpkg_tile_matrix";
    public static final String METADATA = "gpkg_metadata";
    public static final String METADATA_REFERENCE = "gpkg_metadata_reference";
    public static final String TILE_MATRIX_SET = "gpkg_tile_matrix_set";
    public static final String DATA_COLUMN_CONSTRAINTS = "gpkg_data_column_constraints";
    public static final String EXTENSIONS = "gpkg_extensions";
    public static final String SPATIAL_INDEX = "gpkg_spatial_index";
    public static final String SCHEMA = "gpkg_schema";
    public static final String SKIP_REGISTRATION = "skip_registration";
    public static final String DATA_COLUMN = "gpgk_constraint";
    protected static final int GENERIC_GEOGRAPHIC_SRID = 0;
    protected static final int GENERIC_PROJECTED_SRID = -1;
    static final int GPKG_120_APPID = 1196444487;
    static final int GPKG_100_APPID = 1196437808;
    private static final int MIN_CUSTOM_SRID = 900000;
    static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    File file;
    final DataSource connPool;
    volatile JDBCDataStore dataStore;
    private boolean initialised = false;
    protected GeoPkgGeomWriter.Configuration writerConfig = new GeoPkgGeomWriter.Configuration();

    public GeoPkgGeomWriter.Configuration getWriterConfiguration() {
        return this.writerConfig;
    }

    public GeoPackage() throws IOException {
        this(File.createTempFile("geopkg", ".db"));
    }

    public GeoPackage(File file) throws IOException {
        this(file, null, (String)null);
    }

    public GeoPackage(File file, String user, String passwd) throws IOException {
        this(file, user, passwd, false);
    }

    public GeoPackage(File file, String user, String passwd, boolean readOnly) throws IOException {
        this.file = file;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (user != null) {
            params.put(GeoPkgDataStoreFactory.USER.key, user);
        }
        if (passwd != null) {
            params.put(GeoPkgDataStoreFactory.PASSWD.key, passwd);
        }
        if (readOnly) {
            params.put(GeoPkgDataStoreFactory.READ_ONLY.key, readOnly);
        }
        params.put(GeoPkgDataStoreFactory.DATABASE.key, file.getPath());
        params.put(GeoPkgDataStoreFactory.DBTYPE.key, GeoPkgDataStoreFactory.DBTYPE.sample);
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 1000);
        this.connPool = new GeoPkgDataStoreFactory(this.writerConfig).createDataSource(params);
    }

    GeoPackage(DataSource dataSource) {
        this.connPool = dataSource;
    }

    public GeoPackage(JDBCDataStore dataStore) {
        if (!(dataStore.getSQLDialect() instanceof GeoPkgDialect)) {
            throw new IllegalArgumentException("Invalid data store, should be associated to a GeoPkgDialect");
        }
        this.dataStore = dataStore;
        this.connPool = dataStore.getDataSource();
    }

    public GeoPackage(File file, SQLiteConfig config, Map<String, Object> storeParams) throws IOException {
        this.file = file;
        HashMap<String, Object> params = new HashMap<String, Object>(storeParams != null ? storeParams : Collections.emptyMap());
        params.put(GeoPkgDataStoreFactory.DATABASE.key, file.getPath());
        params.put(GeoPkgDataStoreFactory.DBTYPE.key, GeoPkgDataStoreFactory.DBTYPE.sample);
        GeoPkgDataStoreFactory factory = new GeoPkgDataStoreFactory(this.writerConfig);
        this.connPool = factory.createDataSource(params);
        params.put(GeoPkgDataStoreFactory.DATASOURCE.key, this.connPool);
        this.dataStore = factory.createDataStore(params);
        for (Map.Entry<Object, Object> e : config.toProperties().entrySet()) {
            ((BasicDataSource)this.connPool).addConnectionProperty((String)e.getKey(), (String)e.getValue());
        }
    }

    public File getFile() {
        return this.file;
    }

    public DataSource getDataSource() {
        return this.connPool;
    }

    public void init() throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            GeoPackage.init(cx);
            this.initialised = true;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    static void init(Connection cx) throws SQLException {
        GeoPackage.createFunctions(cx);
        boolean initialized = false;
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery("PRAGMA application_id");){
            if (rs.next()) {
                int applicationId = rs.getInt(1);
                initialized = 1196437808 == applicationId || 1196444487 == applicationId;
            }
        }
        if (!initialized) {
            GeoPackage.runScript("gpkg_extensions.sql", cx);
            GeoPackage.runScript("gpkg_spatial_ref_sys.sql", cx);
            GeoPackage.runScript("gpkg_geometry_columns.sql", cx);
            GeoPackage.runScript("gpkg_contents.sql", cx);
            GeoPackage.runScript("gpkg_tile_matrix_set.sql", cx);
            GeoPackage.runScript("gpkg_tile_matrix.sql", cx);
            GeoPackage.runScript("gpkg_data_columns.sql", cx);
            GeoPackage.runScript("gpkg_metadata.sql", cx);
            GeoPackage.runScript("gpkg_metadata_reference.sql", cx);
            GeoPackage.runScript("gpkg_data_column_constraints.sql", cx);
            GeoPackage.addDefaultSpatialReferences(cx);
            GeoPackage.runSQL("PRAGMA application_id = 1196444487;", cx);
        }
    }

    static void createFunctions(Connection cx) throws SQLException {
        while (cx instanceof DelegatingConnection) {
            cx = ((DelegatingConnection)cx).getDelegate();
        }
        Function.create(cx, "ST_MinX", new GeometryDoubleFunction(){

            @Override
            public double execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getEnvelope().getMinX();
            }
        }, 1, 2048);
        Function.create(cx, "ST_MaxX", new GeometryDoubleFunction(){

            @Override
            public double execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getEnvelope().getMaxX();
            }
        }, 1, 2048);
        Function.create(cx, "ST_MinY", new GeometryDoubleFunction(){

            @Override
            public double execute(GeoPkgGeomReader reader) throws IOException, SQLException {
                return reader.getEnvelope().getMinY();
            }
        }, 1, 2048);
        Function.create(cx, "ST_MaxY", new GeometryDoubleFunction(){

            @Override
            public double execute(GeoPkgGeomReader reader) throws IOException, SQLException {
                return reader.getEnvelope().getMaxY();
            }
        }, 1, 2048);
        Function.create(cx, "ST_IsEmpty", new GeometryBooleanFunction(){

            @Override
            public boolean execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getHeader().getFlags().isEmpty();
            }
        }, 1, 2048);
    }

    @Override
    public void close() {
        if (this.dataStore != null) {
            this.dataStore.dispose();
        }
        try {
            if (this.connPool instanceof BasicDataSource) {
                ((BasicDataSource)this.connPool).close();
            } else if (this.connPool instanceof ManageableDataSource) {
                ((ManageableDataSource)this.connPool).close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing database connection", e);
        }
    }

    public void addCRS(int srid) throws IOException {
        try {
            this.addCRS(CRS.decode("EPSG:" + srid, true), "epsg", srid);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static void addDefaultSpatialReferences(Connection cx) throws SQLException {
        try {
            GeoPackage.addCRS(cx, -1, "Undefined cartesian SRS", "NONE", -1, "undefined", "undefined cartesian coordinate reference system");
            GeoPackage.addCRS(cx, 0, "Undefined geographic SRS", "NONE", 0, "undefined", "undefined geographic coordinate reference system");
            GeoPackage.addCRS(cx, 4326, "WGS 84 geodetic", "EPSG", 4326, "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]", "longitude/latitude coordinates in decimal degrees on the WGS 84 spheroid");
        }
        catch (IOException ex) {
            throw new SQLException("Unable to add default spatial references.", ex);
        }
    }

    public static void addCRS(Connection cx, int srid, String srsName, String organization, int organizationCoordSysId, String definition, String description) throws IOException {
        try {
            try (PreparedStatement ps = cx.prepareStatement(String.format("SELECT srs_id FROM %s WHERE srs_id = ?", SPATIAL_REF_SYS));
                 ResultSet rs = SqlUtil.prepare(ps).set(srid).log(Level.FINE).statement().executeQuery();){
                if (rs.next()) {
                    return;
                }
            }
            ps = cx.prepareStatement(String.format("INSERT INTO %s (srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (?,?,?,?,?,?)", SPATIAL_REF_SYS));
            try {
                SqlUtil.prepare(ps).set(srid).set(srsName).set(organization).set(organizationCoordSysId).set(definition).set(description).log(Level.FINE).statement().execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void addCRS(CoordinateReferenceSystem crs, String auth, int srid) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.addCRS(crs, auth, srid, cx);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void addCRS(CoordinateReferenceSystem crs, String auth, int srid, Connection cx) throws IOException {
        GeoPackage.addCRS(cx, srid, auth + ":" + srid, auth, srid, crs.toWKT(), auth + ":" + srid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasCRS(Connection cx, int srid) {
        try (PreparedStatement ps = cx.prepareStatement(String.format("SELECT count(*) FROM %s WHERE srs_id = ?", SPATIAL_REF_SYS));
             ResultSet rs = SqlUtil.prepare(ps).set(srid).log(Level.FINE).statement().executeQuery();){
            if (!rs.next()) return false;
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private CoordinateReferenceSystem getCRS(int srid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 23[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Entry> contents() {
        ArrayList<Entry> contents = new ArrayList<Entry>();
        try (Connection cx = this.connPool.getConnection();
             Statement st = cx.createStatement();){
            try (ResultSet rs = st.executeQuery("SELECT * FROM gpkg_contents");){
                while (rs.next()) {
                    String dt = rs.getString("data_type");
                    Entry.DataType type = Entry.DataType.valueOf(dt);
                    Entry e = null;
                    switch (type) {
                        case Feature: {
                            e = this.createFeatureEntry(rs);
                            break;
                        }
                        case Tile: {
                            e = GeoPackage.createTileEntry(rs, cx);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unexpected type in GeoPackage");
                        }
                    }
                    if (e == null) continue;
                    contents.add(e);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return contents;
    }

    public List<FeatureEntry> features() throws IOException {
        ArrayList<FeatureEntry> arrayList;
        block22: {
            Connection cx = this.connPool.getConnection();
            try {
                ArrayList<FeatureEntry> entries = new ArrayList<FeatureEntry>();
                String sql = String.format("SELECT a.*, b.column_name, b.geometry_type_name, b.z, b.m, c.organization_coordsys_id, c.definition FROM %s a, %s b, %s c WHERE a.table_name = b.table_name AND a.srs_id = c.srs_id AND a.data_type = ?", GEOPACKAGE_CONTENTS, GEOMETRY_COLUMNS, SPATIAL_REF_SYS);
                try (PreparedStatement ps = cx.prepareStatement(sql);){
                    ps.setString(1, DataType.Feature.value());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            entries.add(this.createFeatureEntry(rs));
                        }
                    }
                }
                arrayList = entries;
                if (cx == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            cx.close();
        }
        return arrayList;
    }

    public FeatureEntry feature(String name) throws IOException {
        FeatureEntry featureEntry;
        block8: {
            Connection cx = this.connPool.getConnection();
            try {
                featureEntry = this.feature(name, cx);
                if (cx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            cx.close();
        }
        return featureEntry;
    }

    protected FeatureEntry feature(String name, Connection cx) throws SQLException, IOException {
        String sql = String.format("SELECT a.*, b.column_name, b.geometry_type_name, b.m, b.z, c.organization_coordsys_id, c.definition FROM %s a, %s b, %s c WHERE a.table_name = b.table_name  AND a.srs_id = c.srs_id  AND a.table_name = ? AND a.data_type = ?", GEOPACKAGE_CONTENTS, GEOMETRY_COLUMNS, SPATIAL_REF_SYS);
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, name);
            ps.setString(2, DataType.Feature.value());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    FeatureEntry featureEntry = this.createFeatureEntry(rs);
                    return featureEntry;
                }
            }
        }
        return null;
    }

    public GeoPkgExtension getExtension(String name) {
        Iterator<GeoPkgExtensionFactory> factories = GeoPkgExtensionFactoryFinder.getExtensionFactories();
        while (factories.hasNext()) {
            GeoPkgExtensionFactory factory = factories.next();
            GeoPkgExtension extension = factory.getExtension(name, this);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }

    public <T extends GeoPkgExtension> T getExtension(Class<T> extensionClass) {
        Iterator<GeoPkgExtensionFactory> factories = GeoPkgExtensionFactoryFinder.getExtensionFactories();
        while (factories.hasNext()) {
            GeoPkgExtensionFactory factory = factories.next();
            GeoPkgExtension extension = factory.getExtension(extensionClass, this);
            if (extension == null) continue;
            return (T)((GeoPkgExtension)extensionClass.cast(extension));
        }
        return null;
    }

    SimpleFeatureType correctSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(schema);
        builder.setAttributes(new ArrayList<AttributeDescriptor>());
        for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
            AttributeDescriptorImpl modifiedAttribute = new AttributeDescriptorImpl(attribute.getType(), attribute.getName(), attribute.getMinOccurs(), attribute.getMaxOccurs(), attribute.isNillable(), attribute.getDefaultValue());
            modifiedAttribute.getUserData().putAll(attribute.getUserData());
            modifiedAttribute.getUserData().remove("org.geotools.jdbc.nativeTypeName");
            modifiedAttribute.getUserData().remove("org.geotools.jdbc.nativeType");
            builder.add(modifiedAttribute);
        }
        return builder.buildFeatureType();
    }

    public void create(FeatureEntry entry, SimpleFeatureType schema) throws IOException {
        schema = this.correctSchema(schema);
        FeatureEntry e = new FeatureEntry();
        e.init(entry);
        e.setTableName(schema.getTypeName());
        if (e.getGeometryColumn() != null) {
            if (schema.getDescriptor(e.getGeometryColumn()) == null) {
                throw new IllegalArgumentException(String.format("Geometry column %s does not exist in schema", e.getGeometryColumn()));
            }
        } else {
            e.setGeometryColumn(GeoPackage.findGeometryColumn(schema));
        }
        if (e.getIdentifier() == null) {
            e.setIdentifier(schema.getTypeName());
        }
        if (e.getDescription() == null) {
            e.setDescription(e.getIdentifier());
        }
        if (e.getBounds() == null) {
            throw new IllegalArgumentException("Entry must have bounds");
        }
        if (e.getSrid() == null) {
            try (Connection cx = this.connPool.getConnection();){
                e.setSrid(GeoPackage.findSRID(cx, schema));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (e.getSrid() == null) {
            throw new IllegalArgumentException("Entry must have srid");
        }
        if (e.getGeometryType() == null) {
            e.setGeometryType(GeoPackage.findGeometryType(schema));
        }
        e.setLastChange(new Date());
        schema.getUserData().put(FeatureEntry.class, e);
        JDBCDataStore dataStore = this.dataStore();
        dataStore.createSchema(schema);
        entry.init(e);
    }

    static SimpleFeatureCollection forceXY(SimpleFeatureCollection fc) {
        CoordinateReferenceSystem sourceCRS = ((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem();
        if (CRS.getAxisOrder(sourceCRS) == CRS.AxisOrder.EAST_NORTH || CRS.getAxisOrder(sourceCRS) == CRS.AxisOrder.INAPPLICABLE) {
            return fc;
        }
        for (ReferenceIdentifier identifier : sourceCRS.getIdentifiers()) {
            try {
                String _identifier = identifier.toString();
                CoordinateReferenceSystem flippedCRS = CRS.decode(_identifier, true);
                if (CRS.getAxisOrder(flippedCRS) != CRS.AxisOrder.EAST_NORTH) continue;
                ReprojectingFeatureCollection result = new ReprojectingFeatureCollection(fc, flippedCRS);
                return result;
            }
            catch (Exception exception) {
            }
        }
        return fc;
    }

    public void add(FeatureEntry entry, SimpleFeatureCollection collection) throws IOException {
        FeatureEntry e = new FeatureEntry();
        e.init(entry);
        collection = GeoPackage.forceXY(collection);
        if (e.getBounds() == null) {
            e.setBounds(collection.getBounds());
        }
        this.create(e, (SimpleFeatureType)collection.getSchema());
        try (DefaultTransaction tx = new DefaultTransaction();){
            try (SimpleFeatureWriter w = this.writer(e, true, null, tx);
                 SimpleFeatureIterator it = collection.features();){
                while (it.hasNext()) {
                    SimpleFeature f = (SimpleFeature)it.next();
                    SimpleFeature g = (SimpleFeature)w.next();
                    g.setAttributes(f.getAttributes());
                    for (PropertyDescriptor pd : ((SimpleFeatureType)collection.getSchema()).getDescriptors()) {
                        String name = pd.getName().getLocalPart();
                        if (pd.getType().getBinding() != Boolean.class) continue;
                        int bool = 0;
                        if (f.getAttribute(name) != null) {
                            bool = (Boolean)f.getAttribute(name) != false ? 1 : 0;
                        }
                        g.setAttribute(name, (Object)bool);
                    }
                    w.write();
                }
            }
            tx.commit();
        }
        entry.init(e);
    }

    public void add(FeatureEntry entry, SimpleFeatureSource source, Filter filter) throws IOException {
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        this.add(entry, source.getFeatures(filter));
    }

    public SimpleFeatureWriter writer(FeatureEntry entry, boolean append, Filter filter, Transaction tx) throws IOException {
        JDBCDataStore dataStore = this.dataStore();
        FeatureWriter<SimpleFeatureType, SimpleFeature> w = append ? dataStore.getFeatureWriterAppend(entry.getTableName(), tx) : dataStore.getFeatureWriter(entry.getTableName(), filter, tx);
        return Features.simple(w);
    }

    public SimpleFeatureReader reader(FeatureEntry entry, Filter filter, Transaction tx) throws IOException {
        Query q = new Query(entry.getTableName());
        q.setFilter(filter != null ? filter : Filter.INCLUDE);
        return Features.simple(this.dataStore().getFeatureReader(q, tx));
    }

    static Integer findSRID(Connection cx, SimpleFeatureType schema) throws Exception {
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        if (crs == null) {
            GeometryDescriptor gd = GeoPackage.findGeometryDescriptor(schema);
            crs = gd.getCoordinateReferenceSystem();
        }
        return GeoPackage.findSRID(cx, crs);
    }

    static String findGeometryColumn(SimpleFeatureType schema) {
        GeometryDescriptor gd = GeoPackage.findGeometryDescriptor(schema);
        return gd != null ? gd.getLocalName() : null;
    }

    static Geometries findGeometryType(SimpleFeatureType schema) {
        GeometryDescriptor gd = GeoPackage.findGeometryDescriptor(schema);
        if (gd != null) {
            Class<?> binding = gd.getType().getBinding();
            return Geometries.getForBinding(binding);
        }
        return null;
    }

    static GeometryDescriptor findGeometryDescriptor(SimpleFeatureType schema) {
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        if (gd == null) {
            for (PropertyDescriptor pd : schema.getDescriptors()) {
                if (!(pd instanceof GeometryDescriptor)) continue;
                return (GeometryDescriptor)pd;
            }
        }
        return gd;
    }

    FeatureEntry createFeatureEntry(ResultSet rs) throws SQLException, IOException {
        FeatureEntry e = new FeatureEntry();
        GeoPackage.initEntry(e, rs);
        e.setGeometryColumn(rs.getString("column_name"));
        e.setGeometryType(Geometries.getForName(rs.getString("geometry_type_name")));
        e.setZ(rs.getBoolean("z"));
        e.setM(rs.getBoolean("m"));
        return e;
    }

    void addGeoPackageContentsEntry(Entry e, Connection cx) throws IOException {
        try {
            Integer srid;
            SimpleDateFormat dateFormat = GeoPackage.getDateFormat();
            if (!this.initialised) {
                GeoPackage.init(cx);
            }
            if ((srid = e.getSrid()) != null && srid != 0 && srid != -1 && !this.hasCRS(cx, srid)) {
                CoordinateReferenceSystem crs = GeoPackage.decodeCRS(cx, srid);
                String identifier = CRS.lookupIdentifier(crs, false);
                String name = Optional.ofNullable(identifier).orElse(crs.getName().toString());
                String auth = "NONE";
                int code = -1;
                int idx = identifier.indexOf(":");
                if (idx > 0) {
                    auth = identifier.substring(0, idx);
                    code = Integer.parseInt(identifier.substring(idx + 1));
                }
                GeoPackage.addCRS(cx, srid, name, auth, code, crs.toWKT(), null);
            }
            StringBuilder sb = new StringBuilder();
            StringBuilder vals = new StringBuilder();
            sb.append(String.format("INSERT INTO %s (table_name, data_type, identifier", GEOPACKAGE_CONTENTS));
            vals.append("VALUES (?,?,?");
            if (e.getDescription() != null) {
                sb.append(", description");
                vals.append(",?");
            }
            if (e.getLastChange() != null) {
                sb.append(", last_change");
                vals.append(",?");
            }
            sb.append(", min_x, min_y, max_x, max_y");
            vals.append(",?,?,?,?");
            if (srid != null) {
                sb.append(", srs_id");
                vals.append(",?");
            }
            sb.append(") ").append(vals.append(")").toString());
            SqlUtil.PreparedStatementBuilder psb = SqlUtil.prepare(cx, sb.toString()).set(e.getTableName()).set(e.getDataType().value()).set(e.getIdentifier());
            if (e.getDescription() != null) {
                psb.set(e.getDescription());
            }
            if (e.getLastChange() != null) {
                psb.set(dateFormat.format(e.getLastChange()));
            }
            if (e.getBounds() != null) {
                psb.set(e.getBounds().getMinX()).set(e.getBounds().getMinY()).set(e.getBounds().getMaxX()).set(e.getBounds().getMaxY());
            } else {
                Bounds env;
                CoordinateReferenceSystem crs;
                double minx = 0.0;
                double miny = 0.0;
                double maxx = 0.0;
                double maxy = 0.0;
                if (srid != null && (crs = this.getCRS(srid)) != null && (env = CRS.getEnvelope(crs)) != null) {
                    minx = env.getMinimum(0);
                    miny = env.getMinimum(1);
                    maxx = env.getMaximum(0);
                    maxy = env.getMaximum(1);
                }
                psb.set(minx).set(miny).set(maxx).set(maxy);
            }
            if (srid != null) {
                psb.set(srid);
            }
            try (PreparedStatement ps = psb.log(Level.FINE).statement();){
                ps.execute();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat;
    }

    void deleteGeoPackageContentsEntry(Entry e) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE table_name = ?", GEOPACKAGE_CONTENTS);
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare(cx, sql).set(e.getTableName()).log(Level.FINE).statement();){
            ps.execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    void addGeometryColumnsEntry(FeatureEntry e, Connection cx) throws IOException {
        if (e.getGeometryColumn() == null || e.getGeometryColumn().isEmpty()) {
            return;
        }
        String sql = String.format("INSERT INTO %s VALUES (?, ?, ?, ?, ?, ?);", GEOMETRY_COLUMNS);
        try (PreparedStatement ps = SqlUtil.prepare(cx, sql).set(e.getTableName()).set(e.getGeometryColumn()).set(e.getGeometryType() != null ? e.getGeometryType().getName() : null).set(e.getSrid()).set(e.isZ()).set(e.isM()).log(Level.FINE).statement();){
            ps.execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    void deleteGeometryColumnsEntry(FeatureEntry e) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE table_name = ?", GEOMETRY_COLUMNS);
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare(cx, sql).set(e.getTableName()).log(Level.FINE).statement();){
            ps.execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public void createSpatialIndex(FeatureEntry e) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        PrimaryKey pk = ((JDBCFeatureStore)this.dataStore.getFeatureSource(e.getTableName())).getPrimaryKey();
        if (pk.getColumns().size() != 1) {
            throw new IOException("Spatial index only supported for primary key of single column.");
        }
        properties.put("t", e.getTableName());
        properties.put("c", e.getGeometryColumn());
        properties.put("i", pk.getColumns().get(0).getName());
        try (Connection cx = this.connPool.getConnection();){
            this.runScript("gpkg_spatial_index.sql", cx, properties);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findSRID(Connection cx, CoordinateReferenceSystem crs) {
        if (crs == null) {
            return -1;
        }
        try {
            Integer result = CRS.lookupEpsgCode(crs, true);
            if (result != null) {
                return result;
            }
            String wkt = crs.toWKT();
            String sqlWkt = "SELECT srs_id FROM gpkg_spatial_ref_sys WHERE definition = '" + wkt + "'";
            try (Statement st = cx.createStatement();
                 ResultSet rs = st.executeQuery(sqlWkt);){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
            String sqlMax = "select max(srs_id) from gpkg_spatial_ref_sys";
            int srid = -1;
            try (Statement st = cx.createStatement();
                 ResultSet rs = st.executeQuery(sqlMax);){
                if (rs.next()) {
                    srid = rs.getInt(1) + 1;
                }
            }
            if (srid == -1) {
                return srid;
            }
            if (srid < 900000) {
                srid = 900000;
            }
            String identifier = CRS.lookupIdentifier(crs, true);
            int splitIdx = identifier.indexOf(58);
            String organization = "UNKNOWN";
            int organizationCoordSysId = -1;
            if (splitIdx != -1) {
                organization = identifier.substring(0, splitIdx);
                organizationCoordSysId = Integer.parseInt(identifier.substring(splitIdx + 1));
            }
            GeoPackage.addCRS(cx, srid, crs.getName().toString(), organization, organizationCoordSysId, wkt, null);
            return srid;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion", e);
            return -1;
        }
    }

    static ReferencedEnvelope findBounds(GridCoverage2D raster) {
        Bounds e = raster.getEnvelope();
        return new ReferencedEnvelope(e.getMinimum(0), e.getMaximum(0), e.getMinimum(1), e.getMaximum(1), raster.getCoordinateReferenceSystem());
    }

    static GeneralBounds toGeneralEnvelope(ReferencedEnvelope e) {
        GeneralBounds ge = new GeneralBounds(new double[]{e.getMinX(), e.getMinY()}, new double[]{e.getMaxX(), e.getMaxY()});
        ge.setCoordinateReferenceSystem(e.getCoordinateReferenceSystem());
        return ge;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<TileEntry> tiles() throws IOException {
        ArrayList<TileEntry> entries = new ArrayList<TileEntry>();
        String sql = String.format("SELECT a.*, c.organization_coordsys_id, c.definition FROM %s a, %s c WHERE a.srs_id = c.srs_id AND a.data_type = ?", GEOPACKAGE_CONTENTS, SPATIAL_REF_SYS);
        LOGGER.fine(sql);
        try (Connection cx = this.connPool.getConnection();){
            ArrayList<TileEntry> arrayList;
            block22: {
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setString(1, DataType.Tile.value());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            entries.add(GeoPackage.createTileEntry(rs, cx));
                        }
                    }
                    arrayList = entries;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TileEntry tile(String name) throws IOException {
        String sql = String.format("SELECT a.*, c.organization_coordsys_id, c.definition FROM %s a, %s c WHERE a.srs_id = c.srs_id AND a.table_name = ? AND a.data_type = ?", GEOPACKAGE_CONTENTS, SPATIAL_REF_SYS);
        LOGGER.fine(sql);
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, name);
            ps.setString(2, DataType.Tile.value());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                TileEntry tileEntry = GeoPackage.createTileEntry(rs, cx);
                return tileEntry;
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void create(TileEntry entry) throws IOException {
        if (entry.getBounds() == null) {
            throw new IllegalArgumentException("Tile entry must specify bounds");
        }
        TileEntry e = new TileEntry();
        e.init(entry);
        if (e.getTableName() == null) {
            e.setTableName("tiles");
        }
        if (e.getIdentifier() == null) {
            e.setIdentifier(e.getTableName());
        }
        if (e.getDescription() == null) {
            e.setDescription(e.getIdentifier());
        }
        try (Connection cx = this.connPool.getConnection();){
            if (e.getSrid() == null) {
                try {
                    e.setSrid(GeoPackage.findSRID(cx, entry.getBounds().getCoordinateReferenceSystem()));
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            e.setLastChange(new Date());
            ReferencedEnvelope bounds = e.getTileMatrixSetBounds();
            if (bounds == null) {
                bounds = e.getBounds();
            }
            try (PreparedStatement st = SqlUtil.prepare(cx, String.format("INSERT INTO %s VALUES (?,?,?,?,?,?)", TILE_MATRIX_SET)).set(e.getTableName()).set(e.getSrid()).set(bounds.getMinX()).set(bounds.getMinY()).set(bounds.getMaxX()).set(bounds.getMaxY()).statement();){
                st.execute();
            }
            st = SqlUtil.prepare(cx, String.format("INSERT INTO %s VALUES (?,?,?,?,?,?,?,?)", TILE_MATRIX_METADATA)).statement();
            try {
                for (TileMatrix m : e.getTileMatricies()) {
                    SqlUtil.prepare(st).set(e.getTableName()).set(m.getZoomLevel()).set(m.getMatrixWidth()).set(m.getMatrixHeight()).set(m.getTileWidth()).set(m.getTileHeight()).set(m.getXPixelSize()).set(m.getYPixelSize()).statement().execute();
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
            st = cx.prepareStatement(String.format("CREATE TABLE \"%s\" (id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,zoom_level INTEGER NOT NULL,tile_column INTEGER NOT NULL,tile_row INTEGER NOT NULL,tile_data BLOB NOT NULL)", e.getTableName()));
            try {
                st.execute();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
            st = cx.prepareStatement(String.format("CREATE INDEX \"%s_zyx_idx\" ON \"%s\"(zoom_level, tile_column, tile_row);", e.getTableName(), e.getTableName()));
            try {
                st.execute();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
            this.addGeoPackageContentsEntry(e, cx);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        entry.init(e);
    }

    public void add(TileEntry entry, Tile tile) throws IOException {
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare(cx, String.format("INSERT INTO \"%s\" (zoom_level, tile_column, tile_row, tile_data) VALUES (?,?,?,?)", entry.getTableName())).set(tile.getZoom()).set(tile.getColumn()).set(tile.getRow()).set(tile.getData()).log(Level.FINE).statement();){
            ps.execute();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public TileReader reader(TileEntry entry, Integer lowZoom, Integer highZoom, Integer lowCol, Integer highCol, Integer lowRow, Integer highRow) throws IOException {
        ArrayList<String> q = new ArrayList<String>();
        this.addRange("zoom_level", lowZoom, highZoom, q);
        this.addRange("tile_column", lowCol, highCol, q);
        this.addRange("tile_row", lowRow, highRow, q);
        StringBuffer sql = new StringBuffer("SELECT * FROM \"").append(entry.getTableName()).append("\"");
        if (!q.isEmpty()) {
            sql.append(" WHERE ");
            for (String s : q) {
                sql.append(s).append(" AND ");
            }
            sql.setLength(sql.length() - 5);
        }
        try {
            Connection cx = this.connPool.getConnection();
            Statement st = cx.createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            return new TileReader(rs, st, cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void addRange(String attribute, Integer low, Integer high, List<String> q) {
        if (low != null && high != null && low.equals(high)) {
            q.add(attribute + " = " + low);
        } else {
            if (low != null) {
                q.add(attribute + " >= " + low);
            }
            if (high != null) {
                q.add(attribute + " <= " + high);
            }
        }
    }

    protected String getSpatialIndexName(FeatureEntry entry) {
        String spatial_index = "rtree_" + entry.getTableName() + "_" + entry.getGeometryColumn();
        return spatial_index;
    }

    /*
     * Exception decompiling
     */
    public boolean hasSpatialIndex(FeatureEntry entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Set<Identifier> searchSpatialIndex(FeatureEntry entry, Double minX, Double minY, Double maxX, Double maxY) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int getTileBound(TileEntry entry, int zoom, boolean isMax, boolean isRow) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static TileEntry createTileEntry(ResultSet rs, Connection cx) throws SQLException, IOException {
        TileEntry e;
        block28: {
            ResultSet rsm;
            e = new TileEntry();
            GeoPackage.initEntry(e, rs);
            try (PreparedStatement psm = cx.prepareStatement(String.format("SELECT *, exists(SELECT 1 FROM \"%s\" data where data.zoom_level = tileMatrix.zoom_level) as has_tiles FROM %s as tileMatrix WHERE table_name = ? ORDER BY zoom_level ASC", e.getTableName(), TILE_MATRIX_METADATA));){
                psm.setString(1, e.getTableName());
                rsm = psm.executeQuery();
                try {
                    while (rsm.next()) {
                        TileMatrix m = new TileMatrix();
                        m.setZoomLevel(rsm.getInt("zoom_level"));
                        m.setMatrixWidth(rsm.getInt("matrix_width"));
                        m.setMatrixHeight(rsm.getInt("matrix_height"));
                        m.setTileWidth(rsm.getInt("tile_width"));
                        m.setTileHeight(rsm.getInt("tile_height"));
                        m.setXPixelSize(rsm.getDouble("pixel_x_size"));
                        m.setYPixelSize(rsm.getDouble("pixel_y_size"));
                        m.setTiles(rsm.getBoolean("has_tiles"));
                        e.getTileMatricies().add(m);
                    }
                }
                finally {
                    if (rsm != null) {
                        rsm.close();
                    }
                }
            }
            psm = cx.prepareStatement(String.format("SELECT * FROM %s a, %s b WHERE a.table_name = ? AND a.srs_id = b.srs_id LIMIT 1", TILE_MATRIX_SET, SPATIAL_REF_SYS));
            try {
                psm.setString(1, e.getTableName());
                rsm = psm.executeQuery();
                try {
                    CoordinateReferenceSystem crs;
                    if (!rsm.next()) break block28;
                    int srid = rsm.getInt("organization_coordsys_id");
                    e.setSrid(srid);
                    try {
                        crs = CRS.decode("EPSG:" + srid, true);
                    }
                    catch (Exception ex) {
                        crs = e.getBounds().getCoordinateReferenceSystem();
                    }
                    e.setTileMatrixSetBounds(new ReferencedEnvelope(rsm.getDouble("min_x"), rsm.getDouble("max_x"), rsm.getDouble("min_y"), rsm.getDouble("max_y"), crs));
                }
                finally {
                    if (rsm != null) {
                        rsm.close();
                    }
                }
            }
            finally {
                if (psm != null) {
                    psm.close();
                }
            }
        }
        return e;
    }

    static void initEntry(Entry e, ResultSet rs) throws SQLException, IOException {
        e.setIdentifier(rs.getString("identifier"));
        e.setDescription(rs.getString("description"));
        e.setTableName(rs.getString("table_name"));
        try {
            SimpleDateFormat dateFormat = GeoPackage.getDateFormat();
            e.setLastChange(dateFormat.parse(rs.getString("last_change")));
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
        int srid = rs.getInt("srs_id");
        e.setSrid(srid);
        CoordinateReferenceSystem crs = GeoPackage.decodeCRS(rs.getStatement().getConnection(), srid);
        e.setBounds(new ReferencedEnvelope(rs.getDouble("min_x"), rs.getDouble("max_x"), rs.getDouble("min_y"), rs.getDouble("max_y"), crs));
    }

    /*
     * Exception decompiling
     */
    static CoordinateReferenceSystem decodeCRS(Connection cx, int srid) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void runSQL(String sql, Connection cx) throws SQLException {
        try (Statement st = cx.createStatement();){
            st.execute(sql);
        }
    }

    static void runScript(String filename, Connection cx) throws SQLException {
        SqlUtil.runScript(GeoPackage.class.getResourceAsStream(filename), cx);
    }

    void runScript(String filename, Connection cx, Map<String, String> properties) throws SQLException {
        SqlUtil.runScript(this.getClass().getResourceAsStream(filename), cx, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDBCDataStore dataStore() throws IOException {
        if (this.dataStore == null) {
            GeoPackage geoPackage = this;
            synchronized (geoPackage) {
                if (this.dataStore == null) {
                    this.dataStore = this.createDataStore();
                }
            }
        }
        return this.dataStore;
    }

    JDBCDataStore createDataStore() throws IOException {
        HashMap<String, DataSource> params = new HashMap<String, DataSource>();
        params.put(GeoPkgDataStoreFactory.DATASOURCE.key, this.connPool);
        return new GeoPkgDataStoreFactory(this.writerConfig).createDataStore(params);
    }

    public static enum DataType {
        Feature("features"),
        Raster("rasters"),
        Tile("tiles"),
        FeatureWithRaster("featuresWithRasters");

        String value;

        private DataType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

