/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.geotools.util.NumberRange;

public abstract class DataColumnConstraint {
    String name;

    public DataColumnConstraint(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class Range<T extends Number>
    extends DataColumnConstraint {
        private final NumberRange<T> range;

        public Range(String name, NumberRange<T> range) {
            super(name);
            this.range = range;
        }

        public NumberRange<T> getRange() {
            return this.range;
        }

        public String toString() {
            return "Range{name='" + this.name + "', range=" + this.range + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range1 = (Range)o;
            return Objects.equals(this.range, range1.range);
        }

        public int hashCode() {
            return Objects.hash(this.range);
        }
    }

    public static class Glob
    extends DataColumnConstraint {
        private final String glob;

        public Glob(String name, String glob) {
            super(name);
            this.glob = glob;
        }

        public String getGlob() {
            return this.glob;
        }

        public String toString() {
            return "Glob{name='" + this.name + "', glob='" + this.glob + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Glob glob1 = (Glob)o;
            return Objects.equals(this.glob, glob1.glob);
        }

        public int hashCode() {
            return Objects.hash(this.glob);
        }
    }

    public static class Enum
    extends DataColumnConstraint {
        private final Map<String, String> values;

        public Enum(String name, Map<String, String> values) {
            super(name);
            this.values = values;
        }

        public Enum(String name, String ... values) {
            super(name);
            if (values == null || values.length == 0) {
                throw new IllegalArgumentException("Enum values cannot be empty or null");
            }
            this.values = new LinkedHashMap<String, String>();
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                this.values.put(String.valueOf(i), value);
            }
        }

        public Map<String, String> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public String toString() {
            return "Enum{name='" + this.name + "', values=" + this.values + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Enum anEnum = (Enum)o;
            return Objects.equals(this.values, anEnum.values);
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }
    }
}

