/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;

public final class LineIterator2
implements PathIterator {
    private double[] allCoords;
    private AffineTransform at;
    private int currentCoord = 0;
    private int actualCoords;
    private boolean done = false;

    @Override
    public int currentSegment(float[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = (float)this.allCoords[0];
            coords[1] = (float)this.allCoords[1];
            if (this.at != null) {
                this.at.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        coords[0] = (float)this.allCoords[this.currentCoord * 2];
        coords[1] = (float)this.allCoords[this.currentCoord * 2 + 1];
        if (this.at != null) {
            this.at.transform(coords, 0, coords, 0, 1);
        }
        return 1;
    }

    public void init(LineString ls, AffineTransform at) {
        this.at = at == null || at.isIdentity() ? null : at;
        CoordinateSequence coordinates = ls.getCoordinateSequence();
        if (coordinates instanceof LiteCoordinateSequence) {
            this.allCoords = ((LiteCoordinateSequence)coordinates).getXYArray();
            this.actualCoords = coordinates.size();
        } else {
            this.actualCoords = coordinates.size();
            this.allCoords = new double[this.actualCoords * 2];
            for (int t = 0; t < this.actualCoords; ++t) {
                this.allCoords[t * 2] = coordinates.getOrdinate(t, 0);
                this.allCoords[t * 2 + 1] = coordinates.getOrdinate(t, 1);
            }
        }
        this.done = false;
        this.currentCoord = 0;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (this.currentCoord == this.actualCoords - 1) {
            this.done = true;
        } else {
            ++this.currentCoord;
        }
    }

    @Override
    public int currentSegment(double[] coords) {
        float[] fco = new float[6];
        int result = this.currentSegment(fco);
        coords[0] = fco[0];
        coords[1] = fco[1];
        coords[2] = fco[2];
        coords[3] = fco[3];
        return result;
    }
}

