/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.util.CRSConverterFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class ReferencedEnvelopeConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (ReferencedEnvelope.class.isAssignableFrom(target) && String.class.equals((Object)source)) {
            return new Converter(){
                final CRSConverterFactory.CRSConverter crsConverter = new CRSConverterFactory.CRSConverter();

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    Pattern pat = Pattern.compile("\\[([-+]?[0-9]*\\.?[0-9]+) : ([-+]?[0-9]*\\.?[0-9]+), ([-+]?[0-9]*\\.?[0-9]+) : ([-+]?[0-9]*\\.?[0-9]+)] \\{(.*)\\}", 40);
                    Matcher m = pat.matcher((String)source);
                    if (m.find()) {
                        double minX = Double.parseDouble(m.group(1));
                        double maxX = Double.parseDouble(m.group(2));
                        double minY = Double.parseDouble(m.group(3));
                        double maxY = Double.parseDouble(m.group(4));
                        try {
                            CoordinateReferenceSystem crs = this.crsConverter.convert(m.group(5), CoordinateReferenceSystem.class);
                            return target.cast(new ReferencedEnvelope(minX, maxX, minY, maxY, crs));
                        }
                        catch (FactoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    throw new RuntimeException("Badly formed ReferencedEnvelope");
                }
            };
        }
        if (ReferencedEnvelope.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            return new Converter(){

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    ReferencedEnvelope env = (ReferencedEnvelope)source;
                    CRSConverterFactory.CRSConverter crsConverter = new CRSConverterFactory.CRSConverter();
                    String crs = crsConverter.convert(env.getCoordinateReferenceSystem(), String.class);
                    return target.cast("[" + env.getMinX() + " : " + env.getMaxX() + ", " + env.getMinY() + " : " + env.getMaxY() + "] {" + crs + "}");
                }
            };
        }
        return null;
    }
}

