/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchIdentifierException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.datum.DatumFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.measure.Units;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import si.uom.NonSI;
import si.uom.SI;

public final class GeoTiffMetadata2CRSAdapter {
    private static final Logger LOGGER = Logging.getLogger(GeoTiffMetadata2CRSAdapter.class);
    private static final AffineTransform PixelIsArea2PixelIsPoint = AffineTransform.getTranslateInstance(0.5, 0.5);
    private static final String UNNAMED = "unnamed";
    private final DatumFactory datumObjFactory;
    private Hints hints;
    private final MathTransformFactory mtFactory;
    private final AllAuthoritiesFactory allAuthoritiesFactory;

    public GeoTiffMetadata2CRSAdapter(Hints hints) {
        this.hints = hints != null ? hints.clone() : GeoTools.getDefaultHints().clone();
        this.allAuthoritiesFactory = new AllAuthoritiesFactory(this.hints);
        this.datumObjFactory = ReferencingFactoryFinder.getDatumFactory(this.hints);
        this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(this.hints);
    }

    public CoordinateReferenceSystem createCoordinateSystem(GeoTiffIIOMetadataDecoder metadata) throws Exception {
        switch (GeoTiffMetadata2CRSAdapter.getGeoKeyAsInt(1024, metadata)) {
            case 1: {
                return this.createProjectedCoordinateReferenceSystem(metadata);
            }
            case 2: {
                return this.createGeographicCoordinateReferenceSystem(metadata);
            }
            case 32767: {
                String citation = metadata.getGeoKey(3073);
                if (citation == null || !citation.startsWith("ESRI PE String =")) break;
                String wkt = citation.substring(17);
                try {
                    return CRS.parseWKT(wkt);
                }
                catch (FactoryException unavailable) {
                    throw new UnsupportedOperationException("GeoTiffMetadata2CRSAdapter::createCoordinateSystem: User-defined requires citation of form 'ESRI PE String = <wkt>'");
                }
            }
        }
        throw new UnsupportedOperationException("GeoTiffMetadata2CRSAdapter::createCoordinateSystem:Only Geographic & Projected Systems are supported.User-defined partially supported with citation of form 'ESRI PE String = <wkt>'");
    }

    private ProjectedCRS createProjectedCoordinateReferenceSystem(GeoTiffIIOMetadataDecoder metadata) throws Exception {
        Unit linearUnit;
        Object projCode = metadata.getGeoKey(3072);
        projCode = projCode == null ? UNNAMED : ((String)projCode).trim();
        try {
            linearUnit = this.createUnit(3076, 3077, SI.METRE, SI.METRE, metadata);
        }
        catch (GeoTiffException e) {
            linearUnit = null;
        }
        if (((String)projCode).equalsIgnoreCase(UNNAMED) || ((String)projCode).equals("32767")) {
            return this.createUserDefinedPCS(metadata, linearUnit);
        }
        try {
            boolean isDefaultUnit;
            if (!((String)projCode).toUpperCase().startsWith("EPSG:")) {
                projCode = "EPSG:" + (String)projCode;
            }
            ProjectedCRS pcrs = (ProjectedCRS)this.allAuthoritiesFactory.createCoordinateReferenceSystem(((String)projCode).toString());
            boolean bl = isDefaultUnit = metadata.getGeoKey(3076) == null && linearUnit != null && linearUnit.equals(SI.METRE);
            if (linearUnit == null || isDefaultUnit || linearUnit.equals(pcrs.getCoordinateSystem().getAxis(0).getUnit())) {
                return pcrs;
            }
            DefiningConversion conversionFromBase = new DefiningConversion(pcrs.getConversionFromBase().getName().getCode(), pcrs.getConversionFromBase().getParameterValues());
            return new DefaultProjectedCRS(Collections.singletonMap("name", DefaultEllipsoidalCS.getName(pcrs, Citations.EPSG)), (Conversion)conversionFromBase, pcrs.getBaseCRS(), pcrs.getConversionFromBase().getMathTransform(), (CartesianCS)this.createProjectedCS(linearUnit));
        }
        catch (FactoryException fe) {
            GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw ex;
        }
    }

    private GeographicCRS createGeographicCoordinateReferenceSystem(GeoTiffIIOMetadataDecoder metadata) throws IOException {
        GeographicCRS gcs = null;
        String tempCode = metadata.getGeoKey(2048);
        Unit<Angle> angularUnit = null;
        try {
            angularUnit = this.createUnit(2054, 2055, SI.RADIAN, NonSI.DEGREE_ANGLE, metadata);
        }
        catch (GeoTiffException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            angularUnit = null;
        }
        if (angularUnit == null) {
            angularUnit = NonSI.DEGREE_ANGLE;
        }
        Unit linearUnit = null;
        try {
            linearUnit = this.createUnit(2052, 2053, SI.METRE, SI.METRE, metadata);
        }
        catch (GeoTiffException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            linearUnit = null;
        }
        if (linearUnit == null) {
            linearUnit = SI.METRE;
        }
        if (tempCode == null || tempCode.equals("32767")) {
            gcs = this.createUserDefinedGCS(metadata, linearUnit, angularUnit);
        } else {
            try {
                StringBuilder geogCode = new StringBuilder(tempCode);
                if (!tempCode.startsWith("EPSG") && !tempCode.startsWith("epsg")) {
                    geogCode.insert(0, "EPSG:");
                }
                gcs = (GeographicCRS)this.allAuthoritiesFactory.createCoordinateReferenceSystem(geogCode.toString());
                if (angularUnit != null && !angularUnit.equals(gcs.getCoordinateSystem().getAxis(0).getUnit())) {
                    gcs = new DefaultGeographicCRS(DefaultEllipsoidalCS.getName(gcs, Citations.EPSG), gcs.getDatum(), (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D.usingUnit(angularUnit));
                }
            }
            catch (FactoryException fe) {
                GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
                throw ex;
            }
        }
        return gcs;
    }

    private static int getGeoKeyAsInt(int key, GeoTiffIIOMetadataDecoder metadata) {
        try {
            return Integer.parseInt(metadata.getGeoKey(key));
        }
        catch (NumberFormatException ne) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, ne.getLocalizedMessage(), ne);
            }
            return 0;
        }
    }

    public static MathTransform getRasterToModel(GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        Utilities.ensureNonNull("metadata", metadata);
        boolean hasTiePoints = metadata.hasTiePoints();
        boolean hasPixelScales = metadata.hasPixelScales();
        boolean hasModelTransformation = metadata.hasModelTrasformation();
        int rasterType = GeoTiffMetadata2CRSAdapter.getGeoKeyAsInt(1025, metadata);
        if (rasterType == 0) {
            rasterType = 1;
        }
        LinearTransform xform = null;
        if (hasTiePoints && hasPixelScales) {
            TiePoint[] tiePoints = metadata.getModelTiePoints();
            PixelScale pixScales = metadata.getModelPixelScales();
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder();
                builder.append("Logging tiePoints:").append("\n");
                for (TiePoint t : tiePoints) {
                    builder.append(t.toString()).append("\n");
                }
                builder.append("Logging pixScales:").append("\n");
                builder.append(pixScales.toString()).append("\n");
                LOGGER.log(Level.FINE, builder.toString());
            }
            GeneralMatrix gm = new GeneralMatrix(3);
            double scaleRaster2ModelLongitude = pixScales.getScaleX();
            double scaleRaster2ModelLatitude = -pixScales.getScaleY();
            double tiePointColumn = tiePoints[0].getValueAt(0) + (rasterType == 1 ? -0.5 : 0.0);
            double tiePointRow = tiePoints[0].getValueAt(1) + (rasterType == 1 ? -0.5 : 0.0);
            gm.setElement(0, 0, scaleRaster2ModelLongitude);
            gm.setElement(1, 1, scaleRaster2ModelLatitude);
            gm.setElement(0, 1, 0.0);
            gm.setElement(1, 0, 0.0);
            gm.setElement(0, 2, tiePoints[0].getValueAt(3) - scaleRaster2ModelLongitude * tiePointColumn);
            gm.setElement(1, 2, tiePoints[0].getValueAt(4) - scaleRaster2ModelLatitude * tiePointRow);
            xform = ProjectiveTransform.create(gm);
        } else if (hasModelTransformation) {
            AffineTransform modelTransformation = metadata.getModelTransformation();
            if (modelTransformation == null) {
                throw new GeoTiffException(metadata, "Null modelTransformation", null);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder();
                builder.append("Logging ModelTransformation:").append("\n");
                builder.append(modelTransformation.toString()).append("\n");
                LOGGER.log(Level.FINE, builder.toString());
            }
            if (rasterType == 1) {
                AffineTransform tempTransform = new AffineTransform(modelTransformation);
                tempTransform.concatenate(PixelIsArea2PixelIsPoint);
                xform = ProjectiveTransform.create(tempTransform);
            } else {
                assert (rasterType == 2);
                xform = ProjectiveTransform.create(modelTransformation);
            }
        } else {
            throw new GeoTiffException(metadata, "Unknown Raster to Model configuration.", null);
        }
        try {
            xform.inverse();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Invalid model transformation found!\n" + e.getLocalizedMessage(), e);
            }
            return null;
        }
        return xform;
    }

    public static PixelInCell getRasterType(GeoTiffIIOMetadataDecoder metadata) {
        int rasterType = GeoTiffMetadata2CRSAdapter.getGeoKeyAsInt(1025, metadata);
        if (rasterType == 0) {
            rasterType = 1;
        }
        if (rasterType == 1) {
            return PixelInCell.CELL_CORNER;
        }
        if (rasterType == 2) {
            return PixelInCell.CELL_CENTER;
        }
        throw new IllegalArgumentException("Unsupported rasterType");
    }

    private static double getGeoKeyAsDouble(int key, GeoTiffIIOMetadataDecoder metadata) {
        try {
            String geoKey = metadata.getGeoKey(key);
            if (geoKey != null) {
                return Double.parseDouble(geoKey);
            }
            return Double.NaN;
        }
        catch (NumberFormatException ne) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, ne.getLocalizedMessage(), ne);
            }
            return Double.NaN;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return Double.NaN;
        }
    }

    private ProjectedCRS createUserDefinedPCS(GeoTiffIIOMetadataDecoder metadata, Unit<?> linearUnit) throws Exception {
        Conversion conversionFromBase;
        MathTransform transform;
        GeographicCRS baseCRS = this.createGeographicCoordinateReferenceSystem(metadata);
        String pcsCitationGeoKey = metadata.getGeoKey(3073);
        String projectedCrsName = pcsCitationGeoKey;
        projectedCrsName = projectedCrsName == null ? UNNAMED.intern() : GeoTiffMetadata2CRSAdapter.cleanName(projectedCrsName);
        String projCode = metadata.getGeoKey(3074);
        boolean projUserDefined = false;
        if (projCode == null || projCode.equals("32767")) {
            projUserDefined = true;
        }
        String projectionName = null;
        if (projUserDefined) {
            ParameterValueGroup parameters;
            String citationName = metadata.getGeoKey(1026);
            if ((projectedCrsName == null || UNNAMED.equalsIgnoreCase(projectedCrsName)) && citationName != null) {
                projectedCrsName = citationName;
            }
            if ((projectionName = pcsCitationGeoKey) == null) {
                String string = projectionName = citationName != null ? citationName : UNNAMED;
            }
            if ((parameters = this.createUserDefinedProjectionParameter(projectionName, metadata)) == null) {
                throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createUserDefinedPCS:Projection is not supported.", null);
            }
            this.refineParameters(baseCRS, parameters);
            transform = this.mtFactory.createParameterizedTransform(parameters);
            conversionFromBase = new DefiningConversion(Collections.singletonMap("name", GeoTiffMetadata2CRSAdapter.cleanName(projectionName)), (OperationMethod)new DefaultOperationMethod(transform), transform);
        } else {
            conversionFromBase = (Conversion)this.allAuthoritiesFactory.createCoordinateOperation("EPSG:" + projCode);
            ParameterValueGroup parameters = conversionFromBase.getParameterValues();
            this.refineParameters(baseCRS, parameters);
            transform = this.mtFactory.createParameterizedTransform(parameters);
        }
        if (projUserDefined) {
            if (linearUnit != null && linearUnit.equals(SI.METRE)) {
                return new DefaultProjectedCRS(Collections.singletonMap("name", projectedCrsName), conversionFromBase, baseCRS, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
            }
            return new DefaultProjectedCRS(Collections.singletonMap("name", projectedCrsName), conversionFromBase, baseCRS, transform, (CartesianCS)DefaultCartesianCS.PROJECTED.usingUnit(linearUnit));
        }
        if (linearUnit != null && !linearUnit.equals(SI.METRE)) {
            return new DefaultProjectedCRS(Collections.singletonMap("name", projectedCrsName), conversionFromBase, baseCRS, transform, (CartesianCS)DefaultCartesianCS.PROJECTED.usingUnit(linearUnit));
        }
        return new DefaultProjectedCRS(Collections.singletonMap("name", projectedCrsName), conversionFromBase, baseCRS, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }

    private void refineParameters(GeographicCRS baseCRS, ParameterValueGroup parameters) throws InvalidParameterValueException, ParameterNotFoundException {
        GeodeticDatum tempDatum = baseCRS.getDatum();
        DefaultEllipsoid tempEll = (DefaultEllipsoid)tempDatum.getEllipsoid();
        double inverseFlattening = tempEll.getInverseFlattening();
        double semiMajorAxis = tempEll.getSemiMajorAxis();
        parameters.parameter("semi_minor").setValue(semiMajorAxis * (1.0 - 1.0 / inverseFlattening));
        parameters.parameter("semi_major").setValue(semiMajorAxis);
    }

    private static final String cleanName(String tiffName) {
        int index = tiffName.lastIndexOf(36);
        if (index != -1) {
            tiffName = tiffName.substring(index + 1);
        }
        if ((index = tiffName.lastIndexOf(10)) != -1) {
            tiffName = tiffName.substring(index + 1);
        }
        if ((index = tiffName.lastIndexOf(13)) != -1) {
            tiffName = tiffName.substring(index + 1);
        }
        return tiffName;
    }

    private DefaultCartesianCS createProjectedCS(Unit<?> linearUnit) {
        if (linearUnit == null) {
            throw new NullPointerException("Error when trying to create a PCS using this linear UoM ");
        }
        if (!linearUnit.isCompatible(SI.METRE)) {
            throw new IllegalArgumentException("Error when trying to create a PCS using this linear UoM " + linearUnit.toString());
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", Vocabulary.formatInternational(177).toString());
        props.put("alias", Vocabulary.formatInternational(177).toString());
        return new DefaultCartesianCS((Map<String, ?>)props, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Vocabulary.formatInternational(55), "E", AxisDirection.EAST, linearUnit), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Vocabulary.formatInternational(150), "N", AxisDirection.NORTH, linearUnit));
    }

    private PrimeMeridian createPrimeMeridian(GeoTiffIIOMetadataDecoder metadata, Unit angularUnit) throws IOException {
        String pmCode = metadata.getGeoKey(2051);
        String customPrimeMeridian = Optional.ofNullable(metadata.getGeographicCitation()).map(c -> c.getPrimem()).orElse(null);
        PrimeMeridian pm = null;
        try {
            if ("32767".equals(pmCode) || customPrimeMeridian != null) {
                double pmNumeric = Optional.ofNullable(metadata.getGeoKey(2061)).map(Double::parseDouble).orElse(0.0);
                String name = Optional.ofNullable(customPrimeMeridian).orElse(UNNAMED);
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("name", name);
                Unit angleUnit = angularUnit;
                pm = this.datumObjFactory.createPrimeMeridian(props, pmNumeric, angleUnit);
            } else {
                pm = pmCode == null ? DefaultPrimeMeridian.GREENWICH : this.allAuthoritiesFactory.createPrimeMeridian("EPSG:" + pmCode);
            }
        }
        catch (FactoryException fe) {
            GeoTiffException io = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw io;
        }
        return pm;
    }

    private GeodeticDatum createGeodeticDatum(Unit<?> unit, Unit<?> angularUnit, GeoTiffIIOMetadataDecoder metadata) throws IOException {
        GeodeticDatum datum = null;
        String datumCode = metadata.getGeoKey(2050);
        if (datumCode == null) {
            throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createGeodeticDatum(Unit unit):A user defined Geographic Coordinate system must include a predefined datum!", null);
        }
        if (datumCode.equals("32767")) {
            String name = Optional.ofNullable(metadata.getGeographicCitation()).map(c -> c.getDatum()).orElse(UNNAMED);
            if (name.trim().equalsIgnoreCase("WGS84")) {
                return DefaultGeodeticDatum.WGS84;
            }
            Ellipsoid ellipsoid = this.createEllipsoid(unit, metadata);
            PrimeMeridian primeMeridian = this.createPrimeMeridian(metadata, angularUnit);
            datum = new DefaultGeodeticDatum(GeoTiffMetadata2CRSAdapter.cleanName(name), ellipsoid, primeMeridian);
        } else {
            try {
                datum = (GeodeticDatum)this.allAuthoritiesFactory.createDatum("EPSG:" + datumCode);
            }
            catch (Exception cce) {
                GeoTiffException ex = new GeoTiffException(metadata, cce.getLocalizedMessage(), cce);
                throw ex;
            }
        }
        return datum;
    }

    private Ellipsoid createEllipsoid(Unit unit, GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        String ellipsoidKey = metadata.getGeoKey(2056);
        String temp = null;
        if (ellipsoidKey.equals("32767")) {
            double inverseFlattening;
            String name = Optional.ofNullable(metadata.getGeographicCitation()).map(c -> c.getEllipsoid()).map(n -> GeoTiffMetadata2CRSAdapter.cleanName(n)).orElse(UNNAMED);
            if (name.trim().equalsIgnoreCase("WGS84")) {
                return DefaultEllipsoid.WGS84;
            }
            temp = metadata.getGeoKey(2057);
            double semiMajorAxis = temp != null ? Double.parseDouble(temp) : Double.NaN;
            temp = metadata.getGeoKey(2059);
            if (temp != null) {
                inverseFlattening = temp != null ? Double.parseDouble(temp) : Double.NaN;
            } else {
                temp = metadata.getGeoKey(2058);
                double semiMinorAxis = temp != null ? Double.parseDouble(temp) : Double.NaN;
                inverseFlattening = semiMajorAxis / (semiMajorAxis - semiMinorAxis);
            }
            Unit lengthUnit = unit;
            return DefaultEllipsoid.createFlattenedSphere(name, semiMajorAxis, inverseFlattening, (Unit<Length>)lengthUnit);
        }
        try {
            return this.allAuthoritiesFactory.createEllipsoid("EPSG:" + ellipsoidKey);
        }
        catch (FactoryException fe) {
            GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw ex;
        }
    }

    private GeographicCRS createUserDefinedGCS(GeoTiffIIOMetadataDecoder metadata, Unit<?> linearUnit, Unit<?> angularUnit) throws IOException {
        String name = Optional.ofNullable(metadata.getGeographicCitation()).map(c -> c.getGcsName()).map(n -> GeoTiffMetadata2CRSAdapter.cleanName(n)).orElse(UNNAMED);
        GeodeticDatum datum = this.createGeodeticDatum(linearUnit, angularUnit, metadata);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", name);
        return new DefaultGeographicCRS(props, datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D.usingUnit(angularUnit));
    }

    private ParameterValueGroup createUserDefinedProjectionParameter(String name, GeoTiffIIOMetadataDecoder metadata) throws IOException, FactoryException {
        String coordTrans = metadata.getGeoKey(3075);
        if (coordTrans == null || coordTrans.equalsIgnoreCase("32767")) {
            throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createUserDefinedProjectionParameter(String name):User defined projections must specify coordinate transformation code in ProjCoordTransGeoKey", null);
        }
        return this.setParametersForProjection(name, coordTrans, metadata);
    }

    private ParameterValueGroup setParametersForProjection(String name, String coordTransCode, GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        ParameterValueGroup parameters = null;
        try {
            int code = 0;
            if (coordTransCode != null) {
                code = Integer.parseInt(coordTransCode);
            }
            if (name == null) {
                name = UNNAMED;
            }
            if (name.equalsIgnoreCase("transverse_mercator") || code == 1) {
                parameters = this.mtFactory.getDefaultParameters("transverse_mercator");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Equidistant_Cylindrical") || name.equalsIgnoreCase("Plate_Carree") || name.equalsIgnoreCase("Equidistant_Cylindrical") || code == 17) {
                parameters = this.mtFactory.getDefaultParameters("Equidistant_Cylindrical");
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("mercator_1SP") || name.equalsIgnoreCase("Mercator_2SP") || code == 7) {
                double standard_parallel_1 = GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3078, metadata);
                boolean isMercator2SP = false;
                if (!Double.isNaN(standard_parallel_1)) {
                    parameters = this.mtFactory.getDefaultParameters("Mercator_2SP");
                    isMercator2SP = true;
                } else {
                    parameters = this.mtFactory.getDefaultParameters("Mercator_1SP");
                }
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                if (isMercator2SP) {
                    parameters.parameter("standard_parallel_1").setValue(standard_parallel_1);
                } else {
                    parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getScaleFactor(metadata));
                }
                return parameters;
            }
            if (name.equalsIgnoreCase("lambert_conformal_conic_1SP") || code == 9) {
                parameters = this.mtFactory.getDefaultParameters("lambert_conformal_conic_1SP");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("lambert_conformal_conic_2SP") || name.equalsIgnoreCase("lambert_conformal_conic_2SP_Belgium") || code == 8) {
                parameters = this.mtFactory.getDefaultParameters("lambert_conformal_conic_2SP");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("standard_parallel_1").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3078, metadata));
                parameters.parameter("standard_parallel_2").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3079, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Krovak")) {
                parameters = this.mtFactory.getDefaultParameters("Krovak");
                parameters.parameter("longitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("azimuth").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3078, metadata));
                parameters.parameter("pseudo_standard_parallel_1").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3079, metadata));
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("stereographic") || code == 14) {
                parameters = this.mtFactory.getDefaultParameters("stereographic");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("polar_stereographic") || code == 15) {
                parameters = this.mtFactory.getDefaultParameters("polar_stereographic");
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("oblique_stereographic") || code == 16) {
                parameters = this.mtFactory.getDefaultParameters("Oblique_Stereographic");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("oblique_mercator") || name.equalsIgnoreCase("hotine_oblique_mercator") || code == 3) {
                parameters = this.mtFactory.getDefaultParameters("oblique_mercator");
                parameters.parameter("scale_factor").setValue(GeoTiffMetadata2CRSAdapter.getScaleFactor(metadata));
                parameters.parameter("azimuth").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3094, metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                parameters.parameter("longitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("albers_Conic_Equal_Area") || code == 11) {
                parameters = this.mtFactory.getDefaultParameters("Albers_Conic_Equal_Area");
                parameters.parameter("standard_parallel_1").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3078, metadata));
                parameters.parameter("standard_parallel_2").setValue(GeoTiffMetadata2CRSAdapter.getGeoKeyAsDouble(3079, metadata));
                parameters.parameter("latitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("longitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Orthographic") || code == 21) {
                parameters = this.mtFactory.getDefaultParameters("orthographic");
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("longitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Lambert_Azimuthal_Equal_Area") || code == 10) {
                parameters = this.mtFactory.getDefaultParameters("Lambert_Azimuthal_Equal_Area");
                parameters.parameter("latitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("longitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Azimuthal_Equidistant") || code == 12) {
                parameters = this.mtFactory.getDefaultParameters("Azimuthal_Equidistant");
                parameters.parameter("longitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("latitude_of_center").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("New_Zealand_Map_Grid") || code == 26) {
                parameters = this.mtFactory.getDefaultParameters("New_Zealand_Map_Grid");
                parameters.parameter("latitude_of_origin").setValue(GeoTiffMetadata2CRSAdapter.getOriginLat(metadata));
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("World_Van_der_Grinten_I") || code == 25) {
                parameters = this.mtFactory.getDefaultParameters("World_Van_der_Grinten_I");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Sinusoidal") || code == 24) {
                parameters = this.mtFactory.getDefaultParameters("Sinusoidal");
                parameters.parameter("central_meridian").setValue(GeoTiffMetadata2CRSAdapter.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(GeoTiffMetadata2CRSAdapter.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(GeoTiffMetadata2CRSAdapter.getFalseNorthing(metadata));
                return parameters;
            }
        }
        catch (NoSuchIdentifierException e) {
            throw new GeoTiffException(metadata, e.getLocalizedMessage(), e);
        }
        return parameters;
    }

    private static double getScaleFactor(GeoTiffIIOMetadataDecoder metadata) {
        String scale = metadata.getGeoKey(3093);
        if (scale == null) {
            scale = metadata.getGeoKey(3092);
        }
        if (scale == null) {
            return 1.0;
        }
        return Double.parseDouble(scale);
    }

    private static double getFalseEasting(GeoTiffIIOMetadataDecoder metadata) {
        String easting = metadata.getGeoKey(3082);
        if (easting == null) {
            easting = metadata.getGeoKey(3086);
        }
        if (easting == null) {
            return 0.0;
        }
        return Double.parseDouble(easting);
    }

    private static double getFalseNorthing(GeoTiffIIOMetadataDecoder metadata) {
        String northing = metadata.getGeoKey(3083);
        if (northing == null) {
            northing = metadata.getGeoKey(3087);
        }
        if (northing == null) {
            return 0.0;
        }
        return Double.parseDouble(northing);
    }

    private static double getOriginLong(GeoTiffIIOMetadataDecoder metadata) {
        String origin = metadata.getGeoKey(3088);
        if (origin == null) {
            origin = metadata.getGeoKey(3080);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3084);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3095);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3083);
        }
        if (origin == null) {
            return 0.0;
        }
        return Double.parseDouble(origin);
    }

    private static double getOriginLat(GeoTiffIIOMetadataDecoder metadata) {
        String origin = metadata.getGeoKey(3089);
        if (origin == null) {
            origin = metadata.getGeoKey(3081);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3085);
        }
        if (origin == null) {
            return 0.0;
        }
        return Double.parseDouble(origin);
    }

    private <Q extends Quantity<Q>> Unit<Q> createUnit(int key, int userDefinedKey, Unit<Q> base, Unit<Q> def, GeoTiffIIOMetadataDecoder metadata) throws IOException {
        String unitCode = metadata.getGeoKey(key);
        if (unitCode == null) {
            return def;
        }
        if (unitCode.equals("32767")) {
            try {
                String unitSize = metadata.getGeoKey(userDefinedKey);
                if (unitSize == null) {
                    throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createUnit:Must define unit length when using a user defined unit", null);
                }
                double sz = Double.parseDouble(unitSize);
                Unit<Q> factor = base.multiply(sz);
                return Units.autoCorrect(factor);
            }
            catch (NumberFormatException nfe) {
                GeoTiffException ioe = new GeoTiffException(metadata, nfe.getLocalizedMessage(), nfe);
                throw ioe;
            }
        }
        try {
            Unit<?> result = this.allAuthoritiesFactory.createUnit("EPSG:" + unitCode);
            return result;
        }
        catch (FactoryException fe) {
            GeoTiffException io = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw io;
        }
    }
}

