/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Point;
import java.text.MessageFormat;
import org.geotools.api.coverage.grid.GridCoordinates;
import org.geotools.coverage.grid.GeneralGridCoordinates;

public class GridCoordinates2D
extends Point
implements GridCoordinates {
    private static final long serialVersionUID = -4583333545268906740L;

    public GridCoordinates2D() {
    }

    public GridCoordinates2D(int x, int y) {
        super(x, y);
    }

    public GridCoordinates2D(Point coordinates) {
        super(coordinates);
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public int[] getCoordinateValues() {
        return new int[]{this.x, this.y};
    }

    @Override
    public int getCoordinateValue(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    @Override
    public void setCoordinateValue(int dimension, int value) throws IndexOutOfBoundsException, UnsupportedOperationException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
            }
        }
    }

    static String indexOutOfBounds(int dimension) {
        return MessageFormat.format("Index {0} is out of bounds.", dimension);
    }

    @Override
    public String toString() {
        return GeneralGridCoordinates.toString(this);
    }

    @Override
    public GridCoordinates2D clone() {
        return (GridCoordinates2D)super.clone();
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }
}

