/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import it.geosolutions.rendered.viewer.ZoomableImageDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.BinarizeDescriptor;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.HistogramDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ImageViewer
extends JPanel {
    private static final int THRESHOLD_2K_X_2K = 0x400000;
    ZoomableImageDisplay display;
    ImageViewer relatedViewer;
    private JLabel status;
    private RandomIter pixelIter;
    private int[] ipixel;
    private double[] dpixel;
    JCheckBox tileGrid;
    JCheckBox roiSync;
    JCheckBox rescaleValues;
    private StringBuffer sb = new StringBuffer();
    private RenderedImage image;
    protected File lastDirectory;
    private JScrollBar vScrollBar;
    private JScrollBar hScrollBar;

    public ImageViewer(ImageViewer relatedViewer) {
        this();
        this.relatedViewer = relatedViewer;
    }

    public ImageViewer() {
        String[] zooms;
        this.setLayout(new BorderLayout());
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new FlowLayout(0));
        for (String zoom : zooms = new String[]{"in", "out"}) {
            String alternativeText = "Zoom " + zoom;
            String zoomIconName = "zoom-" + zoom + ".png";
            JButton zoomButton = this.createDecoratedButton(alternativeText, alternativeText, zoomIconName);
            final double scale = zoom.equalsIgnoreCase("in") ? 2.0 : 0.5;
            zoomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewer.this.display.setScale(ImageViewer.this.display.getScale() * scale);
                    if (ImageViewer.this.relatedViewer != null) {
                        ImageViewer.this.relatedViewer.display.setScale(ImageViewer.this.relatedViewer.display.getScale() * scale);
                    }
                }
            });
            buttonBar.add(zoomButton);
        }
        this.tileGrid = new JCheckBox("Tile grid");
        this.tileGrid.setToolTipText("Toggle Tile Grid");
        this.tileGrid.setRolloverEnabled(false);
        this.roiSync = new JCheckBox("ROI sync");
        this.roiSync.setToolTipText("Keep the ROIViewer viewport aligned with the main Viewer");
        this.rescaleValues = new JCheckBox("Rescale");
        this.rescaleValues.setToolTipText("When needed, rescale image to byte values for viewing. (Pixel value at mouse position will still show raw value)");
        this.rescaleValues.setRolloverEnabled(false);
        JButton save = this.createDecoratedButton("Save", "Save whole image to png/tif", "save.png");
        JButton showChain = this.createDecoratedButton("Show chain in separate window", "Open a new viewer with the current image as root of the processing chain", "other-window.png");
        JButton showDump = this.createDecoratedButton("Chain As Text", "Show the processing chain dumped as textual info", "chain-text.png");
        buttonBar.add(this.tileGrid);
        buttonBar.add(this.roiSync);
        buttonBar.add(this.rescaleValues);
        buttonBar.add(save);
        buttonBar.add(showChain);
        buttonBar.add(showDump);
        this.display = new ZoomableImageDisplay();
        this.tileGrid.setSelected(this.display.isTileGridVisible());
        this.status = new JLabel("Move on the image to display pixel values... ");
        JScrollPane scrollPane = new JScrollPane(this.display);
        this.vScrollBar = scrollPane.getVerticalScrollBar();
        this.hScrollBar = scrollPane.getHorizontalScrollBar();
        this.add((Component)buttonBar, "North");
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.status, "South");
        this.tileGrid.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImageViewer.this.display.setTileGridVisible(ImageViewer.this.tileGrid.isSelected());
                if (ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.display.setTileGridVisible(ImageViewer.this.tileGrid.isSelected());
                    ImageViewer.this.relatedViewer.tileGrid.setSelected(ImageViewer.this.tileGrid.isSelected());
                }
            }
        });
        this.roiSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.roiSync.setSelected(ImageViewer.this.roiSync.isSelected());
                }
            }
        });
        this.rescaleValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.setImage(ImageViewer.this.image);
            }
        });
        this.vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ImageViewer.this.roiSync.isSelected() && ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.vScrollBar.setValue(ImageViewer.this.vScrollBar.getValue());
                }
                if (ImageViewer.this.rescaleValues.isSelected()) {
                    ImageViewer.this.display.repaint();
                }
            }
        });
        this.hScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ImageViewer.this.roiSync.isSelected() && ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.hScrollBar.setValue(ImageViewer.this.hScrollBar.getValue());
                }
                if (ImageViewer.this.rescaleValues.isSelected()) {
                    ImageViewer.this.display.repaint();
                }
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return ".png and .tif/.tiff images";
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String name = file.getName().toLowerCase();
                        return name.endsWith(".png") || name.endsWith(".tif") || name.endsWith(".tiff");
                    }
                });
                int result = chooser.showSaveDialog(ImageViewer.this);
                if (result == 0) {
                    File selected = chooser.getSelectedFile();
                    String name = selected.getName().toLowerCase();
                    if (!(name.endsWith(".png") || name.endsWith(".tif") || name.endsWith(".tiff"))) {
                        selected = new File(selected.getParentFile(), selected.getName() + ".png");
                    }
                    ImageViewer.this.lastDirectory = selected.getParentFile();
                    try {
                        String format = "PNG";
                        if (name.endsWith(".tif") || name.endsWith(".tiff")) {
                            format = "TIF";
                        }
                        ImageIO.write(ImageViewer.this.image, format, selected);
                        ImageViewer.this.status.setText("File successfully saved");
                    }
                    catch (IOException e) {
                        ImageViewer.this.status.setText("Failed to save file: " + e.getMessage());
                    }
                }
            }
        });
        showChain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = "";
                if (ImageViewer.this.image instanceof RenderedOp) {
                    title = ((RenderedOp)ImageViewer.this.image).getOperationName();
                }
                JFrame frame = new JFrame(title);
                RenderedImageBrowser info = new RenderedImageBrowser(true, true);
                info.setImage(ImageViewer.this.image);
                ImageViewer viewer = info.imageInfo.viewer;
                frame.setContentPane(info);
                frame.setSize(1024, 768);
                frame.setVisible(true);
                double latestScale = ImageViewer.this.display.getScale();
                viewer.roiSync.setSelected(ImageViewer.this.roiSync.isSelected());
                viewer.tileGrid.setSelected(ImageViewer.this.tileGrid.isSelected());
                viewer.rescaleValues.setSelected(ImageViewer.this.rescaleValues.isSelected());
                viewer.display.setScale(latestScale);
                if (ImageViewer.this.relatedViewer != null) {
                    ImageViewer openingRelatedViewer = viewer.relatedViewer;
                    openingRelatedViewer.display.setScale(latestScale);
                    openingRelatedViewer.roiSync.setSelected(ImageViewer.this.roiSync.isSelected());
                    openingRelatedViewer.tileGrid.setSelected(ImageViewer.this.tileGrid.isSelected());
                }
                viewer.setImage(ImageViewer.this.image);
            }
        });
        showDump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = "";
                if (ImageViewer.this.image instanceof RenderedOp) {
                    title = ((RenderedOp)ImageViewer.this.image).getOperationName();
                }
                JFrame frame = new JFrame(title + " dump");
                frame.setLayout(new BorderLayout());
                final JCheckBox checkBox = new JCheckBox("Minimal");
                String chainDump = RenderedImageBrowser.dumpChain(ImageViewer.this.image);
                final JTextArea textArea = new JTextArea();
                textArea.setText(chainDump);
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean minimal = checkBox.isSelected();
                        String chainDump = RenderedImageBrowser.dumpChain(ImageViewer.this.image, minimal);
                        textArea.setText(chainDump);
                    }
                });
                checkBox.setSelected(false);
                textArea.setEditable(false);
                JScrollPane textScrollPane = new JScrollPane(textArea);
                frame.add((Component)checkBox, "First");
                frame.add((Component)textScrollPane, "Center");
                frame.setSize(1024, 768);
                frame.setVisible(true);
            }
        });
        this.display.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ImageViewer.this.pixelIter != null) {
                    int x = (int)Math.floor((double)e.getX() / ImageViewer.this.display.getScale());
                    int y = (int)Math.floor((double)e.getY() / ImageViewer.this.display.getScale());
                    ImageViewer.this.sb.setLength(0);
                    if (x < ImageViewer.this.image.getMinX() || x >= ImageViewer.this.image.getMinX() + ImageViewer.this.image.getWidth() || y < ImageViewer.this.image.getMinY() || y >= ImageViewer.this.image.getMinY() + ImageViewer.this.image.getHeight()) {
                        ImageViewer.this.sb.append("Outside of image bounds");
                    } else {
                        ImageViewer.this.sb.append("Value at ");
                        ImageViewer.this.sb.append(x).append(", ").append(y).append(": [");
                        int dataType = ImageViewer.this.image.getSampleModel().getDataType();
                        if (dataType == 5 || dataType == 4) {
                            ImageViewer.this.pixelIter.getPixel(x, y, ImageViewer.this.dpixel);
                            for (int i = 0; i < ImageViewer.this.dpixel.length; ++i) {
                                ImageViewer.this.sb.append(ImageViewer.this.dpixel[i]);
                                if (i >= ImageViewer.this.dpixel.length - 1) continue;
                                ImageViewer.this.sb.append(", ");
                            }
                        } else {
                            ImageViewer.this.pixelIter.getPixel(x, y, ImageViewer.this.ipixel);
                            for (int i = 0; i < ImageViewer.this.ipixel.length; ++i) {
                                ImageViewer.this.sb.append(ImageViewer.this.ipixel[i]);
                                if (i >= ImageViewer.this.ipixel.length - 1) continue;
                                ImageViewer.this.sb.append(", ");
                            }
                        }
                        ImageViewer.this.sb.append(']');
                    }
                    ImageViewer.this.status.setText(ImageViewer.this.sb.toString());
                }
            }
        });
    }

    private JButton createDecoratedButton(String alternativeText, String toolTipText, String iconResourceName) {
        JButton button = new JButton();
        BufferedImage icon = null;
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(iconResourceName);
            icon = ImageIO.read(inputStream);
            button.setIcon(new ImageIcon(icon));
            inputStream.close();
        }
        catch (IOException e) {
            button.setText(alternativeText);
        }
        button.setToolTipText(toolTipText);
        return button;
    }

    public void setImage(RenderedImage image) {
        this.image = image;
        this.display.setUseRescaled(this.rescaleValues.isSelected());
        if (image == null) {
            this.display.setVisible(false);
            this.pixelIter = null;
        } else {
            if (this.rescaleValues.isSelected()) {
                this.rescaleImage(image);
            } else {
                this.display.setImage(image);
            }
            this.display.setVisible(true);
            this.pixelIter = RandomIterFactory.create(image, null);
            this.ipixel = new int[image.getSampleModel().getNumBands()];
            this.dpixel = new double[image.getSampleModel().getNumBands()];
        }
    }

    private void rescaleImage(RenderedImage image) {
        int dataType = image.getSampleModel().getDataType();
        switch (dataType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.display.image = image;
                ImageLayout2 layout = new ImageLayout2();
                layout.setTileWidth(image.getTileWidth());
                layout.setTileHeight(image.getTileHeight());
                layout.setTileGridYOffset(image.getTileGridYOffset());
                layout.setTileGridXOffset(image.getTileGridXOffset());
                RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                Object noData = image.getProperty("GC_NODATA");
                ROI roi = null;
                if (noData != null && noData instanceof NoDataContainer) {
                    double nd = ((NoDataContainer)noData).getAsSingleValue();
                    RenderedImage roiSourceImage = image;
                    if (image.getSampleModel().getNumBands() > 1) {
                        roiSourceImage = BandSelectDescriptor.create(image, new int[]{0}, hints);
                    }
                    roi = new ROI(roiSourceImage, (int)(nd + 1.0));
                } else if (image.getWidth() * image.getHeight() < 0x400000) {
                    RenderedOp binarize = BinarizeDescriptor.create(image, Double.NEGATIVE_INFINITY, hints);
                    roi = new ROI(binarize, 1);
                }
                RenderedOp extremaImage = ExtremaDescriptor.create(image, roi, 1, 1, false, 1, hints);
                double[][] extrema = (double[][])extremaImage.getProperty("Extrema");
                RenderedOp histogramImage = HistogramDescriptor.create(image, roi, 1, 1, new int[]{256}, extrema[0], extrema[1], hints);
                Histogram hist = (Histogram)histogramImage.getProperty("Histogram");
                double[] mins = hist.getPTileThreshold(0.05);
                double[] maxs = hist.getPTileThreshold(0.95);
                int bands = mins.length;
                double[] scales = new double[bands];
                double[] offsets = new double[bands];
                double[] deltas = new double[bands];
                RenderedImage[] rescaled = new RenderedImage[bands];
                for (int i = 0; i < bands; ++i) {
                    deltas[i] = maxs[i] - mins[i];
                    scales[i] = 255.0 / deltas[i];
                    offsets[i] = -scales[i] * mins[i];
                }
                image = RescaleDescriptor.create(image, scales, offsets, hints);
                image = FormatDescriptor.create(image, 0, hints);
                this.display.setRescaledImage(image);
                break;
            }
            default: {
                this.display.setRescaledImage(null);
                this.display.setImage(image);
            }
        }
    }

    public ImageViewer getRelatedViewer() {
        return this.relatedViewer;
    }

    public void setRelatedViewer(ImageViewer relatedViewer) {
        this.relatedViewer = relatedViewer;
    }

    public void setStatusMessage(String message) {
        this.status.setText(message);
    }
}

