/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

public class AlgebraOpImage
extends PointOpImage {
    private static final Logger LOGGER = Logger.getLogger(AlgebraOpImage.class.toString());
    private final boolean hasNoData;
    private Range noData;
    private byte[] byteLookupTable;
    private boolean[] booleanLookupTable;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private AlgebraDescriptor.Operator op;
    private final int numSrc;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    private byte nullValueByte;
    private short nullValueShort;
    private int nullValueInt;
    private float nullValueFloat;
    private double nullValueDouble;
    private final int numTotalSrc;

    public AlgebraOpImage(Map config, ImageLayout layout, AlgebraDescriptor.Operator op, ROI srcROI, Range noData, double destinationNoData, RenderedImage ... sources) {
        super(AlgebraOpImage.vectorize(sources), layout, config, true);
        SampleModel sm;
        int numBandsDst;
        if (op == null) {
            throw new IllegalArgumentException("Operation Not Defined");
        }
        this.op = op;
        int numSrc = sources.length;
        if (!op.supportsMultipleValues() && numSrc > 1) {
            LOGGER.warning("Multiple sources found, only the first one will be used");
            numSrc = 1;
        }
        this.numSrc = numSrc;
        this.numTotalSrc = sources.length;
        int srcDataType = sources[0].getSampleModel().getDataType();
        int dataType = this.getSampleModel().getDataType();
        if (!op.isDataTypeSupported(srcDataType)) {
            throw new IllegalArgumentException("This operation does not support DataType: " + srcDataType);
        }
        int[] numBandsSrc = new int[numSrc];
        boolean srcBandsToFill = false;
        int numBands0 = sources[0].getSampleModel().getNumBands();
        for (int i = 1; i < numSrc; ++i) {
            numBandsSrc[i] = sources[i].getSampleModel().getNumBands();
            if (numBandsSrc[i] == numBands0) continue;
            srcBandsToFill = true;
            break;
        }
        if (layout != null && layout.isValid(256) && (numBandsDst = (sm = layout.getSampleModel(null)).getNumBands()) > 1 && srcBandsToFill) {
            int minBandsNum = Integer.MAX_VALUE;
            for (int i = 0; i < numSrc; ++i) {
                int bands = numBandsSrc[i];
                if (bands >= minBandsNum) continue;
                minBandsNum = bands;
            }
            if ((numBandsDst = Math.min(minBandsNum, numBandsDst)) != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel(sm, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), numBandsDst);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, config);
                }
            }
        }
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte(destinationNoData);
                this.nullValueByte = ImageUtil.clampRoundByte(op.getNullValue());
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort(destinationNoData);
                this.nullValueShort = ImageUtil.clampRoundUShort(op.getNullValue());
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort(destinationNoData);
                this.nullValueShort = ImageUtil.clampRoundShort(op.getNullValue());
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt(destinationNoData);
                this.nullValueInt = ImageUtil.clampRoundInt(op.getNullValue());
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat(destinationNoData);
                this.nullValueFloat = ImageUtil.clampFloat(op.getNullValue());
                break;
            }
            case 5: {
                this.destNoDataDouble = destinationNoData;
                this.nullValueDouble = op.getNullValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
            if (dataType == 0) {
                this.booleanLookupTable = new boolean[256];
                this.byteLookupTable = new byte[256];
                for (int i = 0; i < this.byteLookupTable.length; ++i) {
                    this.booleanLookupTable[i] = !noData.contains(i);
                    this.byteLookupTable[i] = this.booleanLookupTable[i] ? (byte)i : this.nullValueByte;
                }
            }
        } else {
            this.hasNoData = false;
        }
        if (srcROI != null) {
            this.hasROI = true;
            this.roi = srcROI;
        } else {
            this.hasROI = false;
            this.roi = null;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        this.permitInPlaceOperation();
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        if (!this.hasROI || this.hasROI && this.roi.intersects(destRect)) {
            RasterFormatTag[] formatTags = this.getFormatTags();
            RasterAccessor[] rasterArray = new RasterAccessor[this.numSrc];
            for (int i = 0; i < this.numSrc; ++i) {
                rasterArray[i] = new RasterAccessor(sources[i], destRect, formatTags[i], this.getSourceImage(i).getColorModel());
            }
            RasterAccessor d = new RasterAccessor(dest, destRect, formatTags[this.numTotalSrc], this.getColorModel());
            switch (d.getDataType()) {
                case 0: {
                    this.computeRectByte(rasterArray, d);
                    break;
                }
                case 1: {
                    this.computeRectUShort(rasterArray, d);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterArray, d);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterArray, d);
                    break;
                }
                case 4: {
                    this.computeRectFloat(rasterArray, d);
                    break;
                }
                case 5: {
                    this.computeRectDouble(rasterArray, d);
                }
            }
            if (d.needsClamping()) {
                d.clampDataArrays();
            }
            d.copyDataToRaster();
        } else {
            int numBands = dest.getNumBands();
            int destDataType = dest.getSampleModel().getDataType();
            double[] destNoData = new double[numBands];
            block16: for (int i = 0; i < numBands; ++i) {
                switch (destDataType) {
                    case 0: {
                        destNoData[i] = this.destNoDataByte;
                        continue block16;
                    }
                    case 1: 
                    case 2: {
                        destNoData[i] = this.destNoDataShort;
                        continue block16;
                    }
                    case 3: {
                        destNoData[i] = this.destNoDataInt;
                        continue block16;
                    }
                    case 4: {
                        destNoData[i] = this.destNoDataFloat;
                        continue block16;
                    }
                    case 5: {
                        destNoData[i] = this.destNoDataDouble;
                    }
                }
            }
            ImageUtil.fillBackground(dest, destRect, destNoData);
        }
    }

    private void computeRectByte(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        int result = 0;
        int inputData = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        byte[][] srcData = new byte[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        if (this.caseA) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                byte[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]) & 0xFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]] & 0xFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                byte[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            d[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]) & 0xFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]] & 0xFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            int sourceValue = 0;
            boolean isValidData = false;
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                byte[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]] & 0xFF;
                        if (isValidData |= this.booleanLookupTable[sourceValue]) {
                            result = this.op.calculate(sourceValue) & 0xFF;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]] & 0xFF;
                            boolean validPixel = this.booleanLookupTable[sourceValue];
                            inputData = this.byteLookupTable[sourceValue] & 0xFF;
                            result = this.updateResultInteger(validPixel, inputData, isValidData, result);
                            isValidData |= validPixel;
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            int sourceValue = 0;
            boolean isValidData = false;
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                byte[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]] & 0xFF;
                        if (isValidData |= this.booleanLookupTable[sourceValue]) {
                            result = this.op.calculate(sourceValue) & 0xFF;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]] & 0xFF;
                            boolean validPixel = this.booleanLookupTable[sourceValue];
                            inputData = this.byteLookupTable[sourceValue] & 0xFF;
                            result = this.updateResultInteger(validPixel, inputData, isValidData, result);
                            isValidData |= validPixel;
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private int updateResultInteger(boolean validValue, int value, boolean validResult, int result) {
        if (validValue) {
            result = !validResult ? this.op.calculate(value) & 0xFF : this.op.calculate(result, value);
        }
        return result;
    }

    private long updateResultLong(boolean validValue, long value, boolean validResult, long result) {
        if (validValue) {
            result = !validResult ? this.op.calculateL(value) : this.op.calculateL(result, value);
        }
        return result;
    }

    private float updateResultFloat(boolean validValue, float value, boolean validResult, float result) {
        if (validValue) {
            result = !validResult ? this.op.calculate(value) : this.op.calculate(result, value);
        }
        return result;
    }

    private double updateResultDouble(boolean validValue, double value, boolean validResult, double result) {
        if (validValue) {
            result = !validResult ? this.op.calculate(value) : this.op.calculate(result, value);
        }
        return result;
    }

    private void computeRectUShort(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        int result = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        short[][] srcData = new short[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        short sourceValue = 0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]] & 0xFFFF);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]] & 0xFFFF);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                            isValidData = true;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultInteger(true, sourceValue & 0xFFFF, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultInteger(true, sourceValue & 0xFFFF, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        int result = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        short[][] srcData = new short[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        short sourceValue = 0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(false, srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(false, srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(false, sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultInteger(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                short[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(false, sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultInteger(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        long result = 0L;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int[][] srcData = new int[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        int sourceValue = 0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                int[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculateL(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                int[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            d[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculateL(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                int[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultLong(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                int[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueInt;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultLong(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        float result = 0.0f;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        float[][] srcData = new float[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        float sourceValue = 0.0f;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                float[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                float[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            d[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                float[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultFloat(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                float[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultFloat(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        double result = 0.0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        double[][] srcData = new double[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        double sourceValue = 0.0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                double[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                double[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            d[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            result = this.op.calculate(result, srcData[i][srcPixelOffset[i]]);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                double[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueDouble;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultDouble(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b);
                    srcLineOffset[i] = srcBandOffsets[i][b];
                }
                double[] d = dData[b];
                int dLineOffset = dBandOffsets[b];
                for (int h = 0; h < dheight; ++h) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueDouble;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                result = this.updateResultDouble(true, sourceValue, isValidData, result);
                                isValidData = true;
                            }
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private static Vector<RenderedImage> vectorize(RenderedImage[] sources) {
        Vector<RenderedImage> vec = new Vector<RenderedImage>(sources.length);
        for (RenderedImage image : sources) {
            if (image == null) continue;
            vec.add(image);
        }
        if (vec.isEmpty()) {
            return null;
        }
        return vec;
    }
}

