/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.terracer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBox;
import org.openstreetmap.josm.plugins.terracer.HouseNumberInputDialog;
import org.openstreetmap.josm.plugins.terracer.TerracerAction;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class HouseNumberInputHandler
extends JosmAction
implements FocusListener,
ItemListener {
    private final TerracerAction terracerAction;
    private final Way outline;
    private final Way street;
    private final String streetName;
    private final Node init;
    private final Relation associatedStreet;
    private final List<Node> housenumbers;
    HouseNumberInputDialog dialog;

    public HouseNumberInputHandler(TerracerAction terracerAction, Way outline, Node init, Way street, String streetName, String buildingType, Relation associatedStreet, List<Node> housenumbers, String title) {
        this.terracerAction = terracerAction;
        this.outline = outline;
        this.init = init;
        this.street = street;
        this.streetName = streetName;
        this.associatedStreet = associatedStreet;
        this.housenumbers = housenumbers;
        this.dialog = new HouseNumberInputDialog(this, street, streetName, buildingType, associatedStreet != null, housenumbers);
    }

    private static JButton getButton(Container root, String caption) {
        Component[] children;
        for (Component child : children = root.getComponents()) {
            JButton b;
            if (!(child instanceof JButton ? caption.equals((b = (JButton)child).getText()) : child instanceof Container && (b = HouseNumberInputHandler.getButton((Container)child, caption)) != null)) continue;
            return b;
        }
        return null;
    }

    private boolean validateInput() {
        boolean isOk = true;
        StringBuilder message = new StringBuilder();
        isOk &= this.checkNumberOrder(message);
        isOk &= this.checkSegmentsFromHousenumber(message);
        isOk &= this.checkSegments(message);
        if (this.dialog.hi.getText().length() > 0 && (this.segments() != null || this.segments() < 1)) {
            isOk &= HouseNumberInputHandler.checkNumberStringField(this.dialog.lo, I18n.tr((String)"Lowest number", (Object[])new Object[0]), message);
        }
        isOk &= HouseNumberInputHandler.checkNumberStringField(this.dialog.hi, I18n.tr((String)"Highest number", (Object[])new Object[0]), message);
        isOk &= HouseNumberInputHandler.checkNumberStringField(this.dialog.segments, I18n.tr((String)"Segments", (Object[])new Object[0]), message);
        JButton okButton = HouseNumberInputHandler.getButton((Container)((Object)this.dialog), "OK");
        if (okButton != null) {
            okButton.setEnabled(isOk);
        }
        if (isOk) {
            this.dialog.messageLabel.setForeground(Color.black);
            this.dialog.messageLabel.setText(I18n.tr((String)HouseNumberInputDialog.DEFAULT_MESSAGE, (Object[])new Object[0]));
            return true;
        }
        this.dialog.messageLabel.setForeground(Color.red);
        this.dialog.messageLabel.setText(message.toString());
        return false;
    }

    private boolean checkNumberOrder(StringBuilder message) {
        if (this.numberFrom() != null && this.numberTo() != null && this.numberFrom() > this.numberTo()) {
            HouseNumberInputHandler.appendMessageNewLine(message);
            message.append(I18n.tr((String)"Lowest housenumber cannot be higher than highest housenumber", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSegmentsFromHousenumber(StringBuilder message) {
        if (!this.dialog.numbers.isVisible()) {
            this.dialog.segments.setEditable(true);
            if (this.numberFrom() != null && this.numberTo() != null) {
                int segments = this.numberTo() - this.numberFrom();
                if (segments % this.stepSize() != 0) {
                    HouseNumberInputHandler.appendMessageNewLine(message);
                    message.append(I18n.tr((String)"Housenumbers do not match odd/even setting", (Object[])new Object[0]));
                    return false;
                }
                int steps = segments / this.stepSize();
                this.dialog.segments.setText(String.valueOf(++steps));
                this.dialog.segments.setEditable(false);
            }
        }
        return true;
    }

    private boolean checkSegments(StringBuilder message) {
        if (this.segments() == null || this.segments() < 1) {
            HouseNumberInputHandler.appendMessageNewLine(message);
            message.append(I18n.tr((String)"Segment must be a number greater 1", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean checkNumberStringField(JTextField field, String label, StringBuilder message) {
        String content = field.getText();
        if (content != null && content.length() != 0) {
            try {
                int i = Integer.parseInt(content);
                if (i < 0) {
                    HouseNumberInputHandler.appendMessageNewLine(message);
                    message.append(I18n.tr((String)"{0} must be greater than 0", (Object[])new Object[]{label}));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                HouseNumberInputHandler.appendMessageNewLine(message);
                message.append(I18n.tr((String)"{0} is not a number", (Object[])new Object[]{label}));
                return false;
            }
        }
        return true;
    }

    private static void appendMessageNewLine(StringBuilder message) {
        if (message.length() > 0) {
            message.append("\n");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.validateInput();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (I18n.tr((String)"OK", (Object[])new Object[0]).equals(button.getActionCommand()) && button.isEnabled()) {
                if (this.validateInput()) {
                    this.saveValues();
                    this.terracerAction.terraceBuilding(this.outline, this.init, this.street, this.associatedStreet, this.segments(), this.dialog.lo.getText(), this.dialog.hi.getText(), this.stepSize(), this.housenumbers, this.streetName(), this.doHandleRelation(), this.doKeepOutline(), this.buildingType());
                    this.dialog.setVisible(false);
                }
            } else if (I18n.tr((String)"Cancel", (Object[])new Object[0]).equals(button.getActionCommand())) {
                this.dialog.setVisible(false);
            }
        } else {
            this.validateInput();
        }
    }

    public Integer stepSize() {
        return I18n.tr((String)"All", (Object[])new Object[0]).equals(this.dialog.interpolationType.getSelectedItem()) ? 1 : 2;
    }

    public Integer segments() {
        try {
            return Integer.parseInt(this.dialog.segments.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Integer numberFrom() {
        try {
            return Integer.parseInt(this.dialog.lo.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Integer numberTo() {
        try {
            return Integer.parseInt(this.dialog.hi.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String streetName() {
        if (this.streetName != null) {
            return this.streetName;
        }
        return HouseNumberInputHandler.getItemText(this.dialog.streetComboBox);
    }

    public String buildingType() {
        return HouseNumberInputHandler.getItemText(this.dialog.buildingComboBox);
    }

    private static String getItemText(AutoCompComboBox<?> box) {
        Object selected = box.getSelectedItem();
        if (selected == null) {
            return null;
        }
        String name = selected instanceof AutoCompletionItem ? ((AutoCompletionItem)selected).getValue() : selected.toString();
        return Utils.isEmpty((String)name) ? null : name;
    }

    public boolean doHandleRelation() {
        return this.dialog.handleRelationCheckBox.isSelected();
    }

    public boolean doKeepOutline() {
        return this.dialog.keepOutlineCheckBox.isSelected();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getOppositeComponent() == null) {
            return;
        }
        this.validateInput();
    }

    public void saveValues() {
        Config.getPref().putBoolean("plugins.terracer.handle_relation", this.doHandleRelation());
        Config.getPref().putBoolean("plugins.terracer.keep_outline", this.doKeepOutline());
        Config.getPref().put("plugins.terracer.interpolation", this.stepSize().toString());
    }
}

