/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.spi.preferences.Config;

class DrawPoint
extends JPanel {
    public double threshold = Config.getPref().getDouble("livegps.offset_threshold", 0.3);
    int x_p = 0;
    int w = this.getWidth();
    int h = this.getHeight();

    DrawPoint() {
    }

    public void draw_point(double x, Graphics2D g2, Area circleArea1, Area circleArea2, Area circleArea3, JLabel label, double x_start, double y_start, double width) {
        if (x < -this.threshold) {
            this.x_p = (int)(x_start + width * 0.4 + x * (width / 100.0) - width * 0.15 / 2.0);
            if ((double)this.x_p < x_start) {
                this.x_p = (int)x_start;
            }
        } else if (x > this.threshold) {
            this.x_p = (int)(x_start + x * (width / 100.0) + width * 0.6 - width * 0.15 / 2.0);
            if ((double)this.x_p > x_start + width) {
                this.x_p = (int)(x_start + width);
            }
        } else if (x >= -this.threshold && x <= this.threshold) {
            this.x_p = (int)(x_start + width / 2.0 - width * 0.15 / 2.0);
        }
        this.fill(x, this.x_p, g2, circleArea1, circleArea2, circleArea3, label, x_start, y_start, width);
        g2.setColor(Color.black);
        g2.fillOval(this.x_p, (int)(y_start + width / 2.0 - width * 0.15 / 2.0), (int)(width * 0.15), (int)(width * 0.15));
    }

    public void fill(double x, int x_p, Graphics2D g2, Area circleArea1, Area circleArea2, Area circleArea3, JLabel label, double x_start, double y_start, double width) {
        Color yellow = new Color(255, 210, 50, 255);
        Color green = new Color(30, 200, 50, 255);
        double y = (double)Math.round(x * 100.0) / 100.0;
        if (x < 0.0 && -x > this.threshold) {
            g2.setColor(yellow);
            g2.fill(circleArea1);
            if (width / 3.0 < 60.0) {
                label.setBounds((int)(x_start - 60.0), (int)(y_start + width * 0.3), 60, 10);
            } else {
                label.setBounds((int)(x_start + width * 0.1), (int)(y_start + width * 0.3), (int)(width / 3.0), (int)(width / 15.0));
            }
            label.setText(y + " m");
        } else if (-x <= this.threshold && x <= 0.0 || x <= this.threshold && x >= 0.0) {
            g2.setColor(green);
            g2.fill(circleArea2);
            label.setText("");
        } else if (x > 0.0 && x > this.threshold) {
            g2.setColor(yellow);
            g2.fill(circleArea3);
            if (width / 3.0 < 60.0) {
                label.setBounds((int)(x_start + width * 1.1), (int)(y_start + width * 0.3), 60, 10);
            } else {
                label.setBounds((int)(x_start + width * 0.7), (int)(y_start + width * 0.3), (int)(width / 3.0), (int)(width / 15.0));
            }
            label.setText("+" + y + " m");
        }
    }
}

