/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.actions.downloadtask;

import java.util.Optional;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsLayer;
import org.openstreetmap.josm.plugins.imageryxmlbounds.io.JosmServerLocationReader;
import org.openstreetmap.josm.tools.I18n;

public class DownloadXmlBoundsTask
extends DownloadOsmTask
implements XmlBoundsConstants {
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new InternalDownloadTask(settings, new JosmServerLocationReader(url), progressMonitor);
        return MainApplication.worker.submit((Runnable)this.downloadTask);
    }

    public String[] getPatterns() {
        return new String[]{"https?://josm.openstreetmap.de/maps".replace(".", "\\."), "http://.*\\." + "imagery.xml".replace(".", "\\.")};
    }

    public String getTitle() {
        return I18n.tr((String)"Download imagery XML bounds", (Object[])new Object[0]);
    }

    protected class InternalDownloadTask
    extends DownloadOsmTask.DownloadTask {
        public InternalDownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super((DownloadOsmTask)DownloadXmlBoundsTask.this, settings, reader, progressMonitor);
        }

        protected OsmDataLayer getEditLayer() {
            OsmDataLayer editLayer = super.getEditLayer();
            return editLayer instanceof XmlBoundsLayer ? editLayer : null;
        }

        protected long getNumModifiableDataLayers() {
            long count = 0L;
            if (!MainApplication.isDisplayingMapView()) {
                return 0L;
            }
            for (Layer layer : MainApplication.getLayerManager().getLayers()) {
                if (!(layer instanceof XmlBoundsLayer)) continue;
                ++count;
            }
            return count;
        }

        protected OsmDataLayer getFirstModifiableDataLayer() {
            if (!MainApplication.isDisplayingMapView()) {
                return null;
            }
            for (Layer layer : MainApplication.getLayerManager().getLayers()) {
                if (!(layer instanceof XmlBoundsLayer)) continue;
                return (XmlBoundsLayer)layer;
            }
            return null;
        }

        protected OsmDataLayer createNewLayer(DataSet ds, Optional<String> layerName) {
            return new XmlBoundsLayer(ds, layerName.orElseGet(() -> this.generateLayerName()), null);
        }
    }
}

