/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.InterlaceMethod;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public class PngChunkIhdr
extends PngChunk {
    private final int width;
    private final int height;
    private final int bitDepth;
    private final PngColorType pngColorType;
    private final int compressionMethod;
    private final int filterMethod;
    private final InterlaceMethod interlaceMethod;

    public PngChunkIhdr(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.width = BinaryFunctions.read4Bytes("Width", is, "Not a Valid PNG File: IHDR Corrupt", this.getByteOrder());
        this.height = BinaryFunctions.read4Bytes("Height", is, "Not a Valid PNG File: IHDR Corrupt", this.getByteOrder());
        this.bitDepth = BinaryFunctions.readByte("BitDepth", is, "Not a Valid PNG File: IHDR Corrupt");
        byte type = BinaryFunctions.readByte("ColorType", is, "Not a Valid PNG File: IHDR Corrupt");
        this.pngColorType = PngColorType.getColorType(type);
        if (this.getPngColorType() == null) {
            throw new ImagingException("PNG: unknown color type: " + type);
        }
        this.compressionMethod = BinaryFunctions.readByte("CompressionMethod", is, "Not a Valid PNG File: IHDR Corrupt");
        this.filterMethod = BinaryFunctions.readByte("FilterMethod", is, "Not a Valid PNG File: IHDR Corrupt");
        byte method = BinaryFunctions.readByte("InterlaceMethod", is, "Not a Valid PNG File: IHDR Corrupt");
        if (method < 0 || method >= InterlaceMethod.values().length) {
            throw new ImagingException("PNG: unknown interlace method: " + method);
        }
        this.interlaceMethod = InterlaceMethod.values()[method];
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public int getFilterMethod() {
        return this.filterMethod;
    }

    public int getHeight() {
        return this.height;
    }

    public InterlaceMethod getInterlaceMethod() {
        return this.interlaceMethod;
    }

    public PngColorType getPngColorType() {
        return this.pngColorType;
    }

    public int getWidth() {
        return this.width;
    }
}

