/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class TagSourceAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Add Source Tag", (Object[])new Object[0]);
    private String source;
    private List<OsmPrimitive> selectionBuf = new ArrayList<OsmPrimitive>();

    public TagSourceAction() {
        super(TITLE, "dumbutils/sourcetag", I18n.tr((String)"Add remembered source tag", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:sourcetag", (String)I18n.tr((String)"More tools: {0}", (Object[])new Object[]{I18n.tr((String)"Add Source Tag", (Object[])new Object[0])}), (int)0, (int)5000), true, false);
        this.source = Config.getPref().get("sourcetag.value");
        this.installAdapters();
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        if (selection.isEmpty() || this.source == null || this.source.length() == 0) {
            return;
        }
        UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand(selection, "source", this.source));
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
            this.selectionBuf = new ArrayList<OsmPrimitive>();
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (!this.selectionBuf.isEmpty()) {
            String newSource = null;
            for (OsmPrimitive p : this.selectionBuf) {
                String s = p.get("source");
                if (s == null) continue;
                if (newSource == null) {
                    newSource = s;
                    continue;
                }
                if (newSource.equals(s)) continue;
                newSource = null;
                break;
            }
            if (newSource != null && !newSource.isEmpty()) {
                this.source = newSource;
                Config.getPref().put("sourcetag.value", this.source);
            }
        }
        this.selectionBuf = new ArrayList<OsmPrimitive>(selection);
        this.setEnabled(!selection.isEmpty() && this.source != null && !this.source.isEmpty());
    }
}

