/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExceptValueModel {
    public static final Set<String> STANDARD_VEHICLE_EXCEPTION_VALUES;
    private String value = "";
    private boolean isStandard = true;
    private final Set<String> vehicleExceptions = new HashSet<String>();

    public static boolean isStandardVehicleExceptionValue(String v) {
        if (v == null) {
            return false;
        }
        v = v.trim().toLowerCase();
        return STANDARD_VEHICLE_EXCEPTION_VALUES.contains(v);
    }

    protected void parseValue(String value) {
        String[] values;
        if (value == null || value.trim().equals("")) {
            value = "";
        }
        this.value = value;
        this.isStandard = true;
        this.vehicleExceptions.clear();
        if (value.equals("")) {
            return;
        }
        for (String v : values = value.split(";")) {
            if (ExceptValueModel.isStandardVehicleExceptionValue(v = v.trim().toLowerCase())) {
                this.vehicleExceptions.add(v);
                continue;
            }
            this.isStandard = false;
        }
    }

    public ExceptValueModel() {
    }

    public ExceptValueModel(String value) {
        if (value == null || value.trim().equals("")) {
            return;
        }
        this.parseValue(value);
    }

    public String getValue() {
        if (this.isStandard) {
            StringBuffer sb = new StringBuffer();
            ArrayList<String> values = new ArrayList<String>(this.vehicleExceptions);
            Collections.sort(values);
            for (String v : values) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(v);
            }
            return sb.toString();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.parseValue(value);
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public void setStandard(boolean isStandard) {
        this.isStandard = isStandard;
    }

    public boolean isVehicleException(String vehicleType) throws IllegalArgumentException {
        if (vehicleType == null) {
            return false;
        }
        if (!ExceptValueModel.isStandardVehicleExceptionValue(vehicleType)) {
            throw new IllegalArgumentException(MessageFormat.format("vehicleType ''{0}'' isn''t a valid standard vehicle type", vehicleType));
        }
        vehicleType = vehicleType.trim().toLowerCase();
        return this.vehicleExceptions.contains(vehicleType);
    }

    public void setVehicleException(String vehicleType) throws IllegalArgumentException {
        if (!ExceptValueModel.isStandardVehicleExceptionValue(vehicleType)) {
            throw new IllegalArgumentException(MessageFormat.format("vehicleType ''{0}'' isn''t a valid standard vehicle type", vehicleType));
        }
        this.vehicleExceptions.add(vehicleType.trim().toLowerCase());
    }

    public void setVehicleException(String vehicleType, boolean setOrRemove) throws IllegalArgumentException {
        if (setOrRemove) {
            this.setVehicleException(vehicleType);
        } else {
            this.removeVehicleException(vehicleType);
        }
    }

    public void removeVehicleException(String vehicleType) throws IllegalArgumentException {
        if (!ExceptValueModel.isStandardVehicleExceptionValue(vehicleType)) {
            throw new IllegalArgumentException(MessageFormat.format("vehicleType ''{0}'' isn''t a valid standard vehicle type", vehicleType));
        }
        this.vehicleExceptions.remove(vehicleType.trim().toLowerCase());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getValue().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExceptValueModel)) {
            return false;
        }
        ExceptValueModel other = (ExceptValueModel)obj;
        return this.getValue().equals(other.getValue());
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("psv");
        s.add("hgv");
        s.add("bicycle");
        s.add("moped");
        s.add("motorcar");
        STANDARD_VEHICLE_EXCEPTION_VALUES = Collections.unmodifiableSet(s);
    }
}

