/*
 * Decompiled with CFR 0.152.
 */
package test.jts.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBHexFileReader;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;

public class IOUtil {
    public static WKTReader reader = new WKTReader();

    public static Geometry read(String wkt) {
        WKTReader rdr = new WKTReader();
        try {
            return rdr.read(wkt);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<Geometry> readWKT(String[] inputWKT) throws ParseException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < inputWKT.length; ++i) {
            geometries.add(reader.read(inputWKT[i]));
        }
        return geometries;
    }

    public static Geometry readWKT(String inputWKT) throws ParseException {
        return reader.read(inputWKT);
    }

    public static List<Geometry> readWKTFile(String filename) throws IOException, ParseException {
        WKTFileReader fileRdr = new WKTFileReader(filename, reader);
        List geoms = fileRdr.read();
        return geoms;
    }

    public static List<Geometry> readWKTFile(Reader rdr) throws IOException, ParseException {
        WKTFileReader fileRdr = new WKTFileReader(rdr, reader);
        List geoms = fileRdr.read();
        return geoms;
    }

    public static List<Geometry> readWKBHexFile(String filename) throws ParseException, IOException {
        WKBReader reader = new WKBReader();
        WKBHexFileReader fileReader = new WKBHexFileReader(filename, reader);
        return fileReader.read();
    }

    public static List<Geometry> readFile(String filename) throws Exception {
        if (filename.endsWith(".wkb")) {
            return IOUtil.readWKBHexFile(filename);
        }
        return IOUtil.readWKTFile(filename);
    }
}

