/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.valid;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.operation.valid.Comb;
import test.jts.perf.operation.valid.StarCross;

public class ValidStressTest {
    public static int SIZE = 10000;
    static GeometryFactory geomFact = new GeometryFactory();

    public static void main(String[] args) {
        new ValidStressTest().runComb();
        new ValidStressTest().runStarCrossPoly();
        new ValidStressTest().runStarCrossRing();
    }

    public void runComb() {
        int size = 400;
        Envelope env = new Envelope(0.0, 100.0, 0.0, 100.0);
        MultiPolygon geom = Comb.crossedComb(env, size, geomFact);
        System.out.println(geom);
        this.checkValid("Crossed combs (size = " + size + " )", geom);
    }

    public void runStarCrossPoly() {
        int size = 1000;
        Envelope env = new Envelope(0.0, 100.0, 0.0, 100.0);
        Polygon geom = StarCross.star(env, size, geomFact);
        this.checkValid("StarCross " + geom.getGeometryType() + "   (size = " + size + " )", geom);
    }

    public void runStarCrossRing() {
        int size = 1000;
        Envelope env = new Envelope(0.0, 100.0, 0.0, 100.0);
        Polygon poly = StarCross.star(env, size, geomFact);
        Geometry geom = poly.getBoundary();
        this.checkValid("StarCross " + geom.getGeometryType() + "   (size = " + size + " )", geom);
    }

    public void checkValid(String name, Geometry g) {
        System.out.println("Running " + name);
        Stopwatch sw = new Stopwatch();
        boolean isValid = g.isValid();
        System.out.println("Is Valid = " + isValid + "           Time: " + sw.getTimeString());
    }
}

