/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlayng;

import java.util.ArrayList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.shape.random.RandomPointsBuilder;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;

public class RandomPolygonBuilder {
    private Envelope extent = new Envelope(0.0, 100.0, 0.0, 100.0);
    private GeometryFactory geomFact = new GeometryFactory();
    private int npts;
    private Geometry voronoi;

    public static Geometry build(int npts) {
        RandomPolygonBuilder builder = new RandomPolygonBuilder(npts);
        return builder.createPolygon();
    }

    public RandomPolygonBuilder(int npts) {
        this.npts = npts;
        Geometry sites = this.randomPoints(this.extent, npts);
        this.voronoi = this.voronoiDiagram(sites, this.extent);
    }

    public Geometry createPolygon() {
        Geometry cellsSelect = this.select(this.voronoi, this.npts / 2);
        Geometry poly = cellsSelect.union();
        return poly;
    }

    private Geometry select(Geometry geoms, int n) {
        ArrayList<Geometry> selection = new ArrayList<Geometry>();
        for (int i = 0; i < geoms.getNumGeometries(); ++i) {
            selection.add(geoms.getGeometryN(i));
        }
        while (selection.size() > n) {
            int index = (int)((double)selection.size() * Math.random());
            selection.remove(index);
        }
        return this.geomFact.buildGeometry(selection);
    }

    public Geometry randomPoints(Envelope extent, int nPts) {
        RandomPointsBuilder shapeBuilder = new RandomPointsBuilder(this.geomFact);
        shapeBuilder.setExtent(extent);
        shapeBuilder.setNumPoints(nPts);
        return shapeBuilder.getGeometry();
    }

    public Geometry voronoiDiagram(Geometry sitesGeom, Envelope extent) {
        VoronoiDiagramBuilder builder = new VoronoiDiagramBuilder();
        builder.setSites(sitesGeom);
        builder.setClipEnvelope(extent);
        builder.setTolerance(1.0E-4);
        Geometry diagram = builder.getDiagram(sitesGeom.getFactory());
        return diagram;
    }
}

