/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.buffer.validate.BufferResultValidator;
import org.locationtech.jts.util.Stopwatch;

public class FileBufferResultValidatorTest
extends TestCase {
    static int MAX_FEATURE = 1;
    WKTReader rdr = new WKTReader();

    public FileBufferResultValidatorTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(FileBufferResultValidatorTest.class);
    }

    public void testAfrica() throws Exception {
        this.runTest("/testdata/africa.wkt");
    }

    void runTest(String resource) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        this.runTest(new WKTFileReader(new InputStreamReader(is), this.rdr));
    }

    void runTest(WKTFileReader fileRdr) throws Exception {
        List polys = fileRdr.read();
        this.runAll(polys, 0.01);
        this.runAll(polys, 0.1);
        this.runAll(polys, 1.0);
        this.runAll(polys, 10.0);
        this.runAll(polys, 100.0);
        this.runAll(polys, 1000.0);
    }

    void runAll(List geoms, double dist) {
        Stopwatch sw = new Stopwatch();
        int count = 0;
        for (Geometry g : geoms) {
            this.runBuffer(g, dist);
            this.runBuffer(g.reverse(), dist);
            if (++count <= MAX_FEATURE) continue;
            return;
        }
    }

    void runBuffer(Geometry g, double dist) {
        Geometry buf = g.buffer(dist);
        BufferResultValidator validator = new BufferResultValidator(g, dist, buf);
        if (!validator.isValid()) {
            String msg = validator.getErrorMessage();
            System.out.println(msg);
            System.out.println(WKTWriter.toPoint(validator.getErrorLocation()));
            System.out.println(g);
        }
        FileBufferResultValidatorTest.assertTrue((boolean)validator.isValid());
    }
}

