/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.LineSegment;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class LineSegmentHashCodePerfTest
extends PerformanceTestCase {
    private static final int NUM_ITER = 1;
    private List<LineSegment> grid;

    public static void main(String[] args) {
        PerformanceTestRunner.run(LineSegmentHashCodePerfTest.class);
    }

    public LineSegmentHashCodePerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{50, 100, 200, 400});
    }

    @Override
    public void startRun(int size) {
        System.out.println("\nRunning with grid size " + size);
        this.grid = this.createGrid(size);
    }

    public void runLineCount() {
        double total = 0.0;
        for (int i = 0; i < 1; ++i) {
            total += this.sumSegmentWeights(this.grid);
        }
    }

    private double sumSegmentWeights(List<LineSegment> lines) {
        HashMap<LineSegment, Double> weights = new HashMap<LineSegment, Double>();
        double total = 0.0;
        for (LineSegment line : lines) {
            weights.put(line, Math.random());
            System.out.format("%s - Hash code: %d   original:  %d\n", line, line.hashCode(), LineSegmentHashCodePerfTest.hashCodeOriginal(line));
        }
        for (LineSegment line : lines) {
            total += ((Double)weights.get(line)).doubleValue();
        }
        return total;
    }

    List<LineSegment> createGrid(int gridSize) {
        ArrayList<LineSegment> grid = new ArrayList<LineSegment>();
        for (int gx = 0; gx < gridSize * 10; gx += 10) {
            for (int gy = 0; gy < gridSize * 10; gy += 10) {
                grid.add(new LineSegment(gx, gy, gx + 10, gy));
                grid.add(new LineSegment(gx, gy, gx, gy + 10));
            }
        }
        return grid;
    }

    public static int hashCodeOriginal(LineSegment ls) {
        long bits0 = Double.doubleToLongBits(ls.p0.x);
        int hash0 = (int)(bits0 ^= Double.doubleToLongBits(ls.p0.y) * 31L) ^ (int)(bits0 >> 32);
        long bits1 = Double.doubleToLongBits(ls.p1.x);
        int hash1 = (int)(bits1 ^= Double.doubleToLongBits(ls.p1.y) * 31L) ^ (int)(bits1 >> 32);
        return hash0 ^ hash1;
    }
}

