/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

class SimpleRectangleIntersector {
    private LineIntersector li = new RobustLineIntersector();
    private Envelope rectEnv;
    private Coordinate[] corner = new Coordinate[4];

    public SimpleRectangleIntersector(Envelope rectEnv) {
        this.rectEnv = rectEnv;
        this.initCorners(rectEnv);
    }

    private void initCorners(Envelope rectEnv) {
        this.corner[0] = new Coordinate(rectEnv.getMaxX(), rectEnv.getMaxY());
        this.corner[1] = new Coordinate(rectEnv.getMinX(), rectEnv.getMaxY());
        this.corner[2] = new Coordinate(rectEnv.getMinX(), rectEnv.getMinY());
        this.corner[3] = new Coordinate(rectEnv.getMaxX(), rectEnv.getMinY());
    }

    public boolean intersects(Coordinate p0, Coordinate p1) {
        Envelope segEnv = new Envelope(p0, p1);
        if (!this.rectEnv.intersects(segEnv)) {
            return false;
        }
        this.li.computeIntersection(p0, p1, this.corner[0], this.corner[1]);
        if (this.li.hasIntersection()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[1], this.corner[2]);
        if (this.li.hasIntersection()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[2], this.corner[3]);
        if (this.li.hasIntersection()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[3], this.corner[0]);
        return this.li.hasIntersection();
    }
}

