/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import java.util.Date;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.NonRobustLineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;

public class LineIntersectorBenchmark
implements Runnable {
    public static void main(String[] args) {
        LineIntersectorBenchmark lineIntersectorBenchmark = new LineIntersectorBenchmark();
        lineIntersectorBenchmark.run();
    }

    @Override
    public void run() {
        this.exercise(new NonRobustLineIntersector());
        this.exercise(new RobustLineIntersector());
    }

    private void exercise(LineIntersector lineIntersector) {
        System.out.println(lineIntersector.getClass().getName());
        Date start = new Date();
        for (int i = 0; i < 1000000; ++i) {
            this.exerciseOnce(lineIntersector);
        }
        Date end = new Date();
        System.out.println("Milliseconds elapsed: " + (end.getTime() - start.getTime()));
        System.out.println();
    }

    private void exerciseOnce(LineIntersector lineIntersector) {
        Coordinate p1 = new Coordinate(10.0, 10.0);
        Coordinate p2 = new Coordinate(20.0, 20.0);
        Coordinate q1 = new Coordinate(20.0, 10.0);
        Coordinate q2 = new Coordinate(10.0, 20.0);
        Coordinate x = new Coordinate(15.0, 15.0);
        lineIntersector.computeIntersection(p1, p2, q1, q2);
        lineIntersector.getIntersectionNum();
        lineIntersector.getIntersection(0);
        lineIntersector.isProper();
        lineIntersector.hasIntersection();
        p1 = new Coordinate(10.0, 10.0);
        p2 = new Coordinate(20.0, 10.0);
        q1 = new Coordinate(22.0, 10.0);
        q2 = new Coordinate(30.0, 10.0);
        lineIntersector.computeIntersection(p1, p2, q1, q2);
        lineIntersector.isProper();
        lineIntersector.hasIntersection();
        p1 = new Coordinate(10.0, 10.0);
        p2 = new Coordinate(20.0, 10.0);
        q1 = new Coordinate(20.0, 10.0);
        q2 = new Coordinate(30.0, 10.0);
        lineIntersector.computeIntersection(p1, p2, q1, q2);
        lineIntersector.isProper();
        lineIntersector.hasIntersection();
        p1 = new Coordinate(10.0, 10.0);
        p2 = new Coordinate(20.0, 10.0);
        q1 = new Coordinate(15.0, 10.0);
        q2 = new Coordinate(30.0, 10.0);
        lineIntersector.computeIntersection(p1, p2, q1, q2);
        lineIntersector.isProper();
        lineIntersector.hasIntersection();
        p1 = new Coordinate(30.0, 10.0);
        p2 = new Coordinate(20.0, 10.0);
        q1 = new Coordinate(10.0, 10.0);
        q2 = new Coordinate(30.0, 10.0);
        lineIntersector.computeIntersection(p1, p2, q1, q2);
        lineIntersector.hasIntersection();
        lineIntersector.computeIntersection(new Coordinate(100.0, 100.0), new Coordinate(10.0, 100.0), new Coordinate(100.0, 10.0), new Coordinate(100.0, 100.0));
        lineIntersector.hasIntersection();
        lineIntersector.getIntersectionNum();
        lineIntersector.computeIntersection(new Coordinate(190.0, 50.0), new Coordinate(120.0, 100.0), new Coordinate(120.0, 100.0), new Coordinate(50.0, 150.0));
        lineIntersector.hasIntersection();
        lineIntersector.getIntersectionNum();
        lineIntersector.getIntersection(1);
        lineIntersector.computeIntersection(new Coordinate(180.0, 200.0), new Coordinate(160.0, 180.0), new Coordinate(220.0, 240.0), new Coordinate(140.0, 160.0));
        lineIntersector.hasIntersection();
        lineIntersector.getIntersectionNum();
        lineIntersector.computeIntersection(new Coordinate(30.0, 10.0), new Coordinate(30.0, 30.0), new Coordinate(10.0, 10.0), new Coordinate(90.0, 11.0));
        lineIntersector.hasIntersection();
        lineIntersector.getIntersectionNum();
        lineIntersector.isProper();
        lineIntersector.computeIntersection(new Coordinate(10.0, 30.0), new Coordinate(10.0, 0.0), new Coordinate(11.0, 90.0), new Coordinate(10.0, 10.0));
        lineIntersector.hasIntersection();
        lineIntersector.getIntersectionNum();
        lineIntersector.isProper();
    }
}

