/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;
import test.jts.perf.algorithm.IntersectionAlgorithms;

public class IntersectionStressTest {
    private static final int MAX_ITER = 1000;
    private static final double ORDINATE_MAGNITUDE = 1000000.0;
    private static final double SEG_LEN = 100.0;
    static Random randGen = new Random(123456L);
    Map<String, Double> distMap = new HashMap<String, Double>();
    private boolean verbose = false;

    public static void main(String[] args) {
        IntersectionStressTest test = new IntersectionStressTest();
        test.run();
    }

    private void run() {
        this.run(0.9);
        this.run(0.999);
        this.run(0.999999);
        this.run(0.99999999);
    }

    private void run(double incidentAngleFactor) {
        for (int i = 0; i < 1000; ++i) {
            this.doIntersectionTest(i, incidentAngleFactor);
        }
        System.out.println("\nIncident angle factor = " + incidentAngleFactor);
        this.printAverage();
    }

    private void doIntersectionTest(int i, double incidentAngleFactor) {
        Coordinate basePt = this.randomCoordinate();
        double baseAngle = Math.PI * 2 * randGen.nextDouble();
        Coordinate p1 = this.computeVector(basePt, baseAngle, 10.0);
        Coordinate p2 = this.computeVector(basePt, baseAngle, 110.00000000000001);
        double angleBetween = baseAngle + incidentAngleFactor * Math.PI;
        Coordinate q1 = this.computeVector(basePt, angleBetween, 10.0);
        Coordinate q2 = this.computeVector(basePt, angleBetween, 110.00000000000001);
        Coordinate intPt = IntersectionAlgorithms.intersectionBasic(p1, p2, q1, q2);
        Coordinate intPtDD = CGAlgorithmsDD.intersection(p1, p2, q1, q2);
        Coordinate intPtCB = IntersectionAlgorithms.intersectionCB(p1, p2, q1, q2);
        Coordinate intPtCond = Intersection.intersection(p1, p2, q1, q2);
        if (this.verbose) {
            System.out.println(i + ":  Lines: " + WKTWriter.toLineString(p1, p2) + "  -  " + WKTWriter.toLineString(q1, q2));
        }
        this.printStats("DP    ", intPt, p1, p2, q1, q2);
        this.printStats("CB    ", intPtCB, p1, p2, q1, q2);
        this.printStats("Cond  ", intPtCond, p1, p2, q1, q2);
        this.printStats("DD    ", intPtDD, p1, p2, q1, q2);
    }

    private void printStats(String tag, Coordinate intPt, Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        double distP = Distance.pointToLinePerpendicular(intPt, p1, p2);
        double distQ = Distance.pointToLinePerpendicular(intPt, q1, q2);
        this.addStat(tag, distP);
        this.addStat(tag, distQ);
        if (this.verbose) {
            System.out.println(tag + " : " + WKTWriter.toPoint(intPt) + " -- Dist P = " + distP + "    Dist Q = " + distQ);
        }
    }

    private void addStat(String tag, double dist) {
        double distTotal = 0.0;
        if (this.distMap.containsKey(tag)) {
            distTotal = this.distMap.get(tag);
        }
        this.distMap.put(tag, distTotal += dist);
    }

    private void printAverage() {
        System.out.println("Average distance from lines");
        for (String key : this.distMap.keySet()) {
            double distTotal = this.distMap.get(key);
            double avg = distTotal / 1000.0;
            System.out.println(key + " : " + avg);
        }
    }

    private Coordinate computeVector(Coordinate basePt, double angle, double len) {
        double x = basePt.getX() + len * Math.cos(angle);
        double y = basePt.getY() + len * Math.sin(angle);
        return new Coordinate(x, y);
    }

    private Coordinate randomCoordinate() {
        double x = 1000000.0 * randGen.nextDouble();
        double y = 1000000.0 * randGen.nextDouble();
        return new Coordinate(x, y);
    }
}

