/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.DD;
import test.jts.GeometryTestCase;

public class DDOrientationIndexCorrectTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(DDOrientationIndexCorrectTest.class);
    }

    public DDOrientationIndexCorrectTest(String name) {
        super(name);
    }

    public void testPointCloseToLine() {
        Coordinate[] pts = new Coordinate[]{new Coordinate(2.4829102, 48.8726807), new Coordinate(2.4832535, 48.8737106), new Coordinate(2.4830818249999997, 48.873195575)};
        int orientDD = this.runDD("Orginal case", pts);
        Coordinate[] ptsScale = new Coordinate[]{new Coordinate(2.4829102E7, 4.88726807E8), new Coordinate(2.4832535E7, 4.88737106E8), new Coordinate(2.4830818249999996E7, 4.8873195575E8)};
        int orientSC = this.runDD("Scaled case", ptsScale);
        Coordinate[] ptsLowPrec = new Coordinate[]{new Coordinate(0.4829102, 0.8726807), new Coordinate(0.4832535, 0.8737106), new Coordinate(0.4830818249999997, 0.873195575)};
        int orientLP = this.runDD("Lower precision case", ptsLowPrec);
        Coordinate[] ptOnLineScaled = new Coordinate[]{new Coordinate(2.4829102E7, 4.88726807E8), new Coordinate(2.4832535E7, 4.88737106E8), new Coordinate(2.483081825E7, 4.8873195575E8)};
        int orientOLSC = this.runDD("On-line scaled case", ptOnLineScaled);
        DDOrientationIndexCorrectTest.assertTrue((orientOLSC == 0 ? 1 : 0) != 0);
        Coordinate[] ptOnLine = new Coordinate[]{new Coordinate(2.4829102, 48.8726807), new Coordinate(2.4832535, 48.8737106), new Coordinate(2.483081825, 48.873195575)};
        int orientOL = this.runDD("On-line case", ptOnLine);
        DDOrientationIndexCorrectTest.assertTrue((String)"Orignal index not equal to lower-precision index", (orientDD == orientLP ? 1 : 0) != 0);
    }

    private int runDD(String desc, Coordinate[] pts) {
        int orientDD = Orientation.index(pts[0], pts[1], pts[2]);
        System.out.println(desc + " --------------");
        System.out.println("DD: " + orientDD);
        return orientDD;
    }

    public static int orientationIndexAlt(Coordinate p1, Coordinate p2, Coordinate q) {
        DD dx1 = DDOrientationIndexCorrectTest.toDDAlt(p2.x).selfAdd(DDOrientationIndexCorrectTest.toDDAlt(-p1.x));
        DD dy1 = DDOrientationIndexCorrectTest.toDDAlt(p2.y).selfAdd(DDOrientationIndexCorrectTest.toDDAlt(-p1.y));
        DD dx2 = DDOrientationIndexCorrectTest.toDDAlt(q.x).selfAdd(DDOrientationIndexCorrectTest.toDDAlt(-p2.x));
        DD dy2 = DDOrientationIndexCorrectTest.toDDAlt(q.y).selfAdd(DDOrientationIndexCorrectTest.toDDAlt(-p2.y));
        DD det = dx1.selfMultiply(dy2).selfSubtract(dy1.selfMultiply(dx2));
        return det.signum();
    }

    private static DD toDDAlt(double x) {
        return DD.valueOf(x + "");
    }
}

