/*
 * Decompiled with CFR 0.152.
 */
package test.jts.index;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.STRtree;

public class STRtreeDemo {
    private static final double EXTENT = 100.0;
    private static final double MAX_ITEM_EXTENT = 15.0;
    private static final double MIN_ITEM_EXTENT = 3.0;
    private static final int ITEM_COUNT = 20;
    private static final int NODE_CAPACITY = 4;
    private static GeometryFactory factory = new GeometryFactory();

    private static void initTree(TestTree t, List sourceEnvelopes) {
        for (Envelope sourceEnvelope : sourceEnvelopes) {
            t.insert(sourceEnvelope, (Object)sourceEnvelope);
        }
        t.build();
    }

    public static void main(String[] args) throws Exception {
        List envelopes = STRtreeDemo.sourceData();
        TestTree t = new TestTree(4);
        STRtreeDemo.initTree(t, envelopes);
        PrintStream printStream = System.out;
        STRtreeDemo.printSourceData(envelopes, printStream);
        STRtreeDemo.printLevels(t, printStream);
    }

    public static void printSourceData(List sourceEnvelopes, PrintStream out) {
        out.println("============ Source Data ============\n");
        out.print("GEOMETRYCOLLECTION(");
        boolean first = true;
        for (Envelope e : sourceEnvelopes) {
            Polygon g = factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMinY())}), null);
            if (first) {
                first = false;
            } else {
                out.print(",");
            }
            out.print(g);
        }
        out.println(")\n");
    }

    private static List sourceData() {
        ArrayList<Envelope> envelopes = new ArrayList<Envelope>();
        for (int i = 0; i < 20; ++i) {
            envelopes.add(STRtreeDemo.randomRectangle().getEnvelopeInternal());
        }
        return envelopes;
    }

    private static Polygon randomRectangle() {
        double width = 3.0 + 12.0 * Math.random();
        double height = 3.0 + 12.0 * Math.random();
        double bottom = 100.0 * Math.random();
        double left = 100.0 * Math.random();
        double top = bottom + height;
        double right = left + width;
        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(left, bottom), new Coordinate(right, bottom), new Coordinate(right, top), new Coordinate(left, top), new Coordinate(left, bottom)}), null);
    }

    public static void printLevels(TestTree t, PrintStream out) {
        for (int i = 0; i <= t.getRoot().getLevel(); ++i) {
            STRtreeDemo.printBoundables(t.boundablesAtLevel(i), "Level " + i, out);
        }
    }

    public static void printBoundables(List boundables, String title, PrintStream out) {
        out.println("============ " + title + " ============\n");
        out.print("GEOMETRYCOLLECTION(");
        boolean first = true;
        for (Boundable boundable : boundables) {
            if (first) {
                first = false;
            } else {
                out.print(",");
            }
            out.print(STRtreeDemo.toString(boundable));
        }
        out.println(")\n");
    }

    private static String toString(Boundable b) {
        return "POLYGON((" + STRtreeDemo.envelope(b).getMinX() + " " + STRtreeDemo.envelope(b).getMinY() + ", " + STRtreeDemo.envelope(b).getMinX() + " " + STRtreeDemo.envelope(b).getMaxY() + ", " + STRtreeDemo.envelope(b).getMaxX() + " " + STRtreeDemo.envelope(b).getMaxY() + ", " + STRtreeDemo.envelope(b).getMaxX() + " " + STRtreeDemo.envelope(b).getMinY() + "," + STRtreeDemo.envelope(b).getMinX() + " " + STRtreeDemo.envelope(b).getMinY() + "))";
    }

    private static Envelope envelope(Boundable b) {
        return (Envelope)b.getBounds();
    }

    public static class TestTree
    extends STRtree {
        public TestTree(int nodeCapacity) {
            super(nodeCapacity);
        }

        @Override
        public List boundablesAtLevel(int level) {
            return super.boundablesAtLevel(level);
        }

        @Override
        public AbstractNode getRoot() {
            return this.root;
        }

        @Override
        public List createParentBoundables(List verticalSlice, int newLevel) {
            return super.createParentBoundables(verticalSlice, newLevel);
        }

        @Override
        public List[] verticalSlices(List childBoundables, int size) {
            return super.verticalSlices(childBoundables, size);
        }

        @Override
        public List createParentBoundablesFromVerticalSlice(List childBoundables, int newLevel) {
            return super.createParentBoundablesFromVerticalSlice(childBoundables, newLevel);
        }
    }
}

