/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.shape.fractal.HilbertCode;
import org.locationtech.jts.shape.fractal.MortonCode;

public class HilbertCodeTest
extends TestCase {
    public HilbertCodeTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(HilbertCodeTest.class);
    }

    public void testSize() {
        HilbertCodeTest.assertEquals((int)HilbertCode.size(0), (int)1);
        HilbertCodeTest.assertEquals((int)HilbertCode.size(1), (int)4);
        HilbertCodeTest.assertEquals((int)HilbertCode.size(2), (int)16);
        HilbertCodeTest.assertEquals((int)HilbertCode.size(3), (int)64);
        HilbertCodeTest.assertEquals((int)HilbertCode.size(4), (int)256);
        HilbertCodeTest.assertEquals((int)HilbertCode.size(5), (int)1024);
        HilbertCodeTest.assertEquals((int)HilbertCode.size(6), (int)4096);
    }

    public void testLevel() {
        HilbertCodeTest.assertEquals((int)MortonCode.level(1), (int)0);
        HilbertCodeTest.assertEquals((int)MortonCode.level(2), (int)1);
        HilbertCodeTest.assertEquals((int)MortonCode.level(3), (int)1);
        HilbertCodeTest.assertEquals((int)MortonCode.level(4), (int)1);
        HilbertCodeTest.assertEquals((int)MortonCode.level(5), (int)2);
        HilbertCodeTest.assertEquals((int)MortonCode.level(13), (int)2);
        HilbertCodeTest.assertEquals((int)MortonCode.level(15), (int)2);
        HilbertCodeTest.assertEquals((int)MortonCode.level(16), (int)2);
        HilbertCodeTest.assertEquals((int)MortonCode.level(17), (int)3);
        HilbertCodeTest.assertEquals((int)MortonCode.level(63), (int)3);
        HilbertCodeTest.assertEquals((int)MortonCode.level(64), (int)3);
        HilbertCodeTest.assertEquals((int)MortonCode.level(65), (int)4);
        HilbertCodeTest.assertEquals((int)MortonCode.level(255), (int)4);
        HilbertCodeTest.assertEquals((int)MortonCode.level(255), (int)4);
        HilbertCodeTest.assertEquals((int)MortonCode.level(256), (int)4);
    }

    public void testDecode() {
        this.checkDecode(1, 0, 0, 0);
        this.checkDecode(1, 0, 0, 0);
        this.checkDecode(1, 1, 0, 1);
        this.checkDecode(3, 0, 0, 0);
        this.checkDecode(3, 1, 0, 1);
        this.checkDecode(4, 0, 0, 0);
        this.checkDecode(4, 1, 1, 0);
        this.checkDecode(4, 24, 6, 2);
        this.checkDecode(4, 255, 15, 0);
        this.checkDecode(5, 124, 8, 6);
    }

    public void testDecodeEncode() {
        this.checkDecodeEncodeForLevel(4);
        this.checkDecodeEncodeForLevel(5);
    }

    private void checkDecode(int order, int index, int x, int y) {
        Coordinate p = HilbertCode.decode(order, index);
        HilbertCodeTest.assertEquals((int)((int)p.getX()), (int)x);
        HilbertCodeTest.assertEquals((int)((int)p.getY()), (int)y);
    }

    private void checkDecodeEncodeForLevel(int level) {
        int n = HilbertCode.size(level);
        for (int i = 0; i < n; ++i) {
            this.checkDecodeEncode(level, i);
        }
    }

    private void checkDecodeEncode(int level, int index) {
        Coordinate p = HilbertCode.decode(level, index);
        int encode = HilbertCode.encode(level, (int)p.getX(), (int)p.getY());
        HilbertCodeTest.assertEquals((int)index, (int)encode);
    }
}

