/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import test.jts.GeometryTestCase;

public class GeometryPrecisionReducerPointwiseTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(GeometryPrecisionReducerPointwiseTest.class);
    }

    public GeometryPrecisionReducerPointwiseTest(String name) {
        super(name);
    }

    public void testLineWithCollapse() throws Exception {
        this.checkReducePointwise("LINESTRING (0 0,  0.1 0,  1 0)", "LINESTRING (0 0,  0   0,  1 0)");
    }

    public void testLineDuplicatePointsPreserved() throws Exception {
        this.checkReducePointwise("LINESTRING (0 0,  0.1 0,  0.1 0,  1 0, 1 0)", "LINESTRING (0 0,  0   0,  0   0,  1 0, 1 0)");
    }

    public void testLineFullCollapse() throws Exception {
        this.checkReducePointwise("LINESTRING (0 0,  0.1 0)", "LINESTRING (0 0,  0   0)");
    }

    public void testPolygonFullCollapse() throws Exception {
        this.checkReducePointwise("POLYGON ((0.1 0.3, 0.3 0.3, 0.3 0.1, 0.1 0.1, 0.1 0.3))", "POLYGON ((0 0, 0 0, 0 0, 0 0, 0 0))");
    }

    public void testPolygonWithCollapsedLine() throws Exception {
        this.checkReducePointwise("POLYGON ((10 10, 100 100, 200 10.1, 300 10, 10 10))", "POLYGON ((10 10, 100 100, 200 10,   300 10, 10 10))");
    }

    public void testPolygonWithCollapsedPoint() throws Exception {
        this.checkReducePointwise("POLYGON ((10 10, 100 100, 200 10.1, 300 100, 400 10, 10 10))", "POLYGON ((10 10, 100 100, 200 10,   300 100, 400 10, 10 10))");
    }

    private void checkReducePointwise(String wkt, String wktExpected) {
        Geometry g = this.read(wkt);
        Geometry gExpected = this.read(wktExpected);
        PrecisionModel pm = new PrecisionModel(1.0);
        Geometry gReduce = GeometryPrecisionReducer.reducePointwise(g, pm);
        this.assertEqualsExactAndHasSameFactory(gExpected, gReduce);
    }

    private void assertEqualsExactAndHasSameFactory(Geometry expected, Geometry actual) {
        this.checkEqual(expected, actual);
        GeometryPrecisionReducerPointwiseTest.assertTrue((String)"Factories are not the same", (expected.getFactory() == actual.getFactory() ? 1 : 0) != 0);
    }
}

