/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.PolygonNode;
import test.jts.GeometryTestCase;

public class PolygonNodeTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(PolygonNodeTest.class);
    }

    public PolygonNodeTest(String name) {
        super(name);
    }

    public void testCrossing() {
        this.checkValid("LINESTRING (500 1000, 1000 1000, 1000 1500)", "LINESTRING (1000 500, 1000 1000, 500 1500)", false);
    }

    public void testValidQuadrant2() {
        this.checkValid("LINESTRING (500 1000, 1000 1000, 1000 1500)", "LINESTRING (300 1200, 1000 1000, 500 1500)");
    }

    public void testValidQuadrant4() {
        this.checkValid("LINESTRING (500 1000, 1000 1000, 1000 1500)", "LINESTRING (1000 500, 1000 1000, 1500 1000)");
    }

    private void checkValid(String wktA, String wktB) {
        this.checkValid(wktA, wktB, true);
    }

    private void checkValid(String wktA, String wktB, boolean isExpectedValid) {
        Coordinate[] b;
        Coordinate[] a = this.readPts(wktA);
        boolean isValid = !PolygonNode.isCrossing(a[1], a[0], a[2], (b = this.readPts(wktB))[0], b[2]);
        PolygonNodeTest.assertTrue((isValid == isExpectedValid ? 1 : 0) != 0);
    }

    private Coordinate[] readPts(String wkt) {
        LineString line = (LineString)this.read(wkt);
        return line.getCoordinates();
    }
}

