/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.util.Assert;

public class LineMergerTest
extends TestCase {
    private static WKTReader reader = new WKTReader();

    public LineMergerTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(LineMergerTest.class);
    }

    public void test1() {
        this.doTest(new String[]{"LINESTRING (120 120, 180 140)", "LINESTRING (200 180, 180 140)", "LINESTRING (200 180, 240 180)"}, new String[]{"LINESTRING (120 120, 180 140, 200 180, 240 180)"});
    }

    public void test2() {
        this.doTest(new String[]{"LINESTRING (120 300, 80 340)", "LINESTRING (120 300, 140 320, 160 320)", "LINESTRING (40 320, 20 340, 0 320)", "LINESTRING (0 320, 20 300, 40 320)", "LINESTRING (40 320, 60 320, 80 340)", "LINESTRING (160 320, 180 340, 200 320)", "LINESTRING (200 320, 180 300, 160 320)"}, new String[]{"LINESTRING (160 320, 180 340, 200 320, 180 300, 160 320)", "LINESTRING (40 320, 20 340, 0 320, 20 300, 40 320)", "LINESTRING (40 320, 60 320, 80 340, 120 300, 140 320, 160 320)"});
    }

    public void test3() {
        this.doTest(new String[]{"LINESTRING (0 0, 100 100)", "LINESTRING (0 100, 100 0)"}, new String[]{"LINESTRING (0 0, 100 100)", "LINESTRING (0 100, 100 0)"});
    }

    public void test4() {
        this.doTest(new String[]{"LINESTRING EMPTY", "LINESTRING EMPTY"}, new String[0]);
    }

    public void test5() {
        this.doTest(new String[0], new String[0]);
    }

    public void testSingleUniquePoint() {
        this.doTest(new String[]{"LINESTRING (10642 31441, 10642 31441)", "LINESTRING EMPTY"}, new String[0]);
    }

    private void doTest(String[] inputWKT, String[] expectedOutputWKT) {
        LineMergerTest.doTest(inputWKT, expectedOutputWKT, true);
    }

    public static void doTest(String[] inputWKT, String[] expectedOutputWKT, boolean compareDirections) {
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(LineMergerTest.toGeometries(inputWKT));
        LineMergerTest.compare(LineMergerTest.toGeometries(expectedOutputWKT), lineMerger.getMergedLineStrings(), compareDirections);
    }

    public static void compare(Collection expectedGeometries, Collection actualGeometries, boolean compareDirections) {
        LineMergerTest.assertEquals((String)("Geometry count, " + actualGeometries), (int)expectedGeometries.size(), (int)actualGeometries.size());
        for (Geometry expectedGeometry : expectedGeometries) {
            LineMergerTest.assertTrue((String)("Not found: " + expectedGeometry + ", " + actualGeometries), (boolean)LineMergerTest.contains(actualGeometries, expectedGeometry, compareDirections));
        }
    }

    private static boolean contains(Collection geometries, Geometry g, boolean exact) {
        for (Geometry element : geometries) {
            if (exact && element.equalsExact(g)) {
                return true;
            }
            if (exact || !element.equalsTopo(g)) continue;
            return true;
        }
        return false;
    }

    public static Collection toGeometries(String[] inputWKT) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < inputWKT.length; ++i) {
            try {
                geometries.add(reader.read(inputWKT[i]));
                continue;
            }
            catch (ParseException e) {
                Assert.shouldNeverReachHere();
            }
        }
        return geometries;
    }
}

